/*
 * Copyright (C) 1990 Commodore-Amiga, Inc.
 * All rights reserved
 */


/* This is an example of the command-line processing for a print program */
/* Compiled with Lattice C 5.05: lc -cfist -v -L readargs.c */

#include <exec/types.h>
#include <dos/dos.h>
#include <dos/rdargs.h>
#include <clib/dos_protos.h>

/* normally you'ld include pragmas here */

#define TEMPLATE          "Files/M/A,Header/K,Spool/S,Page=PageNumber/K/N"
#define OPT_FILES         0
#define OPT_HEADER        1
#define OPT_SPOOL         2
#define OPT_PAGE          3
#define OPT_COUNT         4

LONG opts[OPT_COUNT];		/* C guarantees this will be all 0's! */

int main (int, char **);

int
main (argc,argv)
	int argc;
	char **argv;
{
	struct RDArgs *argsptr;
	char **sptr;


      /*==================================================================*/
      /* If ReadArgs() sees anything but zeros passed to it in elements   */
      /* of this array, ReadArgs() will assume that they are defaults.    */
      /*==================================================================*/
      argsptr = ReadArgs(TEMPLATE, opts, NULL);

      /*=================================================================*/
      /* argsptr will be NULL if ReadArgs() failed, the secondary result */
      /* code is fetched by IoErr().                                     */
      /*=================================================================*/
      if (argsptr == NULL)
      {
        PrintFault(IoErr(), NULL);	/* prints the appropriate err message */
	return RETURN_ERROR;
      }
      else
      {
	sptr = (char **) (opts[OPT_FILES]);
        if (!sptr)
		/* this can never actually happen, due to /A */
		VPrintf("No files specified!\n",NULL);
	else {
		VPrintf("files specified:\n",NULL);

		/* last string ptr is NULL */
		while (*sptr)
		{
			/* VPrintf takes a ptr to an array of arguments! */
			VPrintf("\t%s\n",(LONG *) sptr);
			sptr++;
		}
	}

	/* if option was not specified, it will be NULL (since buffer started */
	/* with opt[] array all NULL).					      */

	if (opts[OPT_HEADER])
	{
		/* remember, opts[OPT_HEADER] has a string ptr, and */
		/* VPrintf wants a pointer to that pointer.         */
		VPrintf("Header is '%s'\n",&(opts[OPT_HEADER]));
	}

	if (opts[OPT_SPOOL])
	{
		VPrintf("Spooling selected\n",NULL);
	}

	if (opts[OPT_PAGE])
	{
		/* the actual number can be accessed by
			*((LONG *) opts[OPT_PAGE])
		*/
		VPrintf("Asked to print page %ld\n",(LONG *) (opts[OPT_PAGE]));
	}

	/* normally the meat of the program would go here */

	/* cleanup */
	FreeArgs(argsptr);
      }

      return RETURN_OK;		/* program succeeded */
}
