/*
 * Copyright (C) 1990 Commodore-Amiga, Inc.
 * All rights reserved
 */

/* Example of DOS pattern matching calls.
 * Compiled with Lattice C 5.05: lc -cfist -v -L pattern.c
 */

#include <exec/types.h>
#include <exec/execbase.h>
#include <dos/dos.h>
#include <dos/dosextens.h>
#include <dos/dosasl.h>
#include <clib/dos_protos.h>

#include <stdio.h>

struct AnchorPath MyAp;

int main(int, char **);

int
main(argc,argv)
	int	argc;
	char	*argv[];
{
	LONG	retval = RETURN_ERROR;

	if (argc != 2 )
	{
	    printf("Usage: %s <pattern>\n",argv[0]);
	    return retval;
	}

	printf("Searching directory tree for pattern %s\n",argv[1]);

	/* Initialize the AnchorPath structure	*/
	MyAp.ap_BreakBits = SIGBREAKF_CTRL_C; /* Break on these bits	*/

	for (retval = MatchFirst(argv[1],&MyAp);
	     retval == 0;
	     retval = MatchNext(&MyAp))
	{

	/* This code section deals with ALL and directory ascent/descent */
		if (MyAp.ap_Info.fib_DirEntryType > 0)
		{
		    if (MyAp.ap_Flags & APF_DIDDIR)
			printf("Ascending from directory %s\n",
				&(MyAp.ap_Info.fib_FileName));
		    else {
			printf("Entering directory %s\n",
				&(MyAp.ap_Info.fib_FileName));

			/* make it enter the directory */
			MyAp.ap_Flags |= APF_DODIR;
		    }
		    /* clear the completed directory flag */
		    MyAp.ap_Flags &= ~APF_DIDDIR;

		} else {
		    /* Here is code for handling each particular file */
		    printf("The next file is ... %s\n",
			   &(MyAp.ap_Info.fib_FileName));
		}
	}

    /* This absolutely, positively must be called, all of the time. */
    MatchEnd(&MyAp);

    /* Check for error, if so, print error message */
    if (retval != ERROR_NO_MORE_ENTRIES)
    {
	printf("%s failed because Error code %ld\n",argv[0],retval);
	PrintFault(retval,NULL);
    }
}

