/*
 * Copyright (C) 1990 Commodore-Amiga, Inc.
 * All rights reserved
 */


/* An example of how to use ExAll.
 * Compiled with Lattice C 5.05: lc -cfist -v -L exall.c
 *
 * Warning: the prototype for ExAll() should be:
 *
 * LONG ExAll( BPTR, struct ExAllData *, long, long, 
 *             struct ExAllControl * );
 */

#include <exec/types.h>
#include <exec/ports.h>
#include <exec/memory.h>
#include <dos/dos.h>
#include <dos/dosextens.h>
#include <dos/exall.h>
#include <clib/dos_protos.h>
#include <clib/exec_protos.h>

/* normally you'ld include pragmas here */

#define BUFFSIZE 2048

int main(int, char **);

int
main(argc,argv)
	int argc;
	char *argv[];
{
	BPTR obj_lock;
	LONG res2,more = TRUE;
	struct ExAllData *Buffer = NULL,*ead;
	struct ExAllControl *control = NULL;
	LONG rc = RETURN_ERROR;

  /* ugly argument parsing */
  if( argc == 2 ) {

	/* control MUST be allocated by AllocDosObject! */
	control=(struct ExAllControl *) AllocDosObject(DOS_EXALLCONTROL,NULL);
	Buffer=(struct ExAllData *) AllocMem(BUFFSIZE,MEMF_PUBLIC|MEMF_CLEAR);

	/* always check allocations! */
	if (!control || !Buffer)
		goto cleanup;

	/* lock the directory */
	if (obj_lock = Lock(argv[1],SHARED_LOCK)) {

	  control->eac_LastKey = 0;	/* paranoia */

	  do { /* while more */

	    more = ExAll(obj_lock,Buffer,BUFFSIZE,ED_TYPE,control);
	    res2 = IoErr();
	    if (!more && res2 != ERROR_NO_MORE_ENTRIES)
	    {
		VPrintf("Abnormal exit, error = %ld\n",&res2);
		break;
	    }

	    /* remember, VPrintf wants a pointer to arguments! */
	    VPrintf("Returned %ld entries:\n\n",&(control->eac_Entries));

	    if (control->eac_Entries)
	    {
		ead = Buffer;
		do {
			VPrintf("%s",(LONG *) &(ead->ed_Name));
			if (ead->ed_Type > 0)
				PutStr(" (dir)\n");
			else
				PutStr(" (file)\n");

			ead = ead->ed_Next;
		} while (ead);
	    }

	    rc = RETURN_OK;	/* success */

	  } while (more);

	  UnLock(obj_lock);

	} else VPrintf("Couldn't find %s\n",(LONG *) &(argv[1]));

cleanup:
	if (Buffer)  FreeMem(Buffer,BUFFSIZE);
	if (control) FreeDosObject(DOS_EXALLCONTROL,control);

	return(rc);

    } else {
      VPrintf("Usage: %s dirname\n",(LONG *) &(argv[0]));
      return(rc);
    }
}

