/* apsh_main.c */
BOOL HandleApp (int, char **, struct WBStartup *, struct TagItem *);
BOOL HandleAppAsync (struct TagItem * anchor, struct MsgPort * sipc);
struct AppInfo *InitAppInfo (struct Funcs * ft);
VOID FreeAppInfo (struct AppInfo * ai);
BOOL HandlerFunc ( struct AppInfo *ai , ULONG tags , ...);
BOOL HandlerFuncA ( struct AppInfo *ai , struct TagItem *tl );
APTR HandlerData ( struct AppInfo *ai , ULONG tags , ...);
APTR HandlerDataA ( struct AppInfo *ai , struct TagItem *tl );
STRPTR GetText ( struct AppInfo *ai , ULONG base , ULONG tid , STRPTR def );
STRPTR PrepText __ARGS(( struct AppInfo *ai , ULONG base , ULONG tid , char *, ...));
STRPTR BuildParseLine (STRPTR line, ULONG *argc, STRPTR *argv);
VOID FreeParseLine (STRPTR);
ULONG ParseLine ( STRPTR line , STRPTR *argv );
STRPTR FindType ( STRPTR *array , STRPTR name , STRPTR defvalue );
BOOL MatchValue ( STRPTR type , STRPTR value );
BOOL QStrCmpI ( STRPTR, STRPTR );
VOID RemoveMsgPort (struct MsgPort *);
BOOL NotifyUser ( struct AppInfo *, STRPTR, struct TagItem *);
VOID APSHSetWaitPointer (struct AppInfo *, struct TagItem *);
VOID APSHClearPointer (struct AppInfo *, struct TagItem *);

/* apsh_lib.c */
BOOL OpenLibraries ( struct AppInfo *ai , struct TagItem *ObjAttrs );
VOID CloseLibraries ( struct AppInfo *ai , struct TagItem *ObjAttrs );

/* apsh_msghandle.c */
BOOL AddMsgHandler ( struct AppInfo *ai , ULONG tags , ...);
BOOL AddMsgHandlerA ( struct AppInfo *ai , struct TagItem *tl );
VOID DelMsgHandlers ( struct AppInfo *ai );

/* apsh_dispatch.c */
struct AppInfo *ProcessMsgs ( struct AppInfo *ai );
BOOL PerfFunc (struct AppInfo * ai, ULONG fid, STRPTR cmd, struct TagItem * tl);

/* apsh_stdfuncs.c */
VOID AliasFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID DebugFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID DisableFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID EditFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID EnableFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID ExecMacroFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID FaultFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID GetFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID GroupFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID HelpFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID LearnFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID LoadMacroFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID PriorityFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID SaveMacroFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID SelectFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID SetFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID StatusFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID StopFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID StubFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID VersionFunc (struct AppInfo * ai, STRPTR args, struct TagItem * tl);

/* apsh_projmng.c */
BOOL GetBaseInfo (struct AppInfo *, int, char **, struct WBStartup *);
struct ProjNode *NewProject (struct AppInfo *, STRPTR, struct TagItem *);
BOOL RemoveProject (struct AppInfo * ai, STRPTR cmd, struct TagItem * tl);
BOOL AddProjects ( struct AppInfo *, LONG, struct WBArg *, struct TagItem *);
struct ProjNode *GetProjNode ( struct AppInfo *ai , LONG cnt , struct TagItem *);
VOID SwapProjNodes ( struct AppInfo *, struct ProjNode *, struct ProjNode *, struct TagItem *);
struct DiskObject *IconFromWBArg ( struct WBArg *arg );
VOID FreeProjects (struct AppInfo * ai, struct TagItem *);
VOID FreeProject (struct ProjNode *);

/* apsh_functable.c */
BOOL AddFuncEntry (struct AppInfo * ai, struct Funcs * sfe);
VOID FreeFuncEntry (struct AppInfo * ai, struct FuncEntry *fe);
BOOL AddFuncEntries (struct AppInfo * ai, struct Funcs * fels);
VOID FreeFuncEntries (struct AppInfo *ai);
struct FuncEntry *GetFuncEntry (struct AppInfo *, STRPTR, ULONG);
ULONG GetFuncID (struct AppInfo * ai, STRPTR anchor);
STRPTR GetFuncName (struct AppInfo * ai, ULONG id);

/* apsh_clonesipc.c */
struct MsgHandler *setup_apsh_sipcA ( struct AppInfo *ai , struct TagItem *tl );
BOOL handle_apsh_sipc ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL shutdown_apsh_sipc ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );

/* apsh_arexx.c */
struct MsgHandler *setup_arexx ( struct AppInfo *ai , ULONG tags , ...);
struct MsgHandler *setup_arexxA ( struct AppInfo *ai , struct TagItem *tl );
BOOL open_arexx ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL handle_arexx ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL close_arexx ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL shutdown_arexx ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL send_rexx_command ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
VOID execute_command ( struct RexxMsg *rmsg , struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
VOID reply_rexx_command ( struct RexxMsg *rmsg , struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
VOID RXFunc ( struct AppInfo *a , STRPTR args , struct TagItem *tl );
VOID WhyFunc ( struct AppInfo *a , STRPTR args , struct TagItem *tl );

/* apsh_dos.c */
struct MsgHandler *setup_dos ( struct AppInfo *ai , ULONG tags , ...);
struct MsgHandler *setup_dosA ( struct AppInfo *ai , struct TagItem *tl );
BOOL open_dos ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL handle_dos ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL close_dos ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL shutdown_dos ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
VOID DisplayPrompt ( struct MsgHandler *mh );
VOID send_read_packet ( struct StandardPacket *dos_message , BPTR console_fh , struct MsgPort *dos_reply_port , UBYTE *buff );
VOID CMDShellFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );

/* apsh_idcmp.c */
struct MsgHandler *setup_idcmp ( struct AppInfo *ai , ULONG tags , ...);
struct MsgHandler *setup_idcmpA ( struct AppInfo *ai , struct TagItem *tl );
BOOL open_idcmp ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL handle_idcmp ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL close_idcmp ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL shutdown_idcmp ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
VOID CloseWindowSafely ( struct Window *win );
BOOL setup_key_array ( struct MsgHandler *mh , struct KeyboardCMD *KeyArray );
VOID shutdown_key_array ( struct MsgHandler *mh );
VOID HandleKeyEvent ( struct AppInfo *ai , struct MsgHandler *mh , struct IntuiMessage *msg , struct TagItem *tl );
LONG DeadKeyConvert ( struct IntuiMessage *msg , UBYTE *kbuffer , LONG kbsize , struct KeyMap *kmap );
VOID HandleGadgEvent ( struct AppInfo *ai , struct MsgHandler *mh , struct IntuiMessage *msg , struct TagItem *tl );
VOID HandleMenuEvent ( struct AppInfo *ai , struct MsgHandler *mh , struct IntuiMessage *msg , struct TagItem *tl );
BOOL APSHGetGadgetInfo(struct AppInfo *, STRPTR, STRPTR, ULONG *, ULONG *);
BOOL APSHGetWindowInfo (struct AppInfo * ai, STRPTR wname, ULONG * window);

/* apsh_stdidcmp.c */
VOID ActivateFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID HotKeyFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID ToBackFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID ToFrontFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );
VOID WindowFunc ( struct AppInfo *ai , STRPTR args , struct TagItem *tl );

/* apsh_friclass.c --- subclass of frameiclass */
Class *initFrIClass (VOID);
int freeFrIClass (Class *cl);

/* apsh_textbclass.c (misnamed) --- subclass of frbuttonclass */
Class *initTextBClass (VOID);
freeTextBClass (Class * cl);

/* apsh_windef.c */
VOID PrepareWindowDef ( struct AppInfo *ai , struct IDCMPInfo *md , struct WinNode *wn, struct TagItem * );
BOOL ProcessInfo ( struct WinObjDefData *pwd , struct Object *objl, struct TagItem *tl );
struct ObjectNode *CreateObject ( struct WinObjDefData *pwd , struct Object *obj , struct TagItem *tl );
VOID AdjustInner ( struct Rectangle *rect , struct Object *obj, struct TagItem * );
VOID FreeWindowDef ( struct IDCMPInfo *md , struct WinNode *wn , struct TagItem * );

/* apsh_sipc.c */
struct MsgHandler *setup_sipc ( struct AppInfo *ai , ULONG tags , ...);
struct MsgHandler *setup_sipcA ( struct AppInfo *ai , struct TagItem *tl );
BOOL open_sipc ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL handle_sipc ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL close_sipc ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL shutdown_sipc ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL send_sipc_command ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL SendSIPCMessage ( STRPTR name , ULONG type , VOID *data );
BOOL SafePutToPort ( struct Message *message , STRPTR name );
BOOL SendSIPCMessageP (struct MsgPort *, struct MsgPort *, ULONG, VOID *);
APTR OpenSIPC (struct AppInfo * ai, STRPTR name, struct TagItem * tl);
APTR SIPCPrintf (APTR ash, APTR data,...);
APTR CloseSIPC (APTR ash, struct TagItem * tl);

/* apsh_tool.c */
struct MsgHandler *setup_tool ( struct AppInfo *ai , ULONG tags , ...);
struct MsgHandler *setup_toolA ( struct AppInfo *ai , struct TagItem *tl );
BOOL open_tool ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL handle_tool ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL close_tool ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );
BOOL shutdown_tool ( struct AppInfo *ai , struct MsgHandler *mh , struct TagItem *tl );

/* apsh_wb.c */
struct MsgHandler *setup_wbA (struct AppInfo * ai, struct TagItem * tl);
BOOL open_wb (struct AppInfo * ai, struct MsgHandler * mh, struct TagItem * tl);
BOOL handle_wb (struct AppInfo * ai, struct MsgHandler * mh, struct TagItem * tl);
BOOL close_wb (struct AppInfo * ai, struct MsgHandler * mh, struct TagItem * tl);
BOOL shutdown_wb (struct AppInfo * ai, struct MsgHandler * mh, struct TagItem * tl);

/* apsh_misc.asm */
int stricmpn (char *, char *, int);
struct Node * __asm FindNameI(register __a0 struct List *, register __a1 STRPTR);

/* memory debugging */
VOID showmem (STRPTR, BOOL);
VOID endshowmem (VOID);
#if 1
#define SHOWMEM(a)	;
#define SKIPMEM(a)	;
#define ENDMEM()	;
#else
#define SHOWMEM(a)	showmem(a, TRUE)
#define SKIPMEM(a)	showmem(a, FALSE)
#define ENDMEM()	endshowmem()
#endif