#define APPNAME "WatchMan"
#define APPVERS "WatchMan 1.13 (19-Jun-90)"
#define APPCOPY "Copyright (C) 1990 Commodore-Amiga, Inc."
#define APPAUTH "ec. walraven"


/* Protos */
VOID WMInitFunc         (struct AppInfo *, STRPTR, struct TagItem *);
VOID WMExitFunc         (struct AppInfo *, STRPTR, struct TagItem *);
VOID WMAboutFunc        (struct AppInfo *, STRPTR, struct TagItem *);

VOID FileNotification   (struct AppInfo *, STRPTR, struct TagItem *);

VOID SetFilenameFunc    (struct AppInfo *, STRPTR, struct TagItem *);
VOID SetRetriesFunc     (struct AppInfo *, STRPTR, struct TagItem *);
VOID SetIntervalFunc    (struct AppInfo *, STRPTR, struct TagItem *);
VOID SetFlagsFunc       (struct AppInfo *, STRPTR, struct TagItem *);

VOID GetFileFromListFunc(struct AppInfo *, STRPTR, struct TagItem *);

VOID AddTargetFunc      (struct AppInfo *, STRPTR, struct TagItem *);
VOID DelTargetFunc      (struct AppInfo *, STRPTR, struct TagItem *);
VOID SyncTargetFunc     (struct AppInfo *, STRPTR, struct TagItem *);
VOID InquiryTargetFunc  (struct AppInfo *, STRPTR, struct TagItem *);

VOID QuitFunc(struct AppInfo *ai, STRPTR str, struct TagItem *tl)
{
    ai->ai_Done = TRUE;
}

enum
{
    WM_DummyID = APSH_USER_ID,
    WM_AddID,      /* add button */
    WM_DelID,      /* del button */
    WM_SyncID,     /* sync button */
    WM_InquiryID,  /* inq button */
    WM_FilesID,    /* listview for files */
    WM_FlagsID,    /* flag list view */
    WM_RetriesID,  /* retry string */
    WM_IntervalID, /* interval integer string */
    WM_FilenameID, /* filename string */
    WM_ShowFlagsID, /* Show flag settings */
    WM_FileTextID,
    WM_InterTextID,
    WM_RetryTextID,
    WM_InitID,
    WM_ExitID,
    LAST_ID,
};

struct Funcs FTable[] =
{
    {"ADD",         AddTargetFunc,          WM_AddID,},
    {"DEL",         DelTargetFunc,          WM_DelID,},
    {"SYNC",        SyncTargetFunc,         WM_SyncID,},
    {"INQUIRY",     InquiryTargetFunc,      WM_InquiryID,},
    {"SETFILENAME", SetFilenameFunc,        WM_FilenameID,},
    {"GETFRMFLIST", GetFileFromListFunc,    WM_FilesID, NULL, NULL, APSH_FF_PRIVATE,},
    {"SETRET",      SetRetriesFunc,         WM_RetriesID,},
    {"SETINT",      SetIntervalFunc,        WM_IntervalID,},
    {"SETFLAGS",    SetFlagsFunc,           WM_FlagsID,},
    {"INIT",        WMInitFunc,             WM_InitID,NULL,NULL,APSH_FF_PRIVATE,},
    {"EXIT",        WMExitFunc,             WM_ExitID,NULL,NULL,APSH_FF_PRIVATE},
    {"ABOUT",       WMAboutFunc,            AboutID,},
    {"QUIT",        QuitFunc,               QuitID,},
    {NULL,          NO_FUNCTION,},
};

STRPTR wm_deftext[] = 
{
    NULL,
    APPVERS,
    "Targets",
    "Flags",
    "Filename",
    "Interval",
    "Retries",
    "Add Target",
    "Delete Target",
    "Sync Target",
    "Inquiry Target",
    NULL
};

struct NewMenu menus[] =
{
    {NM_TITLE, "Project",       0, 0, 0, 0, },
    {NM_ITEM,  "About",         0, 0, 0, V (AboutID), },
    {NM_ITEM,  "Quit",          "Q", 0, 0, V ( QuitID ), },
    {NM_TITLE, "Extras",        0, 0, 0, 0, },
    {NM_ITEM,  "Command Shell", "E", 0, 0, V ( CMDShellID ), },
    {NM_END, },
};

struct TagItem stringFlags[] =
{
    {APSH_GTFlags, PLACETEXT_ABOVE},
    {GTST_MaxChars, 512},
    {TAG_DONE,},
};

struct TagItem textFlags[] =
{
    {GTTX_Border, TRUE},
    {TAG_DONE,},
};

struct Object objects[] =
{
    {&objects[1], 0, OBJ_Window, NULL, NULL, NULL, "WMWINDOW", 1L, {1, 1, 0, 0}, },
    {&objects[2], 2, OBJ_Listview, WM_FilesID, NULL, NULL, "FILELIST", 2L, {11, 25, 158, 55}, },
    {&objects[3], 2, OBJ_Listview, WM_FlagsID, NULL, NULL, "FLAGLIST", 3L, {180, 25, 158, 55}, },
    {&objects[4], 2, OBJ_String, WM_FilenameID, NULL, NULL, "FSTRING", 4L, {11, 110, 178, 14}, stringFlags},
    {&objects[5], 1, OBJ_Integer, WM_IntervalID, NULL, NULL, "ISTRING",5L,     {209, 110, 108, 14}, stringFlags},
    {&objects[6], 1, OBJ_Integer, WM_RetriesID, NULL, NULL, "RSTRING",6L, {344, 110, 108, 14}, stringFlags},
    {&objects[7], 0, OBJ_Button, WM_AddID, NULL, 'a', "ADDBUTTON", 7L, {350, 25, 120, 16}, },
    {&objects[8], 0, OBJ_Button, WM_DelID, NULL, 'd', "DELBUTTON", 8L, {350, 40, 120, 16}, },
    {&objects[9], 0, OBJ_Button, WM_SyncID, NULL, 's', "SYNCBUTTON", 9L, {350, 55, 120, 16}, },
    {&objects[10], 0, OBJ_Button, WM_InquiryID, NULL, 'i', "INQBUTTON", 10L, {350, 70, 120, 16}, },
    {NULL, 0, OBJ_Text, WM_ShowFlagsID, NULL, NULL, "SHOWTEXT", 0
, {180, 80, 158, 20},textFlags},
};

struct TagItem winenv[] =
{
    {APSH_NameTag,   (ULONG)"MAIN"},
    {APSH_Objects,   (ULONG)objects},
    {APSH_GTMenu,    (ULONG)menus},
    {TAG_DONE,}
};

struct TagItem appwinenv[] = 
{
    {APSH_NameTag,   (ULONG)"MAIN"},    /* Window to be AppWindow */
    {APSH_CmdFlags,  APSH_WBF_NOLIST},  /* Don't update the project list */
    {APSH_AppDDrop,  WM_FilenameID},    /* ID of function to call on drop */
    {TAG_DONE,}
};

/* required libraries */
extern ULONG SysBase;
ULONG IntuitionBase;
ULONG GfxBase;
ULONG GadToolsBase;
ULONG LayersBase;
ULONG WorkbenchBase;

struct TagItem WM_Libs[] =
{
    {APSH_LibVersion, 36L},
    {APSH_LibStatus,  REQUIRED},
    {APSH_LibNameTag, APSH_Intuition},
    {APSH_LibBase,    &IntuitionBase},
    {APSH_LibNameTag, APSH_Gfx},
    {APSH_LibBase,    &GfxBase},
    {APSH_LibNameTag, APSH_GadTools},
    {APSH_LibBase,    &GadToolsBase},
    {APSH_LibNameTag, APSH_Layers},
    {APSH_LibBase,    &LayersBase},
    {APSH_LibStatus,  OPTIONAL},
    {APSH_LibNameTag, APSH_Workbench},
    {APSH_LibBase,    &WorkbenchBase},
    {TAG_DONE,}
};

/* message handler information */
struct TagItem Handle_SIPC[] =
{
    {APSH_Setup,    setup_sipcA},
    {APSH_Status,   P_ACTIVE | P_SINGLE},
    {APSH_Rating,   REQUIRED},
    {TAG_DONE,}
};

struct TagItem Handle_AREXX[] =
{
    {APSH_Setup,    setup_arexxA},
    {APSH_Extens,   (ULONG)"mod"},
    {APSH_Status,   P_ACTIVE | P_SINGLE},
    {APSH_Rating,   OPTIONAL},
    {TAG_DONE,}
};

struct TagItem Handle_DOS[] =
{
    {APSH_Setup,    setup_dosA},
    {APSH_Status,   P_INACTIVE},
    {APSH_Rating,   OPTIONAL},
    {APSH_Prompt,   (ULONG)"WM> "},
    {APSH_CMDWindow, (ULONG)"CON:0/100/600/50/WatchMan/CLOSE"},
    {TAG_DONE,}
};


struct TagItem Handle_WB[] = 
{
    {APSH_Setup,        setup_wbA},
    {APSH_AppWindowEnv, (ULONG)appwinenv},
    {APSH_Status,       P_ACTIVE},
    {APSH_Rating,       OPTIONAL},
    {TAG_DONE,}
};

struct TagItem Handle_FN[] =
{
    {APSH_Setup,     setup_fnA},
    {APSH_Status,    P_ACTIVE},
    {APSH_Rating,    OPTIONAL},
    {APSH_CmdData,   FileNotification},
    {TAG_DONE,}
};

struct TagItem Handle_IDCMP[] =
{
    {APSH_Setup,    setup_idcmpA},
    {APSH_WindowEnv,(ULONG)winenv},
    {APSH_Status,   P_ACTIVE},
    {APSH_Rating,   REQUIRED},
    {TAG_DONE,}
};

struct TagItem WM[] =
{
    {APSH_AppName,       (ULONG)APPNAME},
    {APSH_AppVersion,    (ULONG)APPVERS},
    {APSH_AppCopyright,  (ULONG)APPCOPY},
    {APSH_AppAuthor,     (ULONG)APPAUTH},
    {APSH_FuncTable,     (ULONG)FTable},
    {APSH_DefText,       (ULONG)wm_deftext},
    {APSH_OpenLibraries, (ULONG)WM_Libs},
    {APSH_AddHandler,    (ULONG)Handle_SIPC},
    {APSH_AddHandler,    (ULONG)Handle_IDCMP},
    {APSH_AddHandler,    (ULONG)Handle_AREXX},
    {APSH_AddHandler,    (ULONG)Handle_DOS},
    {APSH_AddHandler,    (ULONG)Handle_WB},
    {APSH_AddHandler,    (ULONG)Handle_FN},
    {APSH_AppInit,       (ULONG)WM_InitID},
    {APSH_AppExit,       (ULONG)WM_ExitID},
    {TAG_DONE,}
};
