/* $Id: fn_handler.h,v 1.8 90/06/22 12:41:24 ewout Exp Locker: ewout $
 * 
 * $Log:	fn_handler.h,v $
 * Revision 1.8  90/06/22  12:41:24  ewout
 * Changed to no longer use hardcoded callback function
 * 
 * Revision 1.7  90/06/12  14:39:34  ewout
 * changed FN_REMTARGET to FN_DELTARGET for consistency
 * 
 * Revision 1.6  90/06/08  17:59:37  ewout
 * appshell version
 * 
 * Revision 1.5  90/06/03  13:19:54  ewout
 * transition, don't use
 * 
 * Revision 1.4  90/05/23  21:04:08  ewout
 * semi-appshell DON'T USE
 * 
 * Revision 1.3  90/05/23  16:56:22  ewout
 * *** empty log message ***
 * 
 * Revision 1.2  90/05/21  17:03:58  ewout
 * Added FN_NEWER & FN_SYNC
 * 
 * Revision 1.1  90/05/21  14:56:29  ewout
 * Initial revision
 * 
 */

/* Handler ID */
#define APSH_FN_ID   APSH_USER_ID + 1000L
#define APSH_FNUSERID APSH_USER_ID + 2000L

/* Protos */

struct MsgHandler *setup_fnA (struct AppInfo *ai, struct TagItem *tl);

/* Application callable Notification prototype */

VOID FileNotify(struct AppInfo *, STRPTR, ULONG, ...);
/*
VOID FileNotify(struct AppInfo *, STRPTR, struct TagItem *);
*/
#define INFINITE          -1    /* retry forever */

struct FNData {
   UBYTE          *fnd_Filename;
   LONG            fnd_Interval;
   LONG            fnd_Retries;
   ULONG           fnd_Flags;
   LONG            fnd_Status;
};

struct FNInfo {
    struct MsgPort *fni_fnport;
    struct MsgPort *fni_clientport;
    struct MsgPort *fni_replyport;
    struct SIPCMessage *fni_sipcmsg;
    struct FNData *fni_fndata;
};

enum {
    FN_Command = APSH_FNUSERID,  /* Command to notifier                         */
    FN_Filename,            /* ptr to filename, must be qualified path     */
    FN_Retries,             /* number of retries or INFINITE, default -1   */
    FN_Interval,            /* Time between file status checks, default 60 */
    FN_Flags,               /* flags describing what to watch for, default FN_NEWER */
    FN_MustExist,           /* Target must exist when request is made      */
    FN_Smaller,             /* BOOL's, override FN_Flags...                */
    FN_Bigger,
    FN_Created,
    FN_Deleted,
    FN_Newer,
    FN_Error,               /* address of BOOL, returns TRUE if error      */
    FN_Buffer               /* ptr to buffer sizeof(struct FNData) to fill */
};                          /* NOTE: buffer->fnd_Filename is a pointer to
                             * the filename supplied as a tag !
                             */

/* Commands application/user can send */

#define FN_INQUIRY      1
#define FN_ADDTARGET    2
#define FN_DELTARGET    3
#define FN_SYNC         4


#define FN_DONE         0x01    /* Set in fnd_FNStatus when number of */
                                /* retries has been reached */

#define FN_MUSTEXIST    0x02    /* File must exist when request is made */

/* Following are both flags which tell handler what to look out for
 * and inform the application what happened.
 */

#define FN_SMALLER      0x04
#define FN_BIGGER       0x08
#define FN_DELETED      0x10
#define FN_CREATED      0x20
#define FN_NEWER        0x40

#define FN_ALLFLAGS     (FN_SMALLER|FN_BIGGER|FN_DELETED|FN_CREATED|FN_NEWER)
