/* projlist.h
 * Copyright (C) 1990 Commodore-Amiga, Inc.
 * written by David N. Junod
 *
 * project list requester
 * application-specific arrays & definitions
 *
 */

/* The AppShell maintains some basic information on the application.  Someday
 * it will provide a standard About requester that contains this information
 * plus the application's tool icon.
 */
#define	APPNAME "Project List"
#define	APPVERS	"ProjList 36.3 (14-Jun-90)"
#define	APPCOPY "Copyright (C) 1990 Commodore-Amiga, Inc."
#define	APPAUTH "David N. Junod"

/* These are the function prototypes for all the application implemented
 * functions used in this example. */
VOID NewFunc      (struct AppInfo *, STRPTR, struct TagItem *);
VOID BModListFunc (struct AppInfo *, STRPTR, struct TagItem *);
VOID AModListFunc (struct AppInfo *, STRPTR, struct TagItem *);
VOID QuitFunc     (struct AppInfo *, STRPTR, struct TagItem *);
VOID OkayFunc     (struct AppInfo *, STRPTR, struct TagItem *);
VOID PreviousFunc (struct AppInfo *, STRPTR, struct TagItem *);
VOID NextFunc     (struct AppInfo *, STRPTR, struct TagItem *);
VOID RemoveFunc   (struct AppInfo *, STRPTR, struct TagItem *);
VOID CancelFunc   (struct AppInfo *, STRPTR, struct TagItem *);
VOID SelectFunc   (struct AppInfo *, STRPTR, struct TagItem *);
VOID ListFunc     (struct AppInfo *, STRPTR, struct TagItem *);
VOID SwapFunc     (struct AppInfo *, STRPTR, struct TagItem *);

/* Each public function gets a numeric ID assigned to it.  */
enum
{
    DUMMYID = APSH_USER_ID,
    OkayID,
    MyPrevID,
    MyNextID,
    MyRemvID,
    CancelID,
    ListID,
    SwapID,
    BModListID,
    AModListID,
    LAST_ID
};

/* The AppShell will convert this array into function table entries and will
 * add them to the function table list.  Using the APSH_FF_PRIVATE flag, we
 * are able to have functions that can't be triggered by the user. */
struct Funcs FTable[] =
{
    {"NEW",	NewFunc,	NewID,},
    {"QUIT",    QuitFunc,	QuitID,},
    {"OKAY",    OkayFunc,	OkayID,},
    {"PREVIOUS",PreviousFunc,	MyPrevID,},
    {"NEXT",    NextFunc,	MyNextID,},
    {"REMOVE",  RemoveFunc,	MyRemvID,},
    {"CANCEL",  CancelFunc,	CancelID,},
    {"SELECT",  SelectFunc,	SelectID,},
    {"LIST",    ListFunc,	ListID, NULL, NULL, APSH_FF_PRIVATE},
    {"SWAP",    SwapFunc,	SwapID,},
    {"BMOD",	BModListFunc,	BModListID,},
    {"AMOD",	AModListFunc,	AModListID,},
    {NULL,      NO_FUNCTION,}	/* end of array */
};

/* All text used in the application must be defined in a text array.  Then
 * referred to by numeric ID. */
STRPTR app_deftext[] =
{
  NULL,					/*  0 */
  "Project List",			/*  1 */
  "Okay",				/*  2 */
  "Previous",				/*  3 */
  "Next",				/*  4 */
  "Remove",				/*  5 */
  "Cancel",				/*  6 */
  NULL
};

/* Objects may use TagItems to describe additional attributes.  The attributes
 * in this case are defined by GadTools.  */
struct TagItem selecttags[] =
{
    {GTST_MaxChars, 512L},
    {TAG_DONE,},
};

/* Because we don't no the gadget address for the text gadget to assign to
 * the list, we provide the name assigned to the object instead.  We also
 * provide a function ID to call when the gadget is selected when either
 * ALT key is pressed. */
struct TagItem listtags[] =
{
    {GTLV_ShowSelected, (ULONG)"SELECT"},
    {APSH_ObjAltHit,    SwapID},
    {TAG_DONE,},
};

/* All objects (such as gadgets) that are going to be contained in the window
 * are placed in the object array. */
struct Object objects[] =
{
    {&objects[1], 0, OBJ_Window, NULL, NULL, NULL, "MAIN", 1L,
     {1, 1, 0, 0}, },

    {&objects[2], 1, OBJ_Button, OkayID, NULL, RETURN, "OKAY", 2L,
     { 12, 92, 80, 12}, },
    {&objects[3], 1, OBJ_Button, MyPrevID, NULL, 'p', "PREVIOUS", 3L,
     {102, 92, 80, 12}, },
    {&objects[4], 1, OBJ_Button, MyNextID, NULL, 'n', "NEXT", 4L,
     {192, 92, 80, 12}, },
    {&objects[5], 1, OBJ_Button, MyRemvID, NULL, 'r', "REMOVE",   5L,
     {282, 92, 80, 12}, },
    {&objects[6], 1, OBJ_Button, CancelID, NULL, ESC, "CANCEL",   6L,
     {372, 92, 80, 12}, },

    {&objects[7], 2, OBJ_String, SelectID, NULL, 's', "SELECT", NULL,
     { 12,  0,308, 14}, selecttags, },

    {NULL,        2, OBJ_Listview, ListID, NULL,   NULL, "LIST",   NULL,
     { 12, 15,308, 70}, listtags, },
};

/* This is a GadTools menu array.  Eventually there will be a preprocessor
 * to convert text ID's into text for internationalization. */
struct NewMenu main_menu[] =
{
    {NM_TITLE, "Project",         0, 0, 0, 0, },
    {NM_ITEM,  "New",           "N", 0, 0, V ( NewID ), },
    {NM_ITEM,  "Quit",          "Q", 0, 0, V ( QuitID ), },

    {NM_TITLE, "Extras",          0, 0, 0, 0, },
    {NM_ITEM,  "Command Shell", "E", 0, 0, V ( CMDShellID ), },

    {NM_END, },
};

/* required libraries */
extern ULONG SysBase;
ULONG GadToolsBase;
ULONG GfxBase;
ULONG IconBase;
ULONG IntuitionBase;
ULONG LayersBase;

/* This tag array is used to open and close the shared system libraries
 * needed by our application. */
struct TagItem Our_Libs[] =
{
    {APSH_LibVersion,	36L},
    {APSH_LibStatus,	REQUIRED},
    {APSH_LibNameTag,	APSH_GadTools},
    {APSH_LibBase,	&GadToolsBase},
    {APSH_LibNameTag,	APSH_Gfx},
    {APSH_LibBase,	&GfxBase},
    {APSH_LibNameTag,	APSH_Icon},
    {APSH_LibBase,	&IconBase},
    {APSH_LibNameTag,	APSH_Intuition},
    {APSH_LibBase,	&IntuitionBase},
    {APSH_LibNameTag,	APSH_Layers},
    {APSH_LibBase,	&LayersBase},
    {TAG_DONE,}
};

/* These tags describe the Simple IPC user interface.  In this case, the
 * main use is to enforce the single invocation requirements of the
 * application */
struct TagItem Handle_SIPC[] =
{
    {APSH_Setup,	setup_sipcA},
    {APSH_Status,	P_ACTIVE | P_SINGLE},
    {APSH_Rating,	OPTIONAL},
    {TAG_DONE,}
};

/* These tags describe the ARexx user interface.  The default macro file
 * extension is proj. */
struct TagItem Handle_AREXX[] =
{
    {APSH_Setup,	setup_arexxA},
    {APSH_Extens,	(ULONG)"proj"},
    {APSH_Status,	P_ACTIVE | P_SINGLE},
    {APSH_Rating,	OPTIONAL},
    {TAG_DONE,}
};

/* These tags describe the Command Shell user interface. */
struct TagItem Handle_DOS[] =
{
    {APSH_Setup,	setup_dosA},
    {APSH_Status,	P_INACTIVE},
    {APSH_Rating,	OPTIONAL},
    {TAG_DONE,}
};

/* These tags describe the window environment */
struct TagItem windowenv[] =
{
    {APSH_NameTag,	(ULONG)"MAIN"},	/* name to give to window */
    {APSH_Objects,	(ULONG)objects},/* object list */
    {APSH_GTMenu,	(ULONG)main_menu},
    {TAG_DONE,}
};

/* These tags describe the Intuition user interface. */
struct TagItem Handle_IDCMP[] =
{
    {APSH_Setup,	setup_idcmpA},
    {APSH_WindowEnv,	(ULONG)windowenv},
    {APSH_Status,	P_ACTIVE},
    {APSH_Rating,	REQUIRED},
    {TAG_DONE,}
};

/* These tags describe an AppWindow environment.  The AppWindow will be
 * attached to the window named MAIN and dropped icons will be added to the
 * main project list.  Since the project list is attached to a list gadget,
 * we must remove the list from the gadget before modifying the list.  Hence
 * the before drop and after drop functions. */
struct TagItem appwinenv[] =
{
    {APSH_NameTag,	(ULONG)"MAIN"},	/* Window to make into AppWindow */
    {APSH_CmdFlags, APSH_WBF_PROJLIST}, /* add the icons to the project list */
    {APSH_AppBDrop,	BModListID},	/* function before drop */
    {APSH_AppADrop,	AModListID},	/* function after drop */
    {TAG_DONE,}
};

/* These tags describe the Workbench user interface. */
struct TagItem Handle_WB[] =
{
    {APSH_Setup,	setup_wbA},
    {APSH_AppWindowEnv,	(ULONG)appwinenv},
    {APSH_Status,	P_ACTIVE},
    {APSH_Rating,	OPTIONAL},
    {TAG_DONE,}
};

/* This is the main tag list used to describe our application's multiple
 * user interfaces. */
struct TagItem Our_App[] =
{
    {APSH_AppName,	(ULONG)APPNAME},
    {APSH_AppVersion,	(ULONG)APPVERS},
    {APSH_AppCopyright,	(ULONG)APPCOPY},
    {APSH_AppAuthor,	(ULONG)APPAUTH},
    {APSH_FuncTable,	(ULONG)FTable},
    {APSH_DefText,	(ULONG)app_deftext},
    {APSH_OpenLibraries,(ULONG)Our_Libs},
    {APSH_AddHandler,	(ULONG)Handle_SIPC},
    {APSH_AddHandler,	(ULONG)Handle_AREXX},
    {APSH_AddHandler,	(ULONG)Handle_DOS},
    {APSH_AddHandler,	(ULONG)Handle_IDCMP},
    {APSH_AddHandler,	(ULONG)Handle_WB},
    {APSH_AppInit,	AModListID},
    {TAG_DONE,}
};
