#ifndef         WARPRACE_H
#define         WARPRACE_H

/*
**      $VER: WarpRace.h 1.0 (20.9.97)
**
**      '(C) Copyright 1997 Haage & Partner Computer GmbH'
**           All Rights Reserved
**
**      structures for custom modules
**
*/

#ifndef EXEC_TYPES_H
#include "exec/types.h"
#endif /* EXEC_TYPES_H */


/*  data structures/equates used by custom modules */

#define         WR_ID   0x52414345              /* identifaction value passed to */
                                                /* the module as first argument */

/* data structure passed to the module as second argument */

struct WR_Input {
        APTR    WRI_PowerPCBase;                /* base of powerpc.library */
        ULONG   WRI_Version;                    /* version of powerpc.library */
        void    (*WRI_StartTimer_68K)(void);    /* start timer function (68K) */
        ULONG   (*WRI_StopTimer_68K)(void);     /* stop timer function (68K) */
        void    (*WRI_StartTimer_PPC)(APTR);    /* start timer function (PPC) */
        ULONG   (*WRI_StopTimer_PPC)(APTR);     /* stop timer function (PPC) */
        APTR    WRI_LinkerDB;                   /* argument for PPC timer func */
        BOOL    WRI_68K;                        /* TRUE for 68K-modules */
        ULONG   WRI_Flags;                      /* not used yet */
        APTR    WRI_Ext;                        /* reserved for future extension */
};

/* data structure returned from the module (if not NULL is returned) */

struct WR_Output {
        STRPTR  WRO_Modname;                    /* module name */
        STRPTR  WRO_Short;                      /* module short desription */
        STRPTR  WRO_Description;                /* module full description */
        STRPTR  WRO_Author;                     /* module author */
        ULONG   WRO_Version;                    /* module version */
        ULONG   WRO_Revision;                   /* module revision */
        ULONG   WRO_RevSize;                    /* number of digits for revision */
        ULONG   WRO_Flags;                      /* not used yet */
        STRPTR  WRO_Result;                     /* result used for statistics */
        ULONG   WRO_ResultType;                 /* result type (see below) */
        STRPTR  WRO_ResultString;               /* result string for VPrintf */
        APTR    WRO_ResultParams;               /* arguments for WRO_ResultString */
        ULONG   WRO_Status;                     /* completion status (see below) */
        STRPTR  WRO_ErrorString;                /* error string for VPrintf */
        APTR    WRO_ErrorParams;                /* arguments for WRO_ErrorString */
        APTR    WRO_Ext;                        /* reserved for future extension */
};

/* result types */

#define RES_UNKNOWN     0                       /* unknown */
#define RES_PROP        1                       /* unknown - proportional to power */
#define RES_INVPROP     2                       /* unknown - inv. proportional */
#define RES_MICROSECS   3                       /* time in microseconds */
#define RES_BYTESPERSEC 4                       /* memory performance (bytes/sec) */

/* status values */

#define STATUS_SUCCESS  -1
#define STATUS_ERROR    0


#endif  /* WARPRACE_H */
