                incdir  include:
                incdir  lvo:
                incdir  powerasm:source/powerpc_lib/warprace/

**      '(C) Copyright 1997 Haage & Partner Computer GmbH'
**           All Rights Reserved

                include exec/memory.i
                include exec/execbase.i
                include powerpc/powerpc.i
                include warprace.i

                include exec_lib.i

                xref    PPCCopy
                xref    _LinkerDB

                xdef    _PowerPCBase
                xdef    ErrParams

VERSION         =       1
REVISION        =       0
REVISIONCOUNT   =       1

MEMSIZE         =       256*1024
MEMLOOP         =       256

                mc68020

                section "",code
start
                movem.l d1-a6,-(sp)
                lea     _LinkerDB,a4
                cmp.l   #WR_ID,d0
                beq.b   .go
                movem.l (sp)+,d1-a6
                moveq   #0,d0
                rts
.go
                move.l  a0,a2
                move.l  WRI_POWERPCBASE(a2),_PowerPCBase
                move.l  $4.w,a6
                move.l  a6,_SysBase
                move    AttnFlags(a6),d0
                moveq   #-1,d7
                btst    #AFB_68040,d0
                beq.b   .slow
                moveq   #0,d7
.slow
                tst     WRI_68K(a2)
                bne     .notPPC
                move.l  a2,a0
                RUNPOWERPC      PPCCopy
                lea     Err_Mem,a5
                tst.l   d0
                beq.w   .error
                bra.w   .done
.notPPC
                move.l  #MEMSIZE*2+32,d0
                move.l  d0,ErrParams
                move.l  #MEMF_PUBLIC,d1
                CALLEXEC        AllocVec
                lea     Err_Mem,a5
                move.l  d0,_Memory
                add.l   #31,d0
                and.l   #$ffffffe0,d0
                move.l  d0,d6
                tst.l   d0
                beq.w   .error
                move.l  d6,d5
                add.l   #MEMSIZE,d6
                tst     d7
                bne.b   .slowcopy
                move.l  d5,a0
                move.l  d6,a1
                bsr     TurboCopy
                move.l  WRI_STARTTIMER_68K(a2),a1
                jsr     (a1)
                move    #MEMLOOP-1,d4
.slowloop
                move.l  d5,a0
                move.l  d6,a1
                bsr     TurboCopy
                dbra    d4,.slowloop
                move.l  WRI_STOPTIMER_68K(a2),a1
                jsr     (a1)
                bra.b   .done
.slowcopy
                move.l  d5,a0
                move.l  d6,a1
                bsr     SlowCopy
                move.l  WRI_STARTTIMER_68K(a2),a1
                jsr     (a1)
                move    #MEMLOOP-1,d4
.turboloop
                move.l  d5,a0
                move.l  d6,a1
                bsr     SlowCopy
                dbra    d4,.turboloop
                move.l  WRI_STOPTIMER_68K(a2),a1
                jsr     (a1)
.done
                move.l  #MEMSIZE*MEMLOOP,d2
                mulu.l  #1000000,d1:d2
                divu.l  d0,d1:d2
                move.l  d2,Result
                move.l  d2,d1
                moveq   #20,d0
                asr.l   d0,d2
                move.l  d2,ResultParams
                and.l   #$fffff,d1
                mulu    #100,d1
                asr.l   d0,d1
                move.l  d1,ResultParams+4
                move.l  #STATUS_SUCCESS,Status
                move.l  _Memory,a1
                CALLEXEC        FreeVec
                bra.b   .end
.error
                move.l  a5,ErrStr
                move.l  #STATUS_ERROR,Status
.end
                move.l  #WRO,d0
                movem.l (sp)+,d1-a6
                rts

SlowCopy
                move.l  #(MEMSIZE>>6)-1,d3
.copy
                rept    16
                move.l  (a0)+,(a1)+
                endr
                dbra    d3,.copy
                rts

                mc68040
TurboCopy
                move.l  #(MEMSIZE>>8)-1,d3
.copy
                rept    16
                move16  (a0)+,(a1)+
                endr
                dbra    d3,.copy
                rts


                section "",data
WRO
                dc.l    ModName
                dc.l    Short
                dc.l    Description
                dc.l    Author
                dc.l    VERSION
                dc.l    REVISION
                dc.l    REVISIONCOUNT
                dc.l    0
Result
                dc.l    0
                dc.l    RES_BYTESPERSEC
                dc.l    ResultString
                dc.l    ResultParams
Status
                dc.l    0
ErrStr
                dc.l    0
                dc.l    ErrParams
                dc.l    0

ModName         dc.b    "TurboCopy",0
Short           dc.b    "Memory test: Fastest copy operation (FAST -> FAST)",0
Description     dc.b    "This program copies a large block of memory from FAST-RAM\n"
                dc.b    "to FAST-RAM using the fastest possible algorithm. The PPC-\n"
                dc.b    "version uses LFDU/STFDU, the 68K-version MOVE16 (on 68040/\n"
                dc.b    "68060) or MOVE.L on other 68K processors",0
Author          dc.b    "Sam Jordan",0
ResultString    dc.b    "Memory performance: %ld.%02ld MB/s",0

Err_Mem         dc.b    "Failed to allocate %ld bytes of memory",0

                section "",bss
                ds.b    32
_SysBase        ds.l    1
_PowerPCBase    ds.l    1
_Memory         ds.l    1
ResultParams    ds.l    2
ErrParams       ds.l    1
                ds.b    32
