                incdir  include:
                incdir  lvo:
                incdir  powerasm:source/powerpc_lib/warprace/

**      '(C) Copyright 1997 Haage & Partner Computer GmbH'
**           All Rights Reserved

                include exec/memory.i
                include powerpc/ppcmacros.i
                include powerpc/powerpc.i
                include warprace.i

                include powerpc_lib.i

                xref    _PowerPCBase
                xref    ErrParams

                xdef    PPCCopy

                smalldata
                escapestr

                section code

LOOPCOUNT       =       1000

MEMSIZE         =       256*1024
MEMLOOP         =       256

PPCCopy
                prolog
                pushgpr r29-r31
                mr      r31,r5
                liw     r4,MEMSIZE*2
                liw     r5,MEMF_PUBLIC
                li      r6,0
                CALLPOWERPC     AllocVecPPC
                mr.     r30,r3
                beq     .error
                liw     r0,MEMSIZE
                add     r29,r30,r0
                mr      r3,r30
                mr      r4,r29
                bl      ByteCopyPPC
                lwz     r3,WRI_STARTTIMER_PPC(r31)
                mtlr    r3
                lwz     r3,WRI_LINKERDB(r31)
                blrl
                li      r3,MEMLOOP
                mtctr   r3
.loop
                mr      r3,r30
                mr      r4,r29
                bl      ByteCopyPPC
                bdnz    .loop
                lwz     r3,WRI_STOPTIMER_PPC(r31)
                mtlr    r3
                lwz     r3,WRI_LINKERDB(r31)
                blrl
                mr      r31,r3
                mr      r4,r30
                CALLPOWERPC     FreeVecPPC
                mr      r3,r31
                b       .end
.error
                liw     r4,MEMSIZE*2
                sw      r4,ErrParams
                li      r3,0
.end
                popgpr
                epilog

ByteCopyPPC
                mfctr   r6
                li      r5,MEMSIZE>>4
                mtctr   r5
                subi    r3,r3,1
                subi    r4,r4,1
.copy
                rept    16
                lbzu    r0,1(r3)
                stbu    r0,1(r4)
                endr
                bdnz    .copy
                mtctr   r6
                blr

