                incdir  include:
                incdir  lvo:
                incdir  powerasm:source/powerpc_lib/warprace/

**      '(C) Copyright 1997 Haage & Partner Computer GmbH'
**           All Rights Reserved

                include intuition/intuition.i
                include powerpc/powerpc.i
                include warprace.i

                include exec_lib.i
                include intuition_lib.i
                include graphics_lib.i
                include powerpc_lib.i

                xref    PixelOMania_PPC
                xref    _LinkerDB

                xdef    _SysBase
                xdef    _GfxBase
                xdef    _PowerPCBase
                xdef    _Window

VERSION         =       1
REVISION        =       0
REVISIONCOUNT   =       1

                mc68020

                section "",code
start
                movem.l d1-a6,-(sp)
                lea     _LinkerDB,a4
                cmp.l   #WR_ID,d0
                beq.b   .go
                movem.l (sp)+,d1-a6
                moveq   #0,d0
                rts
.go
                lea     ErrParams,a3
                move.l  a0,a2
                move.l  WRI_POWERPCBASE(a2),_PowerPCBase
                move.l  $4.w,_SysBase
                lea     int_name,a1
                move.l  a1,(a3)
                moveq   #0,d0
                move.l  d0,4(a3)
                lea     LibErr,a5
                CALLEXEC        OpenLibrary
                move.l  d0,_IntuitionBase
                beq.b   .error
                lea     graf_name,a1
                move.l  a1,(a3)
                moveq   #0,d0
                move.l  d0,4(a3)
                lea     LibErr,a5
                CALLEXEC        OpenLibrary
                move.l  d0,_GfxBase
                beq.b   .error
                sub.l   a0,a0
                lea     WinErr,a5
                lea     WindowTags,a1
                CALLINT         OpenWindowTagList
                move.l  d0,_Window
                beq.b   .error
                tst     WRI_68K(a2)
                bne     .notPPC
                move.l  a2,a0
                RUNPOWERPC      PixelOMania_PPC
                lea     Abort,a5
                tst.l   d0
                beq.w   .error
                bra.w   .done
.notPPC
                move.l  d0,a0
                move.l  wd_RPort(a0),d7
                moveq   #0,d3
                moveq   #0,d4
                moveq   #0,d5
                moveq   #1,d6
                move.l  WRI_STARTTIMER_68K(a2),a1
                jsr     (a1)
.loop
                move.l  _Window,a0
                move.l  wd_UserPort(a0),a0
                CALLEXEC        GetMsg
                tst.l   d0
                beq.b   .nomsg
                move.l  d0,a0
                move.l  im_Class(a0),d0
                and.l   #IDCMP_MOUSEBUTTONS,d0
                beq.b   .nomsg
                moveq   #-1,d5
                move.l  a0,a1
                CALLEXEC        ReplyMsg
.nomsg
                tst.l   d5
                beq.b   .continue
                lea     Abort,a5
                bra.b   .error
.continue
                move.l  d7,a1
                move.l  d6,d0
                eori.l  #2,d6
                CALLGRAF        SetAPen
                move.l  d7,a1
                move.l  d3,d0
                move.l  d4,d1
                CALLGRAF        WritePixel
                addq.l  #1,d3
                cmp.l   #96,d3
                blt.b   .loop
                moveq   #0,d3
                addq.l  #1,d4
                cmp.l   #64,d4
                blt.b   .loop
.cont
                move.l  WRI_STOPTIMER_68K(a2),a1
                jsr     (a1)
.done
                move.l  d0,Result
                divul.l #1000000,d1:d0
                move.l  d0,ResultParams
                move.l  d1,ResultParams+4
                move.l  #STATUS_SUCCESS,Status
                bra.b   .end
.error
                move.l  #STATUS_ERROR,Status
                move.l  a5,ErrStr
.end
                move.l  _Window,d0
                beq.b   .nowin
                move.l  d0,a0
                CALLINT         CloseWindow
.nowin
                move.l  _IntuitionBase,d0
                beq.b   .noint
                move.l  d0,a1
                CALLEXEC        CloseLibrary
.noint
                move.l  _GfxBase,d0
                beq.b   .nograf
                move.l  d0,a1
                CALLEXEC        CloseLibrary
.nograf
                move.l  #WRO,d0
                movem.l (sp)+,d1-a6
                rts



                section "",data
WRO
                dc.l    ModName
                dc.l    Short
                dc.l    Description
                dc.l    Author
                dc.l    VERSION
                dc.l    REVISION
                dc.l    REVISIONCOUNT
                dc.l    0
Result
                dc.l    0
                dc.l    RES_MICROSECS
                dc.l    ResultString
                dc.l    ResultParams
Status
                dc.l    0
ErrStr
                dc.l    0
                dc.l    ErrParams
                dc.l    0

ModName         dc.b    "PixelOMania",0
Short           dc.b    "CPU context switch test program",0
Description     dc.b    "This program measures the performance of the CPU context\n"
                dc.b    "switches. Every iteration consists of 4 AMIGA-OS system calls.\n"
                dc.b    "68K version included to compare with native speed",0
Author          dc.b    "Sam Jordan",0
ResultString    dc.b    "Elapsed time: %ld.%06ld seconds",0

LibErr          dc.b    "Failed to open %s V%ld",0
WinErr          dc.b    "Failed to open the window",0
Abort           dc.b    "Program aborted",0

int_name        INTNAME
graf_name       GRAFNAME
                cnop    0,4


WindowTags      dc.l    WA_Left
                dc.l    100
                dc.l    WA_Top
                dc.l    100
                dc.l    WA_Width
                dc.l    96
                dc.l    WA_Height
                dc.l    64
                dc.l    WA_Activate
                dc.l    -1
                dc.l    WA_IDCMP
                dc.l    IDCMP_MOUSEBUTTONS
                dc.l    TAG_DONE


                section "",bss
_SysBase        ds.l    1
_IntuitionBase  ds.l    1
_GfxBase        ds.l    1
_PowerPCBase    ds.l    1
_Window         ds.l    1
ResultParams    ds.l    2
ErrParams       ds.l    2
