
                incdir  include:
                incdir  powerasm:source/powerpc_lib/warprace/
                incdir  lvo:

**      '(C) Copyright 1997 Haage & Partner Computer GmbH'
**           All Rights Reserved

                include graphics/gfx.i
                include powerpc/ppcmacros.i
                include powerpc/powerpc.i
                include warprace.i

                include powerpc_lib.i

                xref    _PowerPCBase
                xref    ChunkyBuffer
                xref    bitmap

                xdef    C2P_PPC

                section "",code

                cpu     POWERPC
                smalldata


merge           macro
                and     r18,\1,\3
                xor     \1,r18,\1
                and     r19,\2,\3
                xor     \2,r19,\2
                slwi    r18,r18,\4
                srwi    \2,\2,\4
                or      \1,\1,\2
                or      \2,r19,r18
                endm


C2P_PPC
                prolog
                push    r31
                mr      r31,r5
                lwz     r3,WRI_STARTTIMER_PPC(r31)
                mtlr    r3
                lwz     r3,WRI_LINKERDB(r31)
                blrl
                li      r3,50
                mtctr   r3
.loop
                lw      r3,ChunkyBuffer
                la      r4,bitmap
                bl      ChunkyToPlanar_PPC
                bdnz    .loop
                lwz     r3,WRI_STOPTIMER_PPC(r31)
                mtlr    r3
                lwz     r3,WRI_LINKERDB(r31)
                blrl
                li      r4,50
                divwu   r3,r3,r4
                pop     r31
                epilog

******************************************************************************
*
*       ChunkyToPlanar_PPC (r3,r4)
*
*       converts chunky data into bitplane data (using Bitmap Structure)
*       works ONLY with a depth of 8 and resolution of 320*256!
*
*       original algorithm by James McCoull (I found the source somewhere
*       on the AMINET CD's)
*
*       In:  r3 -> ChunkyBuffer
*            r4 -> bitmap structure
*
******************************************************************************
ChunkyToPlanar_PPC
                prolog  256
                pushgpr r14-r28
                subi    local,local,32          ; space for temporary variables
                mr      r5,r3
                mr      r3,r4
                la      r3,bm_Planes+32(r3)     ;r11 -> after 8 plane ptrs
                lwzu    r16,-4(r3)              ;read 8 plane ptrs
                lwzu    r15,-4(r3)
                lwzu    r14,-4(r3)
                lwzu    r28,-4(r3)
                lwzu    r12,-4(r3)
                lwzu    r11,-4(r3)
                lwzu    r10,-4(r3)
                lwzu    r9,-4(r3)
                subi    r9,r9,4                 ;prepare for postincrement
                subi    r10,r10,4
                subi    r11,r11,4
                subi    r12,r12,4
                subi    r28,r28,4
                subi    r14,r14,4
                subi    r15,r15,4
                subi    r16,r16,4
                mr      r3,r5

; r3 = chunky buffer
; r9-r16 = output area

                liw     r5,320*256
                add     r4,r3,r5                ;r4 -> end of chunky data
                liw     r5,$00ff00ff            ;load mask values
                liw     r6,$0f0f0f0f
                liw     r7,$33333333
                liw     r8,$55555555
first_case
                lwz     r21,0(r3)
                lwz     r23,4(r3)
                lwz     r20,8(r3)
                lwz     r22,12(r3)
                lwz     r24,2(r3)
                lwz     r25,10(r3)
                lwz     r26,6(r3)
                lwz     r27,14(r3)
                lhz     r17,16(r3)
                mh      r21,r17
                lhz     r17,24(r3)
                mh      r20,r17
                lhz     r17,20(r3)
                mh      r23,r17
                lhz     r17,28(r3)
                mh      r22,r17
                lhz     r17,18(r3)
                mh      r24,r17
                lhz     r17,26(r3)
                mh      r25,r17
                lhz     r17,22(r3)
                mh      r26,r17
                lhz     r17,30(r3)
                mh      r27,r17
                addi    r3,r3,32

                merge   r21,r20,r5,8            ;now convert it
                merge   r23,r22,r5,8
                merge   r21,r23,r6,4
                merge   r20,r22,r6,4
                merge   r24,r25,r5,8
                merge   r26,r27,r5,8
                merge   r24,r26,r6,4
                merge   r25,r27,r6,4
                merge   r23,r26,r7,2
                merge   r22,r27,r7,2
                merge   r23,r22,r8,1
                merge   r26,r27,r8,1
                merge   r21,r24,r7,2
                merge   r20,r25,r7,2
                merge   r21,r20,r8,1
                merge   r24,r25,r8,1

                stw     r27,0*4(local)          ;plane 0
                stw     r26,1*4(local)          ;plane 1
                stw     r22,2*4(local)          ;plane 2
                stw     r23,3*4(local)          ;plane 3
                stw     r25,4*4(local)          ;plane 4
                stw     r24,5*4(local)          ;plane 5
                stw     r20,6*4(local)          ;plane 6
                stw     r21,7*4(local)          ;plane 7

                cmpw    r4,r3
                beq     final_case
main_case
                lwz     r21,0(r3)
                lwz     r23,4(r3)
                lwz     r20,8(r3)
                lwz     r22,12(r3)
                lwz     r24,2(r3)
                lwz     r25,10(r3)
                lwz     r26,6(r3)
                lwz     r27,14(r3)
                lhz     r17,16(r3)
                mh      r21,r17
                lhz     r17,24(r3)
                mh      r20,r17
                lhz     r17,20(r3)
                mh      r23,r17
                lhz     r17,28(r3)
                mh      r22,r17
                lhz     r17,18(r3)
                mh      r24,r17
                lhz     r17,26(r3)
                mh      r25,r17
                lhz     r17,22(r3)
                mh      r26,r17
                lhz     r17,30(r3)
                mh      r27,r17
                addi    r3,r3,32

                lwz     r17,0*4(local)
                stwu    r17,4(r9)
                merge   r21,r20,r5,8
                merge   r23,r22,r5,8
                lwz     r17,1*4(local)
                stwu    r17,4(r10)
                merge   r21,r23,r6,4
                merge   r20,r22,r6,4
                lwz     r17,2*4(local)
                stwu    r17,4(r11)
                merge   r24,r25,r5,8
                merge   r26,r27,r5,8
                lwz     r17,3*4(local)
                stwu    r17,4(r12)
                merge   r24,r26,r6,4
                merge   r25,r27,r6,4
                lwz     r17,4*4(local)
                stwu    r17,4(r28)
                merge   r23,r26,r7,2
                merge   r22,r27,r7,2
                lwz     r17,5*4(local)
                stwu    r17,4(r14)
                merge   r23,r22,r8,1
                merge   r26,r27,r8,1
                lwz     r17,6*4(local)
                stwu    r17,4(r15)
                merge   r21,r24,r7,2
                merge   r20,r25,r7,2
                lwz     r17,7*4(local)
                stwu    r17,4(r16)
                merge   r21,r20,r8,1
                merge   r24,r25,r8,1
                stw     r27,0*4(local)          ;plane 0
                stw     r26,1*4(local)          ;plane 1
                stw     r22,2*4(local)          ;plane 2
                stw     r23,3*4(local)          ;plane 3
                stw     r25,4*4(local)          ;plane 4
                stw     r24,5*4(local)          ;plane 5
                stw     r20,6*4(local)          ;plane 6
                stw     r21,7*4(local)          ;plane 7

                cmpw    r4,r3
                bne     main_case

final_case
                lwz     r17,0*4(local)
                stwu    r17,4(r9)
                lwz     r17,1*4(local)
                stwu    r17,4(r10)
                lwz     r17,2*4(local)
                stwu    r17,4(r11)
                lwz     r17,3*4(local)
                stwu    r17,4(r12)
                lwz     r17,4*4(local)
                stwu    r17,4(r28)
                lwz     r17,5*4(local)
                stwu    r17,4(r14)
                lwz     r17,6*4(local)
                stwu    r17,4(r15)
                lwz     r17,7*4(local)
                stwu    r17,4(r16)
exit
                addi    local,local,32
                popgpr
                epilog


