		IFND POWERPC_TASKSPPC_I
POWERPC_TASKSPPC_I      SET 1
**
**      $VER: tasksPPC.i 12.3 (8.10.97)
**
**      structures related to WarpOS task handling
**

		IFND    EXEC_TYPES_I
		include exec/types.i
		ENDC

		IFND    EXEC_NODES_I
		include exec/nodes.i
		ENDC

		IFND    EXEC_TASKS_I
		include exec/tasks.i
		ENDC

		IFND    UTILITY_TAGITEM_I
		include utility/tagitem.i
		ENDC

		IFND    POWERPCLIB_V7           ;only for V8+

**** private structure used in the main task structure

	STRUCTURE       TASKLINK,MLN_SIZE
	APTR            TASKLINK_TASK
	ULONG           TASKLINK_SIG
	UWORD           TASKLINK_USED
	LABEL           TASKLINK_SIZE

****  task structure PPC

	STRUCTURE       TASKPPC,TC_SIZE
	ULONG           TASKPPC_STACKSIZE       ;read only
	APTR            TASKPPC_STACKMEM        ;private
	APTR            TASKPPC_CONTEXTMEM      ;private
	APTR            TASKPPC_TASKPTR         ;private
	ULONG           TASKPPC_FLAGS           ;read only
	STRUCT          TASKPPC_LINK,TASKLINK_SIZE ;private
	APTR            TASKPPC_BATSTORAGE      ;private
	ULONG           TASKPPC_CORE            ;private
	STRUCT          TASKPPC_TABLELINK,MLN_SIZE ;private
	APTR            TASKPPC_TABLE           ;read only
	ULONG           TASKPPC_DEBUGDATA       ;free space for debugger
	LABEL           TASKPPC_SIZE            ;don't depend on this size

****  LN_TYPE field for PPC tasks
NT_PPCTASK      =       100

****  tc_state (one additional task state)

TS_CHANGING     =       7                       ;task is soon changing from
						;running to waiting state

****  taskppc_flags

	BITDEF          TASKPPC,SYSTEM,0        ;it's a system task
	BITDEF          TASKPPC,BAT,1           ;the task runs under BAT setup

****  special signal definitions

	BITDEF          SIG,TIME,10             ;eventually returned by WaitTime

**** tags passed to CreateTaskPPC

	ENUM            TAG_USER+$100000
	EITEM           TASKATTR_CODE           ;entry code
	EITEM           TASKATTR_EXITCODE       ;exit code
	EITEM           TASKATTR_NAME           ;task name
	EITEM           TASKATTR_PRI            ;task priority
	EITEM           TASKATTR_STACKSIZE      ;task stacksize
	EITEM           TASKATTR_R2             ;smalldata/TOC base
	EITEM           TASKATTR_R3             ;first parameter
	EITEM           TASKATTR_R4
	EITEM           TASKATTR_R5
	EITEM           TASKATTR_R6
	EITEM           TASKATTR_R7
	EITEM           TASKATTR_R8
	EITEM           TASKATTR_R9
	EITEM           TASKATTR_R10            ;last parameter
	EITEM           TASKATTR_SYSTEM         ;private
	EITEM           TASKATTR_MOTHERPRI      ;inherit mother's pri (boolean)
	EITEM           TASKATTR_BAT            ;BAT MMU setup (boolean)
	EITEM           TASKATTR_PRIVATE

****  taskptr structure (returned by LockTaskList)

	STRUCTURE       TASKPTR,LN_SIZE
	APTR            TASKPTR_TASK            ;ptr to task
	LABEL           TASKPTR_SIZE

**** return values of ChangeStack

CHSTACK_SUCCESS         =       -1
CHSTACK_NOMEM           =       0

**** input parameter of ChangeMMU

CHMMU_STANDARD          =       1               ;standard paged MMU setup
CHMMU_BAT               =       2               ;BAT MMU setup

**** tags passed to SnoopTask

	ENUM            TAG_USER+$103000
	EITEM           SNOOP_CODE              ;-> callback function
	EITEM           SNOOP_DATA              ;custom data
	EITEM           SNOOP_TYPE              ;entry or exit code

**** possible types for SNOOP_TYPE

SNOOP_START     =       1                       ;monitor task start
SNOOP_EXIT      =       2                       ;monitor task end

**** possible values for the CreatorCPU parameter of the callback function

CREATOR_PPC     =       1
CREATOR_68K     =       2

		ENDC    ;POWERPCLIB_V7

	ENDC    ;TASKSPPC_I
