		IFND    POWERPC_PPCMACROS_I
POWERPC_PPCMACROS_I     set     1

**
**      $VER: PPCmacros.i 8.0 (3.6.97)
**
**      standard macros and definitions for PowerPC
**

BITDEFPPC       macro
\1P_\2          =       \3
\1B_\2          =       31-(\3)
\1F_\2          =       1<<(31-(\3))
		endm

ALLOCPPCMEM     macro
		movem.l d1/a0/a1/a6,-(sp)
		move.l  _SysBase,a6
		add.l   #56,d0
		jsr     -684(a6)                ;AllocVec
		move.l  d0,d1
		beq     .zero\@
		add.l   #39,d0
		and.l   #$ffffffe0,d0
		move.l  d0,a0
		move.l  d1,-4(a0)
.zero\@
		movem.l (sp)+,d1/a0/a1/a6
		endm

FREEPPCMEM      macro
		movem.l d0/d1/a0/a1/a6,-(sp)
		move.l  a1,d0
		beq.b   .nofree\@
		move.l  -4(a1),a1
		move.l  _SysBase,a6
		jsr     -690(a6)                ;FreeVec
.nofree\@
		movem.l (sp)+,d0/d1/a0/a1/a6
		endm

		IFD     _POWERMODE

		IFND    __LOCALSIZE
__LOCALSIZE     set     1024
		ENDC
		IFND    local
__LOCAL         setr    r13
local           setr    r13
		ENDC
base            equr    r2
stack           equr    r1
trash           equr    r0

**** these register symbols can be used when transferring parameters from
**** 68K to PPC and vice versa

_d0             equr    r3
_d1             equr    r4
_d2             equr    r22
_d3             equr    r23
_d4             equr    r24
_d5             equr    r25
_d6             equr    r26
_d7             equr    r27
_a0             equr    r5
_a1             equr    r6
_a2             equr    r28
_a3             equr    r29
_a4             equr    base
_a5             equr    r30
_a6             equr    r31

_fp0            fequr   f1
_fp1            fequr   f2
_fp2            fequr   f3
_fp3            fequr   f4
_fp4            fequr   f5
_fp5            fequr   f6
_fp6            fequr   f7
_fp7            fequr   f8

lw              macro
			IFEQ    __MODE-__NEAR
				lwz     \1,\2(base)
			ELSEIF
				la      \1,\2
				lwz     \1,0(\1)
			ENDC
		endm

lh              macro
			IFEQ    __MODE-__NEAR
				lhz     \1,\2(base)
			ELSEIF
				la      \1,\2
				lhz     \1,0(\1)
			ENDC
		endm

lhs             macro
			IFEQ    __MODE-__NEAR
				lha     \1,\2(base)
			ELSEIF
				la      \1,\2
				lha     \1,0(\1)
			ENDC
		endm

lb              macro
			IFEQ    __MODE-__NEAR
				lbz     \1,\2(base)
			ELSEIF
				la      \1,\2
				lbz     \1,0(\1)
			ENDC
		endm

lbs             macro
			IFEQ    __MODE-__NEAR
				lbz     \1,\2(base)
				extsb   \1,\1
			ELSEIF
				la      \1,\2
				lbz     \1,0(\1)
				extsb   \1,\1
			ENDC
		endm

lf              macro
			IFEQ    __MODE-__NEAR
				lfd     \1,\2(base)
			ELSEIF
				mr      trash,r3
				la      r3,\2
				lfd     \1,0(r3)
				mr      r3,trash
			ENDC
		endm

ls              macro
			IFEQ    __MODE-__NEAR
				lfs     \1,\2(base)
			ELSEIF
				mr      trash,r3
				la      r3,\2
				lfs     \1,0(r3)
				mr      r3,trash
			ENDC
		endm

sw              macro
			IFEQ    __MODE-__NEAR
				stw     \1,\2(base)
			ELSEIF
				mr      trash,\1
				la      \1,\2
				stw     trash,0(\1)
				mr      \1,trash
			ENDC
		endm

sh              macro
			IFEQ    __MODE-__NEAR
				sth     \1,\2(base)
			ELSEIF
				mr      trash,\1
				la      \1,\2
				sth     trash,0(\1)
				mr      \1,trash
			ENDC
		endm

sb              macro
			IFEQ    __MODE-__NEAR
				stb     \1,\2(base)
			ELSEIF
				mr      trash,\1
				la      \1,\2
				stb     trash,0(\1)
				mr      \1,trash
			ENDC
		endm

sf              macro
			IFEQ    __MODE-__NEAR
				stfd    \1,\2(base)
			ELSEIF
				mr      trash,r3
				la      r3,\2
				stfd    \1,0(r3)
				mr      r3,trash
			ENDC
		endm

ss              macro
			IFEQ    __MODE-__NEAR
				stfs    \1,\2(base)
			ELSEIF
				mr      trash,r3
				la      r3,\2
				stfs    \1,0(r3)
				mr      r3,trash
			ENDC
		endm

lba             macro
		lbz     \1,\2
		extsb   \1,\1
		endm

lbau            macro
		lbzu    \1,\2
		extsb   \1,\1
		endm

lbax            macro
		lbzx    \1,\2,\3
		extsb   \1,\1
		endm

lbaux           macro
		lbzux   \1,\2,\3
		extsb   \1,\1
		endm

stwi            macro
		liw     trash,\1
		stw     trash,\2
		endm

sthi            macro
		li      trash,\1
		sth     trash,\2
		endm

stbi            macro
		li      trash,\1
		stb     trash,\2
		endm

stwiu           macro
		liw     trash,\1
		stwu    trash,\2
		endm

sthiu           macro
		li      trash,\1
		sthu    trash,\2
		endm

stbiu           macro
		li      trash,\1
		stbu    trash,\2
		endm

stwix           macro
		liw     trash,\1
		stwx    trash,\2,\3
		endm

sthix           macro
		li      trash,\1
		sthx    trash,\2,\3
		endm

stbix           macro
		li      trash,\1
		stbx    trash,\2,\3
		endm

stwiux          macro
		liw     trash,\1
		stwux   trash,\2,\3
		endm

sthiux          macro
		li      trash,\1
		sthux   trash,\2,\3
		endm

stbiux          macro
		li      trash,\1
		stbux   trash,\2,\3
		endm

swi             macro
			IFEQ    __MODE-__NEAR
				liw     trash,\1
				stw     trash,\2(base)
			ELSEIF
				stw     r3,-4(local)
				liw     trash,\1
				la      r3,\2
				stw     trash,0(r3)
				lwz     r3,-4(local)
			ENDC
		endm

shi             macro
			IFEQ    __MODE-__NEAR
				li      trash,\1
				sth     trash,\2(base)
			ELSEIF
				stw     r3,-4(local)
				li      trash,\1
				la      r3,\2
				sth     trash,0(r3)
				lwz     r3,-4(local)
			ENDC
		endm

sbi             macro
			IFEQ    __MODE-__NEAR
				li      trash,\1
				stb     trash,\2(base)
			ELSEIF
				stw     r3,-4(local)
				li      trash,\1
				la      r3,\2
				stb     trash,0(r3)
				lwz     r3,-4(local)
			ENDC
		endm

liw             macro
		lis     \1,High(\2)
		ori     \1,\1,Low(\2)
		endm

clrw            macro
		xor\0   \1,\1,\1
		endm

clrh            macro
		clrrwi\0 \1,\1,16
		endm

clrb            macro
		clrrwi\0 \1,\1,8
		endm

setb            macro
		ori     \1,\1,$ff
		endm

seth            macro
		ori     \1,\1,$ffff
		endm

setw            macro
		eqv\0   \1,\1,\1
		endm

mh              macro
		insrwi\0 \1,\2,16,16
		endm

mb              macro
		insrwi\0 \1,\2,8,24
		endm

tstb            macro
		extsb.  trash,\1
		endm

tsth            macro
		extsh.  trash,\1
		endm

tstw            macro
		mr.     \1,\1
		endm

bittst          macro
		IFLT    (\2)-31
			extrwi. trash,\1,1,\2
		ELSEIF
			andi.   trash,\1,$1
		ENDC
		endm

bitset          macro
		IFLT    (\2)-16
			oris    \1,\1,(1<<(15-(\2)))
		ELSEIF
			ori     \1,\1,(1<<(31-(\2)))
		ENDC
		endm

bitclr          macro
		IFLT    (\2)-16
			oris    \1,\1,(1<<(15-(\2)))
			xoris   \1,\1,(1<<(15-(\2)))
		ELSEIF
			ori     \1,\1,(1<<(31-(\2)))
			xori    \1,\1,(1<<(31-(\2)))
		ENDC
		endm

bitchg          macro
		IFLT    (\2)-16
			xoris   \1,\1,(1<<(15-(\2)))
		ELSEIF
			xori    \1,\1,(1<<(31-(\2)))
		ENDC
		endm

push            macro
		stwu    \1,-4(local)
		endm

pushf           macro
		stfdu   \1,-8(local)
		endm

pushlr          macro
		mflr    trash
		stwu    trash,-4(local)
		endm

pushctr         macro
		mfctr   trash
		stwu    trash,-4(local)
		endm

pushcr          macro
		mfcr    trash
		stwu    trash,-4(local)
		endm

pop             macro
		lwz     \1,0(local)
		addi    local,local,4
		endm

popf            macro
		lfd     \1,0(local)
		addi    local,local,8
		endm

poplr           macro
		lwz     trash,0(local)
		addi    local,local,4
		mtlr    trash
		endm

popctr          macro
		lwz     trash,0(local)
		addi    local,local,4
		mtctr   trash
		endm

popcr           macro
		lwz     trash,0(local)
		addi    local,local,4
		mtcr    trash
		endm

lnk             macro
		stwu    \1,-4(local)
		mr      \1,local
		addi    local,local,\2
		endm

ulnk            macro
		mr      local,\1
		lwz     \1,0(local)
		addi    local,local,4
		endm


setlocal        macro
__LOCALSIZE     set     \1
__LOCAL         setr    \2
local           setr    \2
		endm

prolog          macro
		IFNC    "","\2"
local           setr    \2
__LOCAL         setr    \2
		ENDC
		IFC     "TOC","\3"
			stw     base,20(stack)
		ENDC
		mflr    trash
		stw     trash,8(stack)
		mfcr    trash
		stw     trash,4(stack)
		stw     local,-4(stack)
		subi    local,stack,4
		IFC     "","\1"
__ARGS          set     24+4+(__LOCALSIZE)+56
			stwu    stack,-((__ARGS)-56)(stack)
		ELSEIF
__ARGS          set     24+4+(\1)+56
			stwu    stack,-((__ARGS)-56)(stack)
		ENDC
		endm

epilog          macro
		lwz     stack,0(stack)
		lwz     local,-4(stack)
		lwz     trash,8(stack)
		mtlr    trash
		lwz     trash,4(stack)
		mtcr    trash
		IFC     "TOC","\1"
			lwz     base,20(stack)
		ENDC
		blr
		endm

		ENDC

		ENDC ; IFND PPCMACROS_I
