		IFND POWERPC_LISTSPPC_I
POWERPC_LISTSPPC_I      SET 1
**
**      $VER: ListsPPC.i 12.0 (1.8.97)
**
**      Structures related to WarpOS list handling
**

		IFND    EXEC_LISTS_I
		include exec/lists.i
		ENDC

		IFND    EXEC_NODES_I
		include exec/nodes.i
		ENDC

		IFND    POWERPC/PPCMACROS_I
		include powerpc/ppcmacros.i
		ENDC

;Prepare a list header for use
_NEWLIST    MACRO   ; list
	    STW     \1,LH_TAILPRED(\1)
	    LI      R0,0
	    STWU    R0,LH_TAIL(\1) ;Clear LH_TAIL
	    STWU    \1,-4(\1)   ;Address of LH_TAIL to LH_HEAD
	    ENDM

;Test if list is empty (list address in register)
;This operation is safe at any time - no list arbitration needed.
_TSTLIST    MACRO   ; [list]
	    IFGT    NARG-1
	       FAIL    !!! TSTLIST - Too many arguments !!!
	    ENDC
	    LWZ     R0,LH_TAIL+LN_PRED(\1)
	    CMPW    R0,\1
	    ENDM

;Get next in list
_SUCC       MACRO   ; node,=succ
	    LWZ     \2,LN_SUCC(\1)
	    ENDM

;Get previous in list
_PRED       MACRO   ; node,=pred
	    LWZ     \2,LN_PRED(\1)
	    ENDM

;If empty, branch
_IFEMPTY    MACRO   ; list,label
	    LWZ     R0,LH_TAIL+LN_PRED(\1)
	    CMPW    R0,\1
	    BEQ     \2
	    ENDM

;If not empty, branch
_IFNOTEMPTY MACRO   ; list,label
	    LWZ     R0,LH_TAIL+LN_PRED(\1)
	    CMPW    R0,\1
	    BNE     \2
	    ENDM

;Get next node, test if at end
_TSTNODE    MACRO   ; node,=next
	    LWZ     \2,0(\1)
	    LWZ     R0,(\2)
	    MR.     R0,R0
	    ENDM

;Add to head of list
_ADDHEAD    MACRO   ; r4-list r5-node r3-(destroyed)
	    LWZ     r3,LH_HEAD(r4)
	    STW     r5,LH_HEAD(r4)
	    STW     r3,LN_SUCC(r5)
	    STW     r4,LN_PRED(r5)
	    STW     r5,LN_PRED(r3)
	    ENDM

;Add to tail of list
_ADDTAIL    MACRO   ; r4-list(destroyed) r5-node r3-(destroyed)
	    ADDI    r4,r4,LH_TAIL
	    LWZ     r3,LN_PRED(r4)
	    STW     r5,LN_PRED(r4)
	    STW     r4,LN_SUCC(r5)
	    STW     r3,LN_PRED(r5)
	    STW     r5,LN_SUCC(r3)
	    ENDM

;Remove node from whatever list it is in
_REMOVE     MACRO   ; r3-(destroyed) r4-node(destroyed)
	    LWZ     r3,LN_SUCC(r4)
	    LWZ     r4,LN_PRED(r4)
	    STW     r4,LN_PRED(r3)
	    STW     r3,LN_SUCC(r4)
	    ENDM

;Remove node from head of list
_REMHEAD    MACRO   ; r4-list r5-destroyed r3-(returned: node removed)
	    LWZ     r5,LH_HEAD(r4)
	    LWZ     r3,LN_SUCC(r5)
	    MR.     r3,r3
	    BEQ     .REMHEAD\@
	    STW     r3,LH_HEAD(r4)
	    STW     r4,LN_PRED(r3)
	    MR      r3,r5
.REMHEAD\@
	    ENDM

;Remove node from tail of list
_REMTAIL    MACRO   ; r4-list r5-destroyed r3-(returned: node removed)
	    LWZ     r5,LH_TAIL+LN_PRED(r4)
	    LWZ     r3,LN_PRED(r5)
	    MR.     r3,r3
	    BEQ     .REMTAIL\@
	    STW     r3,LH_TAIL+LN_PRED(r4)
	    ADDI    r4,r4,LH_TAIL
	    STW     r4,LN_SUCC(r3)
	    MR      r3,r5
.REMTAIL\@
	    ENDM

	ENDC    ;LISTSPPC_I
