#include <exec/types.h>
#include <exec/libraries.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <stdlib.h>
#include <string.h>
#include <PowerUP/pragmas/ppc_pragmas.h>
#include <PowerUP/clib/ppc_protos.h>
#include "PPCSignalTask_VERSION.h"

UBYTE vers[] = VERSTAG;

extern struct ExecBase	*SysBase;

char	*ArgumentString = "ID/K,Name,Signal/N,SignalMask/K";

#define	INDEX_ID		0
#define	INDEX_NAME		1
#define	INDEX_SIGNAL		2
#define	INDEX_SIGNALMASK	3
#define	INDEX_COUNT		4
LONG	*MyArgs[INDEX_COUNT];

void	main(void)
{
struct Library	*PPCLibBase;
void		*MyTask=NULL;
struct	RDArgs	*rdargs;
ULONG		SignalMask;
char		*String;

  if (!(rdargs=ReadArgs(ArgumentString,(LONG*) &MyArgs[0],NULL)))
  {
    Printf("Commandline Error\n");
    return;
  }
  else
  {
    if (PPCLibBase=OpenLibrary("ppc.library",0))
    {
      if (String=(char*)MyArgs[INDEX_ID])
      {
        if (String[0] == '$')
        {
          String++;
        }
        else
        if ((String[0] == '0') &&
            (String[1] == 'x'))
        {
          String+=2;
        }
        if (stch_l(String,(LONG*) &MyTask) == 0)
        {
          Printf("Can`t parse the ID parameter\n");
          FreeArgs(rdargs);
          return;
        }
        MyTask=PPCFindTaskObject(MyTask);
      }
      else
      if (MyArgs[INDEX_NAME])
      {
        MyTask=PPCFindTask((char*) MyArgs[INDEX_NAME]);
      }
      
      if (MyTask)
      {
        if (MyArgs[INDEX_SIGNAL])
        {
          SignalMask	=	1 << *MyArgs[INDEX_SIGNAL];
        }
        else if (String=(char*)MyArgs[INDEX_SIGNALMASK])
        {
          if (String[0] == '$')
          {
            String++;
          }
          else
          if ((String[0] == '0') &&
              (String[1] == 'x'))
          {
            String+=2;
          }
          if (stch_l(String,(LONG*) &SignalMask) == 0)
          {
            Printf("Can`t parse the StringMask parameter\n");
            FreeArgs(rdargs);
            return;
          }
        }
        else
        {
          Printf("Missing signal parameter\n");
          FreeArgs(rdargs);
          return;
        }

        Printf("Send SIGNALMASK 0x%08lx to PPC Task 0x%08lx\n",
               SignalMask,
               MyTask);


        PPCSignalTask(MyTask,
                      SignalMask);

        Printf("Signal done\n");
      }
      else
      {
        Printf("No PPC Task found\n");
      }
    }
    else
    {
      Printf("No ppc.library found\n");
    }
    FreeArgs(rdargs);
  }
}
