#include <exec/types.h>
#include <exec/libraries.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <stdlib.h>
#include <utility/tagitem.h>
#include <PowerUP/pragmas/ppc_pragmas.h>
#include <PowerUP/clib/ppc_protos.h>
#include <PowerUP/PPCLib/ppc.h>
#include "PPCInfos_VERSION.h"

UBYTE vers[] = VERSTAG;

extern struct ExecBase	*SysBase;

void	main(ULONG argc,char *argv[])
{
struct Library	*PPCLibBase;
struct TagItem	MyTags[3];
ULONG		CPU;
char		*CPUString;
ULONG		CPUCount;
ULONG		CPUClock;
ULONG		CPURev;
ULONG		CPUPll;
ULONG		i;

  if (PPCLibBase=OpenLibrary("ppc.library",0))
  {
    MyTags[0].ti_Tag	=	PPCINFOTAG_CPUCOUNT;
    MyTags[1].ti_Tag	=	TAG_END;
    CPUCount=PPCGetAttrs((struct TagItem*) &MyTags);

    for (i=0;i<CPUCount;i++)
    {
      MyTags[0].ti_Tag	=	PPCINFOTAG_CPU;
      MyTags[0].ti_Data	=	i;
      MyTags[1].ti_Tag	=	TAG_END;
      CPU=PPCGetAttrs((struct TagItem*) &MyTags);

      switch (CPU)
      {
        case CPU_603:
             CPUString="PPC603";
             break;

        case CPU_604:
             CPUString="PPC604";
             break;

        case CPU_602:
             CPUString="PPC602";
             break;

        case CPU_603e:
             CPUString="PPC603e";
             break;

        case CPU_603p:
             CPUString="PPC603p";
             break;

        case CPU_604e:
             CPUString="PPC604e";
             break;

        default:
             CPUString="Unknown";
             break;
      }

      MyTags[0].ti_Tag	=	PPCINFOTAG_CPUCOUNT;
      MyTags[0].ti_Data	=	i;
      MyTags[1].ti_Tag	=	TAG_END;
      CPUCount=PPCGetAttrs((struct TagItem*) &MyTags);

      MyTags[0].ti_Tag	=	PPCINFOTAG_CPUCLOCK;
      MyTags[0].ti_Data	=	i;
      MyTags[1].ti_Tag	=	TAG_END;
      CPUClock=PPCGetAttrs((struct TagItem*) &MyTags);

      MyTags[0].ti_Tag	=	PPCINFOTAG_CPUPLL;
      MyTags[0].ti_Data	=	i;
      MyTags[1].ti_Tag	=	TAG_END;
      CPUPll=PPCGetAttrs((struct TagItem*) &MyTags);

      MyTags[0].ti_Tag	=	PPCINFOTAG_CPUREV;
      MyTags[0].ti_Data	=	i;
      MyTags[1].ti_Tag	=	TAG_END;
      CPURev=PPCGetAttrs((struct TagItem*) &MyTags);

      Printf("CPU[%ld] 0x%04lx=%s CPURev 0x%04ld CPUClock %ldMhz CPUPLL 0x%lx\n",
             i,
             CPU,
             CPUString,
             CPURev,
             CPUClock,
             CPUPll);
    }
  }
  else
  {
    Printf("No PPC library found\n");
  }
}
