    IFND POWERUP_PPCLIB_TASKS_I
POWERUP_PPCLIB_TASKS_I	SET	1

;/**************************************************
; *
; *
; *              PPCCreateTask() Tags
; *
; *
; **************************************************/

PPCTASKTAG_DUMMY	=(TAG_USER+$20000)

;/* Program Counter Start of the Task; */
PPCTASKTAG_ELFOBJECT	=(PPCTASKTAG_DUMMY+$1)

;/* Name of the new Task.; */
PPCTASKTAG_NAME		=(PPCTASKTAG_DUMMY+$2)

;/* First Argument..gpr3; */
PPCTASKTAG_ARG1		=(PPCTASKTAG_DUMMY+$3)

;/* First Argument..gpr4; */
PPCTASKTAG_ARG2		=(PPCTASKTAG_DUMMY+$4)

;/* First Argument..gpr5; */
PPCTASKTAG_ARG3		=(PPCTASKTAG_DUMMY+$5)

;/* First Argument..gpr6; */
PPCTASKTAG_ARG4		=(PPCTASKTAG_DUMMY+$6)

;/* First Argument..gpr7; */
PPCTASKTAG_ARG5		=(PPCTASKTAG_DUMMY+$7)

;/* First Argument..gpr8; */
PPCTASKTAG_ARG6		=(PPCTASKTAG_DUMMY+$8)

;/* First Argument..gpr9; */
PPCTASKTAG_ARG7		=(PPCTASKTAG_DUMMY+$9)

;/* First Argument..gpr10; */
PPCTASKTAG_ARG8		=(PPCTASKTAG_DUMMY+$a)

;/* Default=TRUE means that the cacheflush is handled automaticly
; * You need cacheflushs when you use OS functions to share data.
; * If you know it better than the stupid cacheflush routine you
; * can handle that yourself and optimize your routines.
; */

PPCTASKTAG_CACHEFLUSH	=(PPCTASKTAG_DUMMY+$b)

;/* Ptr to an ULONG Errorfield where a better error description
; * can be stored.
; */

PPCTASKTAG_ERROR	=(PPCTASKTAG_DUMMY+$c)

;/* PPC Stacksize...Default 8192;
; * Supported by PowerUP's PPCGetTaskAttr() (V45)
; */
PPCTASKTAG_STACKSIZE	=(PPCTASKTAG_DUMMY+$d)

;/* Task Priority..Default 0; */
PPCTASKTAG_PRIORITY	=(PPCTASKTAG_DUMMY+$e)

;/* Input Handle..Default Open("Nil:")
; * The handle is closed when the PPC task completes
; */
PPCTASKTAG_INPUTHANDLE	=(PPCTASKTAG_DUMMY+$f)

;/* Output Handle..Default Open("Nil:")
; * The handle is closed when the PPC task completes
; */
PPCTASKTAG_OUTPUTHANDLE	=(PPCTASKTAG_DUMMY+$10)

;/* Error Handle..Default Open("Nil:")
; * The handle is closed when the PPC task completes
; */
PPCTASKTAG_ERRORHANDLE	=(PPCTASKTAG_DUMMY+$11)

;/*
; * When you set this Tag the Task is stopped
; * before the first instruction is executed
; * Only useful for debuggers
; */
PPCTASKTAG_STOPTASK	=(PPCTASKTAG_DUMMY+$12)

;/* ExceptionHook
; * The M68k Hook is called when a PPC TaskObject gets an
; * exception which can be processor or software(Kernel Msg)
; * related.
; * That`s the way the ppc.library calls the Hook:
; *
; * BOOL CallHookPkt(hook,TaskObject,ExceptionMsg);
; *
; * The Hook Function is NOT allowed to call PPCLibBase
; * functions to avoid deadlocks.
; * And after the Hook function returns the ExceptionMsg
; * contents IS NOT valid anymore.
; * So you should copy the ExceptionMsg contents to a private
; * buffer and then signal your debugger control task about
; * the event.
; * The Hook return BOOL should tell the ppc.library if all
; * worked fine.
; */

PPCTASKTAG_EXCEPTIONHOOK	=(PPCTASKTAG_DUMMY+$13)

;/* If you want that the PPCPort gets a MsgPort you can tell
; * PPCCreateTask by a TRUE that you want one.
; * I made this optional because it may cause an initial speed
; * loss if you only need a ppc task for a quick run job where
; * the init latency may be a serious issue.
; * Supported by PowerUP's PPCGetTaskAttr()
; */
PPCTASKTAG_MSGPORT		=(PPCTASKTAG_DUMMY+$14)

;/* If you wanna provide the ppc a startup msg. This msg will
; * be replied by the ppc.library after the PPC Task ends so
; * you can use this to abitrate your PPCUnloadObject()
; * Supported by PowerUP's PPCGetTaskAttr()
; */
PPCTASKTAG_STARTUP_MSG		=(PPCTASKTAG_DUMMY+$15)
;/* The Data field for the PPCMessage
; * Supported by PowerUP's PPCGetTaskAttr()
; */
PPCTASKTAG_STARTUP_MSGDATA	=(PPCTASKTAG_DUMMY+$16)
;/* The Length field for the PPCMessage
; * Supported by PowerUP's PPCGetTaskAttr()
; */
PPCTASKTAG_STARTUP_MSGLENGTH	=(PPCTASKTAG_DUMMY+$17)
;/* The MsgID field for the PPCMessage
; * Supported by PowerUP's PPCGetTaskAttr()
; */
PPCTASKTAG_STARTUP_MSGID	=(PPCTASKTAG_DUMMY+$18)
;/* The flag to activate the CTRL-C;D;E;F gateway to
; * the PPC Task by PPCSendSignal();
; */
PPCTASKTAG_BREAKSIGNAL		=(PPCTASKTAG_DUMMY+$19)


;/* Run Task Synchron Flag which means that the PPCCreateTask
; * doesn`t return until the task completes and the return
; * value is not the TaskObject but the Task`s return value.
; * To check if the task runned correctly check out the
; * PPCTASKTAG_ERROR fieldptr.
; * With this Tag you can do the same what the old RunTaskObject
; * does which interface is a bit limited(compatibility to the
; * first ppc.library version)
; */

PPCTASKTAG_WAITFINISH	=(PPCTASKTAG_DUMMY+$31)

;/* 
; * PPCTAGTAG_ERROR types
; */

ERROR_OK		=0
ERROR_MEMORY		=1
ERROR_NOPC		=2
ERROR_CREATEMSGINTASK	=3
ERROR_INPUTHANDLE	=4
ERROR_OUTPUTHANDLE	=5
ERROR_ERRORHANDLE	=6




;/**************************************************
; *
; *
; *             PPCGetTaskInfo() Tags
; *
; *
; **************************************************/

;/*
; * V45 adds the ti_Data data Set/Get passing if it`s possible
; */

PPCTASKINFOTAG_DUMMY		=(TAG_USER+$21000)
PPCTASKINFOTAG_NAME		=(PPCTASKINFOTAG_DUMMY+$1)
PPCTASKINFOTAG_PRIORITY		=(PPCTASKINFOTAG_DUMMY+$2)
PPCTASKINFOTAG_CACHEFLUSH	=(PPCTASKINFOTAG_DUMMY+$3)
PPCTASKINFOTAG_STACKSIZE	=(PPCTASKINFOTAG_DUMMY+$4)
PPCTASKINFOTAG_STATE		=(PPCTASKINFOTAG_DUMMY+$5)
PPCTASKINFOTAG_TASK		=(PPCTASKINFOTAG_DUMMY+$6)

;/* This means the HOOK function is called for every Task; */
PPCTASKINFOTAG_ALLTASK		=(PPCTASKINFOTAG_DUMMY+$7)

;/* Hook function which is called for a task so you can ask special fields
; * you may want to use.
; * Msg Parameter is NULL for now.
; * Object Parameter is the TaskObject
; *
; *    HookFunc(Hook, TaskObject, NULL)
; */
PPCTASKINFOTAG_HOOK		=(PPCTASKINFOTAG_DUMMY+$8)

PPCTASKINFOTAG_SIGALLOC		=(PPCTASKINFOTAG_DUMMY+$9)
PPCTASKINFOTAG_SIGWAIT		=(PPCTASKINFOTAG_DUMMY+$a)
PPCTASKINFOTAG_SIGRECVD		=(PPCTASKINFOTAG_DUMMY+$b)
PPCTASKINFOTAG_USEDSTACKSIZE	=(PPCTASKINFOTAG_DUMMY+$c)
PPCTASKINFOTAG_INPUTHANDLE	=(PPCTASKINFOTAG_DUMMY+$d)
PPCTASKINFOTAG_OUTPUTHANDLE	=(PPCTASKINFOTAG_DUMMY+$e)
PPCTASKINFOTAG_ERRORHANDLE	=(PPCTASKINFOTAG_DUMMY+$f)

;/* Return the ElfObject of a Task
; * (Get)
; * (V45)
; */

PPCTASKINFOTAG_ELFOBJECT		=(PPCTASKINFOTAG_DUMMY+$10)

;/* See equal PPCTASKTAG_EXCEPTIONHOOK
; * (V45)
; * (Set)
; */

PPCTASKINFOTAG_EXCEPTIONHOOK		=(PPCTASKINFOTAG_DUMMY+$11)

;/* Tell the task to stop at the first instruction.
; * Only allowed to be used when you get a TaskHookMsg
; * with the MethodID PPCTASKHOOKMETHOD_CREATE.
; * It must not be called while a PPC Task runs.
; * (V45)
; * (Set)
; */
PPCTASKINFOTAG_STOPTASK			=(PPCTASKINFOTAG_DUMMY+$12)


;/* See equal PPCTASKTAG_MSGPORT
; * (V45)
; */
PPCTASKINFOTAG_MSGPORT			=(PPCTASKINFOTAG_DUMMY+$13)

;/* See equal PPCTASKTAG_STARTUP_MSG
; * (V45)
; */
PPCTASKINFOTAG_STARTUP_MSG		=(PPCTASKINFOTAG_DUMMY+$14)

;/* See equal PPCTASKTAG_STARTUP_MSGDATA
; * (V45)
; */
PPCTASKINFOTAG_STARTUP_MSGDATA		=(PPCTASKINFOTAG_DUMMY+$15)

;/* See equal PPCTASKTAG_STARTUP_MSGLENGTH
; * (V45)
; */
PPCTASKINFOTAG_STARTUP_MSGLENGTH	=(PPCTASKINFOTAG_DUMMY+$16)

;/* See equal PPCTASKTAG_STARTUP_MSGID
; * (V45)
; */
PPCTASKINFOTAG_STARTUP_MSGID		=(PPCTASKINFOTAG_DUMMY+$17)

;/*
; * All Register Tags only accept Ptrs at ti_Data so I don`t have to
; * change the API when there`s a 64Bit PPC some time.
; */

;/* SRR0=PC;
; * Get/Set through ti_Data or PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */
PPCTASKINFOTAG_PC		=(PPCTASKINFOTAG_DUMMY+$20)
;/* SRR1=MSR;
; * Get/Set through ti_Data or PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */
PPCTASKINFOTAG_MSR		=(PPCTASKINFOTAG_DUMMY+$21)

;/* 32bit value in function Result;
; * Get/Set through ti_Data
; * (Get/Set)
; */
PPCTASKINFOTAG_CR		=(PPCTASKINFOTAG_DUMMY+$22)

;/* 32bit value in function Result;
; * Get/Set through ti_Data
; * (Get/Set)
; */
PPCTASKINFOTAG_XER		=(PPCTASKINFOTAG_DUMMY+$23)

;/* Result by PPCTASKINFOTAG_VALUEPTR;
; * Get/Set through ti_Data or PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */
PPCTASKINFOTAG_LR		=(PPCTASKINFOTAG_DUMMY+$24)

;/* Result by PPCTASKINFOTAG_VALUEPTR;
; * Get/Set through ti_Data or PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */

PPCTASKINFOTAG_CTR		=(PPCTASKINFOTAG_DUMMY+$25)

;/* Result by PPCTASKINFOTAG_VALUEPTR;
; * Get/Set through ti_Data or PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */
PPCTASKINFOTAG_FPSCR		=(PPCTASKINFOTAG_DUMMY+$26)

;/* ti_Data=Register Number
; * Get/Set through PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */
PPCTASKINFOTAG_GPR		=(PPCTASKINFOTAG_DUMMY+$30)

;/* ti_Data=Register Number
; * Get/Set through PPCTASKINFOTAG_VALUEPTR
; * (Get/Set)
; */
PPCTASKINFOTAG_FPR		=(PPCTASKINFOTAG_DUMMY+$31)

;/* Address where to read/write the register value from.
; * I use a ptr to be size indepent with the registers
; */
PPCTASKINFOTAG_VALUEPTR		=(PPCTASKINFOTAG_DUMMY+$32)


;/* With PPCTASKINFOTAG_WAITFINISHTASK
; * it returns the parent process in which you created
; * a synchron PPC Task. Synchron PPC Task`s are created
; * with the PPCTASKTAG_WAITINFISH,TRUE or outdated a
; * PPCRunObject.
; * The reason for this function is to find the shell
; * task easily and check for a CTRL-C for example.
; * (Get)
; * (V45)
; */
PPCTASKINFOTAG_WAITFINISHTASK	=(PPCTASKTAG_DUMMY+$33)




;/**************************************************
; *
; *
; *           TaskObject ExceptionHook
; *
; *
; **************************************************/


	STRUCTURE	ExceptionMsg,0
	ULONG			Version;
	ULONG			Type;
	STRUCT			GPR,32*4;
	STRUCT			FPR,32*8;
	STRUCT			SR,16*4;
	ULONG			CR;
	DOUBLE			FPSCR;
	ULONG			XER;
	ULONG			LR;
	ULONG			CTR;
	ULONG			PVR;
	ULONG			IBAT0U;
	ULONG			IBAT0L;
	ULONG			IBAT1U;
	ULONG			IBAT1L;
	ULONG			IBAT2U;
	ULONG			IBAT2L;
	ULONG			IBAT3U;
	ULONG			IBAT3L;

	ULONG			DBAT0U;
	ULONG			DBAT0L;
	ULONG			DBAT1U;
	ULONG			DBAT1L;
	ULONG			DBAT2U;
	ULONG			DBAT2L;
	ULONG			DBAT3U;
	ULONG			DBAT3L;

	ULONG			SDR1;
	ULONG			ASR;

	ULONG			DAR;
	ULONG			DSISR;
	ULONG			SRR0;
	ULONG			SRR1;

	ULONG			SPRG0;
	ULONG			SPRG1;
	ULONG			SPRG2;
	ULONG			SPRG3;

	ULONG			TBL;
	ULONG			TBU;
	ULONG			DEC;
	ULONG			DABR;

	;/* 603 special registers; */

	ULONG			DMISS;
	ULONG			DCMP;
	ULONG			HASH1;
	ULONG			HASH2;
	ULONG			IMISS;
	ULONG			ICMP;
	ULONG			RPA;

	;/* 604e special registers; */

	;/* Version 0 ends here; */

	ULONG			MSR;

	;/* Version 1 ends here */

	;/* Size depends on Version; */


;/* Current supported Version
; */

EXCEPTIONMSG_VERSION	=	1

;/*
; * Current supported Types
; */

;/*
; * These are the processor exceptions
; */

EXCEPTION_UNKNOWN		=0	;/* Won`t happen; */
EXCEPTION_RESET			=1	;/* Won`t happen; */
EXCEPTION_MACHINECHECK		=2	;/* Won`t happen; */
EXCEPTION_DATAACCESS		=3
EXCEPTION_INSTRUCTIONACCESS	=4
EXCEPTION_EXTERNALINTERRUPT	=5	;/* Won`t happen; */
EXCEPTION_ALIGNMENT		=6
EXCEPTION_PROGRAM		=7
EXCEPTION_FPUUNAVAILABLE	=8
EXCEPTION_DECREMENTER		=9
EXCEPTION_INTERFACEERROR	=10
EXCEPTION_RESERVED_B		=11
EXCEPTION_SYSTEMCALL		=12
EXCEPTION_TRACE			=13
EXCEPTION_FPUASSIST		=14
EXCEPTION_RESERVED_F		=15
EXCEPTION_IMISS			=16
EXCEPTION_DLOADMISS		=17
EXCEPTION_DSTOREMISS		=18
EXCEPTION_IADDRESSBREAK		=19
EXCEPTION_SYSTEMMANAGEMENTINT	=20


;/*
; * These are the kernel exceptions
; * to signal certain events
; */

EXCEPTION_MSG			=$80000000

;/*
; * You receive this exception type
; * when the Kernel could stop a Task
; * successfully after a Stop or Trace
; * operation.
; * Look at PPCTASKTAG_STOPTASK for example
; */

EXCEPTION_STOPTASK		=(EXCEPTION_MSG+$0)

;/*
; * You receive this exception type
; * when the task completes.
; * In this case the ONLY valid fields in the
; * ExceptionMsg are the Version field and the
; * the Message type.
; */

EXCEPTION_FINISHTASK		=(EXCEPTION_MSG+$1)


;/**************************************************
; *
; *
; *              PPCStartTask() Tags
; *
; *
; **************************************************/

PPCTASKSTARTTAG_DUMMY		=(TAG_USER+$22000)

;/* Just run a Task again
; * ti_Data=BOOL
; */
PPCTASKSTARTTAG_RUN		=(PPCTASKSTARTTAG_DUMMY+$0)

;/* Single Step the next instruction
; * ti_Data=BOOL
; */
PPCTASKSTARTTAG_TRACE		=(PPCTASKSTARTTAG_DUMMY+$1)

;/* Branch until a Trace instruction
; * Processor dependent
; * ti_Data=BOOL
; * NOT SUPPORTED YET
; */
PPCTASKSTARTTAG_BRANCHTRACE	=(PPCTASKSTARTTAG_DUMMY+$2)

;/* Run until Instruction hit
; * the Breakpoint Address
; * Processor dependent
; * ti_Data=BOOL
; * NOT SUPPORTED YET
; */
PPCTASKSTARTTAG_IBREAK		=(PPCTASKSTARTTAG_DUMMY+$3)

;/* Run until DataAccess hit
; * the Breakpoint Address
; * Processor dependent
; * ti_Data=BOOL
; * NOT SUPPORTED YET
; */
PPCTASKSTARTTAG_DBREAK		=(PPCTASKSTARTTAG_DUMMY+$4)

	ENDC
