    IFND POWERUP_PPCLIB_INTERFACES_I
POWERUP_PPCLIB_INTERFACES_I	SET	1

	include	"exec/types.i"

;/*
; * Structure which is used on the PPC side to call
; * AmigaOS library functions or sub routines.
; *
; */

;/*****************************/
;/* About the CacheMode field */
;/*****************************/

;/*
; * For calling functions from the PPC under M68k AmigaOS or for
; * calling functions on the PPC Supervisor mode you have to care
; * for the cache issues. Please read the Cache chapter in the
; * docs/powerup.guide about the cache problems involved.
; * If you do something wrong here you can expect that you loose
; * data, get wrong data or simply crash the machine.
; *
; * IF_CACHEFLUSHNO:
; * You use this mode for the cpu if your function
; * touches no memory both cpus use.
; *
; * Example: Close(File)
; *          If you call this function by the PPC there`s no need
; *          to flush the cache because the PPC isn`t allowed to
; *          touch any memory which has to do with the File BPTR.
; * ATTENTION:
; *          The PPC MUST NOT be used to poke into AmigaOS system
; *          structures.
; *
; * IF_CACHEFLUSHALL:
; * You use this mode for the cpu if your function
; * touches memory both cpus use and it`s no simple memory area
; * which may be flushed individually. This should be used by default.
; *
; * Example: OpenWindowTagList(NewWindow,TagList)
; *          Here you pass a complex data structure which may use
; *          memory areas at several different areas.
; *
; * IF_CACHEFLUSHAREA:
; * You use this mode for the cpu if your function
; * touches memory both cpus use and it`s a memory area which isn`t
; * very big. It depends on the size and how many lines are dirty
; * if this is faster than IF_CACHEFLUSHALL.
; * With the Start and Length fields of each cpu you can define
; * the area.
; *
; * Example: Write(File,Address,Length)
; *          When the PPC runs this function the PPC must make sure
; *          that all data in the to be written memory area is in
; *          in the memory and not only in the cache.
; *
; * IF_CACHEINVALIDAREA: (V45)
; * You use this mode for the cpu if your function
; * touches memory both cpus use and it`s a memory area where you
; * don`t care for valid data anymore.
; * With the Start and Length fields of each cpu you can define
; * the area.
; *
; * Example: Read(File,Address,Length)
; *          When the PPC runs this function the PPC has no need
; *          anymore for anything which is in its cache for the
; *          area the Address and Length define, so you could
; *          invalidate this instead of doing a cacheflush which
; *          may write back dirty lines.
; *          Be VERY careful about this.
; *
; * ATTENTION! The Address must be 32Byte aligned, so you should always
; * use PPCAllocMem for data which is used on the M68k and PPC
; * You are NOT allowed to use normal pools for exchanging data between
; * the M68k and PPC.
; *
; * IF_ASYNC: (V45)
; * If you use this flag, the function is called asynchronous and
; * the PPC doesn`t have to wait for a result.
; * This flag is only checked in the M68kCacheMode field.
; * This also means that the result of the PPCCall#? function
; * is meaningless.
; * Normally this flag doesn`t really fit into a CacheMode flag, but
; * well..too bad i haven`t declared another flag field there.
; */

	STRUCTURE	Caos,0
	LABEL	caos_Function
	LONG	caos_Offset
	ULONG	caos_M68kCacheMode;
	APTR	caos_M68kStart;
	ULONG	caos_M68kLength;
	ULONG	caos_PPCCacheMode;
	APTR	caos_PPCStart;
	ULONG	caos_PPCLength;
	ULONG	caos_d0
	ULONG	caos_d1
	ULONG	caos_d2
	ULONG	caos_d3
	ULONG	caos_d4
	ULONG	caos_d5
	ULONG	caos_d6
	ULONG	caos_d7
	ULONG	caos_a0
	ULONG	caos_a1
	ULONG	caos_a2
	ULONG	caos_a3
	ULONG	caos_a4
	ULONG	caos_a5
	ULONG	caos_a6
	LABEL	caos_SIZE

IF_CACHEFLUSHNO		=	0
IF_CACHEFLUSHALL	=	1
IF_CACHEFLUSHAREA	=	2
IF_CACHEINVALIDAREA	=	4
IF_ASYNC		=	$10000

;/*
; * Structure which is used on the M68k side to run
; * a Kernal Supervisor ElfObject. During this time
; * the multitasking on the PPC stop
; * Better allocate this struct by PPCAllocMem to get
; * a Cache Line and FPU data alignment which is an
; * automatic effect
; * PPCRunKernalModule() ONLY !!!!!!!!!!!!!!!!!!!!!
; */

	STRUCTURE	ModuleArgs,0
	ULONG		ma_M68kCacheMode;
	APTR		ma_M68kStart;
	ULONG		ma_M68kLength;
	ULONG		ma_PPCCacheMode;
	APTR		ma_PPCStart;
	ULONG		ma_PPCLength;
	ULONG		ma_Arg1	;/* Gpr3=C Arg1 */
	ULONG		ma_Arg2	;/* Gpr4=C Arg2  */
	ULONG		ma_Arg3	;/* Gpr5=C Arg3  */
	ULONG		ma_Arg4	;/* Gpr6=C Arg4  */
	ULONG		ma_Arg5	;/* Gpr7=C Arg5  */
	ULONG		ma_Arg6	;/* Gpr8=C Arg6  */
	ULONG		ma_Arg7	;/* Gpr9=C Arg7  */
	ULONG		ma_Arg8	;/* Gpr10=C Arg8 */
	DOUBLE		ma_FArg1;/* FPR1=C FPU Arg1 */
	DOUBLE		ma_FArg2;/* FPR2=C FPU Arg2 */
	DOUBLE		ma_FArg3;/* FPR3=C FPU Arg3 */
	DOUBLE		ma_FArg4;/* FPR4=C FPU Arg4 */
	DOUBLE		ma_FArg5;/* FPR5=C FPU Arg5 */
	DOUBLE		ma_FArg6;/* FPR6=C FPU Arg6 */
	DOUBLE		ma_FArg7;/* FPR7=C FPU Arg7 */
	DOUBLE		ma_FArg8;/* FPR8=C FPU Arg8 */
	LABEL		ModuleArgs_SIZEOF

	ENDC
