#ifndef POWERUP_GCCLIB_PROTOS_H
#define POWERUP_GCCLIB_PROTOS_H

#include	<dos/dos.h>
#include	<powerup/ppclib/interface.h>
#include	<utility/tagitem.h>

APTR	PPCAllocMem( unsigned long byteSize, unsigned long requirements );
void	PPCFreeMem( APTR memoryBlock, unsigned long byteSize );
APTR	PPCAllocVec( unsigned long byteSize, unsigned long requirements );
void	PPCFreeVec( APTR memoryBlock);
BPTR	PPCOpen( STRPTR name, long accessMode );
LONG	PPCClose( BPTR file );
LONG	PPCRead( BPTR file, APTR buffer, long length );
LONG	PPCWrite( BPTR file, APTR buffer, long length );
LONG	PPCSeek( BPTR file, long position, long offset );
APTR	PPCCreatePool( unsigned long requirements, unsigned long puddleSize,
	unsigned long threshSize );
BOOL	PPCDeletePool( APTR poolHeader );
APTR	PPCAllocPooled( APTR poolHeader, unsigned long memSize );
void	PPCFreePooled( APTR poolHeader, APTR memory, unsigned long memSize );
APTR	PPCAllocVecPooled( APTR poolHeader, unsigned long memSize );
void	PPCFreeVecPooled( APTR poolHeader, APTR memory);
ULONG	PPCCallOS(struct Caos*);
ULONG	PPCCallM68k(struct Caos*);
ULONG	PPCSignal(void*,ULONG);
ULONG	PPCWait(ULONG);
void	*PPCFindTask(char*);
ULONG	PPCAllocSignal(ULONG);
void	PPCFreeSignal(ULONG);
void	PPCCacheFlush(APTR,ULONG);
void	PPCCacheFlushAll(void);
void	PPCCacheInvalid(APTR,ULONG);
ULONG	PPCSetSignal(ULONG,ULONG);
void	*PPCCreatePort(struct TagItem*);
BOOL	PPCDeletePort(void*);
void	*PPCObtainPort(struct TagItem*);
BOOL	PPCReleasePort(void*);
void	*PPCCreateMessage(void*,
                         ULONG);
void	PPCDeleteMessage(void*);
void	*PPCGetMessage(void*);
ULONG	PPCGetMessageAttr(void*,
                          ULONG);
BOOL	PPCReplyMessage(void*);
BOOL	PPCSendMessage(void*,
                       void*,
                       void*,
                       ULONG,
                       ULONG);
void	*PPCWaitPort(void*);

int	strcmp(const char	*,
               const char	*);
char	*strcpy(char		*,
                const char	*);
int	strlen(const char	*);

void	PPCInsert(struct List	*,
                  struct Node	*,
                  struct Node	*);
void	PPCAddHead(struct List *,
                   struct Node *);
void	PPCAddTail(struct List *,
                   struct Node *);
void	PPCRemove(struct Node *);
struct Node *PPCRemHead(struct List *);
struct Node *PPCRemTail(struct List *);

struct TagItem*	PPCNextTagItem(struct TagItem**);
struct TagItem*	PPCFindTagItem(Tag,
                               struct TagItem*);
ULONG	PPCGetTagData(Tag,
                      ULONG,
                      struct TagItem *);

ULONG	PPCVersion(void);
ULONG	PPCRevision(void);

void	PPCReleaseSemaphore(void*);
void	PPCObtainSemaphore(void*);
LONG	PPCAttemptSemaphore(void*);
BOOL	PPCAttemptSemaphoreShared(void*);
void	PPCObtainSemaphoreShared(void*);
void*	PPCCreateSemaphore(struct TagItem*);
void	PPCDeleteSemaphore(void*);
void*	PPCObtainSemaphoreByName(char*);
void*	PPCAttemptSemaphoreByName(char*,
                                  ULONG*);

APTR	PPCRawDoFmt(UBYTE*,
                    APTR,
                    void (*)(),
                    APTR);

ULONG	PPCGetTaskAttr(ULONG);

void	PPCFinishTask(void);

ULONG	PPCGetAttr(ULONG);

#endif
