#ifndef POWERUP_PPCLIB_PROTOS_H
#define POWERUP_PPCLIB_PROTOS_H

APTR	PPCLoadObject(char*);
void	PPCUnLoadObject(void*);
ULONG	PPCRunObject(void*,void*);
void*	PPCAllocMem(ULONG,ULONG);
void	PPCFreeMem(void*,ULONG);
void*	PPCAllocVec(ULONG,ULONG);
void*	PPCFreeVec(void*);
void*	PPCDebugMode(ULONG,ULONG);
void	PPCReset(void);
void	*PPCCreateTask(void*,
                       struct TagItem*);
void	*PPCCreateTaskTags(void*,
                           unsigned long tag1Type, ... );
BOOL	PPCDeleteTask(void*);

/* Equal to PPCSignal..
 * Small release mistake
 */
void	PPCSignalTask(void*,ULONG);
void	PPCSignal(void*,ULONG);
void	*PPCFindTask(char	*);
ULONG	PPCRunKernelObject(void*,
                           struct ModuleArgs*);
DOUBLE	PPCRunKernelObjectFPU(void*,
                              struct ModuleArgs*);
ULONG	PPCGetTaskAttrs(void*,
                        struct TagItem*);
ULONG	PPCGetTaskAttrsTags(void*,
                            unsigned long tag1Type,
                            ...);
ULONG	PPCGetAttrs(struct TagItem*);
ULONG	PPCGetAttrsTags(unsigned long tag1Type,
                       ...);

void	*PPCFindTaskObject(void*);
ULONG	PPCReadLong(ULONG*);
void	PPCWriteLong(ULONG*,ULONG);
BOOL	PPCStartTask(void*,
                     struct TagItem*);
BOOL	PPCStartTaskTags(void*,
                     unsigned long tag1Type, ... );
BOOL	PPCStopTask(void*,
                    struct TagItem*);
BOOL	PPCStopTaskTags(void*,
                    unsigned long tag1Type, ... );
ULONG	PPCSetTaskAttrs(void*,
                       struct TagItem*);
ULONG	PPCSetTaskAttrsTags(void*,
                       unsigned long tag1Type,
                       ...);
ULONG	PPCGetObjectAttrs(void*,
                          struct PPCObjectInfo*,
                          struct TagItem*);
ULONG	PPCGetObjectAttrsTags(void*,
                              struct PPCObjectInfo*,
                              unsigned long tag1Type,
                              ... );

void	PPCWriteLongFlush(ULONG*,ULONG);
UWORD	PPCReadWord(UWORD*);
void	PPCWriteWord(UWORD*,UWORD);
UBYTE	PPCReadByte(UBYTE*);
void	PPCWriteByte(UBYTE*,UBYTE);
void*	PPCCreatePool(ULONG		MemFlags,
                      ULONG		PuddleSize,
                      ULONG		ThreshSize);
BOOL	PPCDeletePool(void*);
void*	PPCAllocPooled(void*,
                       ULONG);
void	PPCFreePooled(void*,
                      APTR,
                      ULONG);
void	PPCFreeVecPooled(void*,
                         void*);
void*	PPCAllocVecPooled(void*,
                          ULONG);



void*	PPCCreatePort(struct TagItem*);
void*	PPCCreatePortTags(unsigned long tag1Type, ... );
BOOL	PPCDeletePort(void*);
void*	PPCObtainPort(struct TagItem*);
void*	PPCObtainPortTags(unsigned long tag1Type, ... );
BOOL	PPCReleasePort(void*);
void*	PPCCreateMessage(void*,
                         ULONG);
void	PPCDeleteMessage(void*);
ULONG	PPCGetMessageAttr(void*,
                          ULONG);
void*	PPCGetMessage(void*);
BOOL	PPCPutMessage(void*,
                      void*);
BOOL	PPCReplyMessage(void*);
BOOL	PPCSendMessage(void*,
                       void*,
                       void*,
                       ULONG,
                       ULONG);
void*	PPCWaitPort(void*);
void	PPCCacheClearE(void*,
                       ULONG,
                       ULONG);

void	PPCCacheInvalidE(void*,
                         ULONG,
                         ULONG);


void*	PPCCreatePortList(void**,ULONG);
void	PPCDeletePortList(void*);
BOOL	PPCAddPortList(void*,
                       void*);
void	PPCRemPortList(void*,
                       void*);
void*	PPCWaitPortList(void*);
ULONG	PPCGetPortListAttr(void*,
                           ULONG);
void	PPCSetPortListAttr(void*,
                           ULONG,
                           ULONG);

APTR	PPCLoadObjectTags(unsigned long tag1Type, ... );
APTR	PPCLoadObjectTagList(struct TagItem*);


BOOL	PPCSetAttrs(struct TagItem*);

void	PPCCacheTrashE(void*,
                       ULONG,
                       ULONG);

#endif
