#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <powerup/ppclib/interface.h>
#include <powerup/gcclib/powerup_protos.h>

#define	TEXT1	"PPCTask now waits for Signal %ld\nPlease use <Tools/PPCSignalTask TaskSignalTest %ld>\nto wake it up again"
#define	TEXT2	"PPCTask got Signals 0x%lx\n"

int	main(void)
{
BPTR		MyFile;
ULONG		MySignal;
ULONG		DataArray[10];
ULONG		TextBuffer[500];
ULONG		Length;

  if (MyFile=PPCOpen("con:0/0/640/200/TaskSignalTest/CLOSE",MODE_NEWFILE))
  {
    if ((MySignal=PPCAllocSignal(-1)) != -1)
    {
      DataArray[0]	=	MySignal;
      DataArray[1]	=	MySignal;
      PPCRawDoFmt(TEXT1,
                  &DataArray,
                  0,				/* 0=Buffer,1=serial,? NOT supported yet */
                  &TextBuffer);

      Length=strlen(&TextBuffer);

      PPCWrite(MyFile,
               &TextBuffer,
               Length);

      DataArray[0]	=	PPCWait(1<<MySignal);

      PPCRawDoFmt(TEXT2,
                  &DataArray,
                  0,				/* 0=Buffer,1=serial,? NOT supported yet */
                  &TextBuffer);

      Length=strlen(&TextBuffer);

      PPCWrite(MyFile,
               &TextBuffer,
               Length);

      PPCFreeSignal(MySignal);
    }
    else
    {
      PPCRawDoFmt("Couldn`t alloc the WakeUP Task signal\n",
                  &DataArray,
                  1,				/* 0=Buffer,1=serial <> NOT supported yet */
                  NULL);
    }
    PPCClose(MyFile);
  }
  else
  {
    PPCRawDoFmt("Couldn`t open CLI Window\n",
                &DataArray,
                1,				/* 0=Buffer,1=serial <> NOT supported yet */
                NULL);
  }
}
