/* Stefan Burstrom Source and concept
 * Adapted by Ralph Schmidt
 */

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <utility/tagitem.h>
#include <powerup/ppclib/interface.h>
#include <powerup/ppclib/message.h>
#include <powerup/ppclib/tasks.h>
#include <powerup/gcclib/powerup_protos.h>

struct StartupMsg
{
	APTR	M68kPort; /* The PPCTask can send messages here */
	LONG	Status;   /* When the task exits, it can fill in the status here */
};

void	main(void)
{
struct StartupMsg	*startupMsg;
APTR			Task;
APTR			PPCMsg;
APTR			PPCMessagePort;

  Task = PPCFindTask(NULL);

  startupMsg		=(struct StartupMsg *) PPCGetTaskAttr(PPCTASKTAG_STARTUP_MSGDATA);

  PPCMessagePort	=(APTR) PPCGetTaskAttr(PPCTASKTAG_MSGPORT);

  if (PPCMsg = PPCCreateMessage(PPCMessagePort,0)) /* We are sending zero length messages */
  {
    long	i;
    for (i=0;i<4;i++) /* Send 4 dummy messages to the 68k task */
    {
      PPCSendMessage(startupMsg->M68kPort,
                     PPCMsg,
                     NULL,
                     0,
                     i); /* Send a number to the 68k task */

      PPCWaitPort(PPCMessagePort); /* Wait for the reply */

      PPCGetMessage(PPCMessagePort); /* Get the reply */
    }
  
    /* Everything worked out ok, so we tell that to the main task */

    startupMsg->Status	=	1;

    /* Delete our Message */

    PPCDeleteMessage(PPCMsg);
  }
  else
  {
    /* Oops, not enough memory, fill in status in the startup message and exit
     * The kernel will reply the message for us when we are done executing */

    startupMsg->Status	=	0;
  }
}
