#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <utility/tagitem.h>
#include <powerup/ppclib/interface.h>
#include <powerup/ppclib/message.h>
#include <powerup/ppclib/tasks.h>
#include <powerup/gcclib/powerup_protos.h>

#define TEXT    "Text sent by PPC processor\n"

BPTR    MyFile;
void printf(char *String);

#define	DEBUG	1
#define	BODYSIZE	3747

int	main(void)
{
struct TagItem	MyTags[10];
void		*PPCPort;
void		*ReplyPort;
void		*M68kPort;
void		*PPCMsg;
void		*M68kMsg;
UBYTE		*Body;
ULONG           result;
ULONG		MsgCount;
ULONG		i,j;

  MsgCount	=	PPCGetTaskAttr(PPCTASKTAG_STARTUP_MSGID);

#if DEBUG
  if (MyFile = PPCOpen("con:0/0/640/200/MessageDemo - PPC output/CLOSE", MODE_NEWFILE))
  {
    printf("Creating message port\n");
#endif
    MyTags[0].ti_Tag  = PPCPORTTAG_NAME;
    MyTags[0].ti_Data = (ULONG) "PPC port";
    MyTags[1].ti_Tag  = TAG_DONE;
    if (PPCPort = PPCCreatePort(MyTags))
    {

#if DEBUG
      printf("Waiting for M68k message\n");
#endif
      for (i=0;i<MsgCount;i++)
      {
        PPCWaitPort(PPCPort);

#if DEBUG
        printf("Getting message\n");
#endif
        while (M68kMsg = PPCGetMessage(PPCPort))
        {
          Body	=	PPCGetMessageAttr(M68kMsg, PPCMSGTAG_DATA);

          for (j=0;j<BODYSIZE;j++)
          {
            if (Body[j]	!= ((i+j) & 0xff))
            {
              printf("MsgBody is wrong");
              break;
            }
          }
          PPCReplyMessage(M68kMsg);
        }
      }

#if DEBUG
      printf("Deleting message port\n");
#endif
      while (PPCDeletePort(PPCPort) == FALSE)
      {
/*
        PPCRawDoFmt("deleteport failed...\n",
                    NULL,
                    1,				// 0=Buffer,1=serial <> NOT supported yet
                    NULL);
*/
      }
    }
    else
    {
#if DEBUG
      printf("Could not create ppc port\n");
#endif
    }

#if DEBUG
    printf("Closing output\n");
    PPCClose(MyFile);
  }
#endif
}

void printf(char *String)
{
  PPCWrite(MyFile, String, strlen(String));
}

