/* This test program sends 1000 messages to the PPC and
   shows how long this takes.
   The Messages are send synchron and every msg must
   be replied after another.
   Each Message has a Body with the size of 3747 bytes
   and the PPC side checks if the msg is received correctly.
 */

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <utility/tagitem.h>
#include <powerup/ppclib/interface.h>
#include <powerup/ppclib/message.h>
#include <powerup/ppclib/tasks.h>
#include <powerup/proto/ppc.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/timer.h>
#include <stdio.h>
#include <string.h>
#include "time.h"
#include "time_protos.h"

#define TEXT            "Text sent by M68k processor\n"
#define KILL_ID         0x4b494c4c

#define	MSGCOUNT	1000
#define	BODYSIZE	3747

struct StartupData
{
	ULONG	MsgCount;
};

extern struct Library	*SysBase;

int	main(void)
{
struct Library		*PPCLibBase;
struct TagItem		MyTags[10];
void			*PPCPort;
void			*ReplyPort;
void			*StartupMsg;
void			*M68kMsg;
void			*ElfObject;
void			*Task;
UBYTE			*Body;
struct StartupData	*StartupData;
void			*MyTimerObject;
ULONG			i,j;

  printf("Opening ppc.library\n");
  if (PPCLibBase = OpenLibrary("ppc.library", 44))
  {
    if (MyTimerObject=TimerCreateObject())
    {
      printf("Loading PPC object\n");
      if (ElfObject=PPCLoadObject("PROGDIR:Msg7PPC.elf"))
      {
        printf("Creating reply port\n");
        MyTags[0].ti_Tag	=	TAG_DONE;
        if (ReplyPort = PPCCreatePort(MyTags))
        {
          if (StartupMsg = PPCCreateMessage(ReplyPort, 0))
          {
            printf("Allocating StartupData\n");
            if (StartupData = PPCAllocVec(sizeof(struct StartupData), MEMF_ANY))
            {
              StartupData->MsgCount	=	MSGCOUNT;
              printf("Creating PPC task\n");
              MyTags[0].ti_Tag	=	PPCTASKTAG_STARTUP_MSG;
              MyTags[0].ti_Data	=(ULONG) StartupMsg;

              MyTags[1].ti_Tag	=	PPCTASKTAG_STARTUP_MSGDATA;
              MyTags[1].ti_Data	=(ULONG) StartupData;

              MyTags[2].ti_Tag	=	PPCTASKTAG_STARTUP_MSGLENGTH;
              MyTags[2].ti_Data	=	0;

              MyTags[3].ti_Tag	=	PPCTASKTAG_STARTUP_MSGID;
              MyTags[3].ti_Data	=	0;

              MyTags[4].ti_Tag	=	PPCTASKTAG_MSGPORT;
              MyTags[4].ti_Data	=	TRUE;

              MyTags[5].ti_Tag	=	TAG_DONE;

              if (Task = PPCCreateTask(ElfObject, MyTags))
              {
                if (PPCPort=(void*) PPCGetTaskAttrsTags(Task,
                                                        PPCTASKINFOTAG_MSGPORT,0,
                                                        TAG_END))
                {
                  printf("Allocating memory for message body\n");
                  if (Body = PPCAllocVec(BODYSIZE, MEMF_PUBLIC))
                  {
                    printf("Creating message...\n");
                    if (M68kMsg = PPCCreateMessage(ReplyPort, sizeof(TEXT)))
                    {
                      printf("Sending 1000 SYNCHRON messages with a *Body* and wait for each reply...");
                      TimerSetAttr(MyTimerObject,TIMERTAG_START);
                      for (i=0;i<MSGCOUNT;i++)
                      {
                        for (j=0;j<BODYSIZE;j++)
                        {
                          Body[j]	=	(i+j) & 0xff;
                        }

                        PPCSendMessage(PPCPort,
                                       M68kMsg,
                                       Body,
                                       BODYSIZE,
                                       0x12345678);

                        PPCWaitPort(ReplyPort);
                        PPCGetMessage(ReplyPort);
                      }
                      TimerSetAttr(MyTimerObject,TIMERTAG_STOP);
                      TimerShow(MyTimerObject);

                      printf("Waiting for Task Finish Msg...\n");
                      for (;;)
                      {
                        if ((M68kMsg=PPCGetMessage(ReplyPort)) == StartupMsg)
                        {
                          printf("Ahh..the expected Startup=Finish Msg was received.\nNow we can savely free all resources.\n");
                          break;
                        }
                        else
                        {
                          printf("Some non replied Msg 0x%lx was found..wait\n",
                                 M68kMsg);
                          PPCWaitPort(ReplyPort);
                        }
                      }

                      printf("Deleting message...\n");
                      PPCDeleteMessage(M68kMsg);
                    }
                    else
                    {
                      Printf("Could not create Msg\n");
                    }
                    PPCFreeVec(Body);
                  }
                  else
                  {
                    Printf("Could not alloc mem for msg body\n");
                  }
                }
                else
                {
                  Printf("Could not find the PPCTask's msgport\n");
                }
              }
              else
              {
                Printf("Could not create PPC task\n");
              }
              PPCFreeVec(StartupData);
            }
            else
            {
              Printf("Could not alloc Startup Data\n");
            }
            PPCDeleteMessage(StartupMsg);
          }
          else
          {
            Printf("Could not create Startup message\n");
          }
          PPCDeletePort(ReplyPort);
        }
        else
        {
          Printf("Could not create reply port\n");
        }
        printf("Unloading PPC object\n");
        PPCUnLoadObject(ElfObject);
      }
      else
      {
        Printf("Could not load the elfobject\n");
      }
      TimerDeleteObject(MyTimerObject);
    }
    printf("Closing ppc.library\n");
    CloseLibrary(PPCLibBase);
  }
  else
  {
    Printf("Could not open ppc.library v44+\n");
  }
}

