#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <utility/tagitem.h>
#include <powerup/ppclib/interface.h>
#include <powerup/ppclib/message.h>
#include <powerup/ppclib/tasks.h>
#include <powerup/gcclib/powerup_protos.h>

#define TEXT    "Text sent by PPC processor\n"
#define	DEBUG	0

BPTR		MyFile;
void		printf(char *String);
ULONG		DataArray[10];
char		TextBuffer[500];

struct StartupData
{
	void	*MsgPort;
	ULONG	MsgCount;
};


int	main(void)
{
struct TagItem		MyTags[10];
struct StartupData	*StartupData;
void			*ReplyPort;
void			*M68kPort;
void			*PPCMsg;
void			*Body;
ULONG			result;
ULONG			MsgCount;
ULONG			i;
void			**MsgArray;

  StartupData	=(struct StartupData *) PPCGetTaskAttr(PPCTASKTAG_STARTUP_MSGDATA);
  MsgCount	=	StartupData->MsgCount;

#if DEBUG
  if (MyFile = PPCOpen("con:0/0/640/200/MessageDemo - PPC output/CLOSE", MODE_NEWFILE))
  {
#endif
    if (MsgArray=(void**) PPCAllocVec(sizeof(void*) * MsgCount, MEMF_PUBLIC))
    {
      if (M68kPort=StartupData->MsgPort)
      {
#if DEBUG
        printf("Allocating memory for message body\n");
#endif
        if (Body = PPCAllocVec(sizeof(TEXT), MEMF_PUBLIC))
        {
#if DEBUG
          printf("Creating reply port\n");
#endif
          MyTags[0].ti_Tag = TAG_DONE;
          if (ReplyPort = PPCCreatePort(MyTags))
          {
#if DEBUG
            printf("Create 1000 Messages...");
#endif

            for (i=0;i<MsgCount;i++)
            {
              if ((MsgArray[i]=PPCCreateMessage(ReplyPort,
                                                sizeof(TEXT)))==NULL)
              {
                break;
              }
            }

#if DEBUG
            printf("done\n");
#endif

            if (i>=MsgCount)
            {
#if DEBUG
              printf("Sending 1000 Messages...");
#endif
              strcpy(Body, TEXT);

              for (i=0;i<MsgCount;i++)
              {
                PPCSendMessage(M68kPort,
                               MsgArray[i],
                               Body,
                               sizeof(TEXT),
                               i);
              }

#if DEBUG
              printf("done\n");
#endif

#if DEBUG
              printf("Waiting for 1000 Replies...");
#endif

              i	=	0;

              while (i<MsgCount)
              {
                PPCWaitPort(ReplyPort);
                while (i<MsgCount && (PPCMsg=PPCGetMessage(ReplyPort)))
                {
#if DEBUG1
                  DataArray[0]	=	PPCMsg;
                  DataArray[1]	=	PPCGetMessageAttr(PPCMsg, PPCMSGTAG_MSGID);
                  DataArray[2]	=	i;

                  PPCRawDoFmt("Msg 0x%lx(%ld) %ld\n",
                              &DataArray,
                              0,				/* 0=Buffer,1=serial,? NOT supported yet */
                              &TextBuffer);

                  PPCWrite(MyFile,
                           &TextBuffer,
                           strlen(&TextBuffer));

#endif

                  i++;
                }
*((ULONG*)0xfff01040)	=	i;
              }

#if DEBUG
              printf("done\n");
#endif

#if DEBUG
              printf("Deleting messages...\n");
#endif
              for (i=0;i<MsgCount;i++)
              {
                if (MsgArray[i])
                {
                  PPCDeleteMessage(MsgArray[i]);
                }
              }
            }
            else
            {
#if DEBUG
              printf("Could not create ppc msg\n");
#endif
            }

#if DEBUG
            printf("Deleting reply port\n");
#endif
            while (PPCDeletePort(ReplyPort) == FALSE);
          }
          else
          {
#if DEBUG
            printf("Could not create reply port\n");
#endif
          }

#if DEBUG
          printf("Freeing message body memory\n");
#endif
          PPCFreeVec(Body);
        }
        else
        {
#if DEBUG
          printf("Could not alloc mem for msg body\n");
#endif
        }
      }
      else
      {
#if DEBUG
        printf("Could not get a M68k msgport\n");
#endif
      }
      PPCFreeVec(MsgArray);
    }
    else
    {
#if DEBUG
      printf("Could not alloc mem for msg array\n");
#endif
    }

#if DEBUG
    printf("Closing output\n");
    PPCClose(MyFile);
  }
#endif
}

void	printf(char *String)
{
  PPCWrite(MyFile, String, strlen(String));
}

