#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <utility/tagitem.h>
#include <powerup/ppclib/interface.h>
#include <powerup/ppclib/message.h>
#include <powerup/ppclib/tasks.h>
#include <powerup/gcclib/powerup_protos.h>

#define text    "Text sent by PPC processor\n"
#define	DEBUG	0

struct StartupData
{
	ULONG	MsgCount;
};

BPTR    MyFile;
void printf(char *String);


int	main(void)
{
struct TagItem		MyTags[10];
struct StartupData	*StartupData;
void			*PPCPort;
void			*ReplyPort;
void			*PPCMsg;
void			*M68kMsg;
void			*Body;
ULONG			result;
ULONG			MsgCount;
ULONG			i;

  StartupData	=(struct StartupData *) PPCGetTaskAttr(PPCTASKTAG_STARTUP_MSGDATA);

  MsgCount	=	StartupData->MsgCount;

#if DEBUG
  if (MyFile = PPCOpen("con:0/0/640/200/MessageDemo - PPC output/CLOSE", MODE_NEWFILE))
  {
    printf("Creating message port\n");
#endif

    if (PPCPort=(void*) PPCGetTaskAttr(PPCTASKTAG_MSGPORT))
    {

#if DEBUG
      printf("Waiting for M68k message\n");
#endif
      i	=	0;
      while (i<MsgCount)
      {
        PPCWaitPort(PPCPort);

#if DEBUG
        printf("Getting message\n");
#endif
        while (i<MsgCount && (M68kMsg = PPCGetMessage(PPCPort)))
        {
#if DEBUG
          printf("Message: ");
          printf((char*) PPCGetMessageAttr(M68kMsg, PPCMSGTAG_DATA));
#endif
          PPCReplyMessage(M68kMsg);
          i++;
        }
      }

#if DEBUG
      printf("Deleting message port\n");
#endif
    }
    else
    {
#if DEBUG
      printf("Could not find PPC Task`s msgport\n");
#endif
    }

#if DEBUG
    printf("Closing output\n");
    PPCClose(MyFile);
  }
#endif
}

void printf(char *String)
{
  PPCWrite(MyFile, String, strlen(String));
}

