#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/memory.h>
#include <utility/tagitem.h>
#include <powerup/ppclib/interface.h>
#include <powerup/ppclib/message.h>
#include <powerup/ppclib/tasks.h>
#include <powerup/gcclib/powerup_protos.h>

#define TEXT    "Text sent by PPC processor\n"
#define	DEBUG	1

struct StartupData
{
	void	*MsgPort;
};

BPTR    MyFile;
void printf(char *String);


int	main(void)
{
struct TagItem		MyTags[10];
struct StartupData	*StartupData;
void			*PPCPort;
void			*ReplyPort;
void			*PPCMsg;
void			*M68kMsg;
void			*Body;
ULONG			result;

  StartupData	=(struct StartupData *) PPCGetTaskAttr(PPCTASKTAG_STARTUP_MSGDATA);

#if DEBUG
  if (MyFile = PPCOpen("con:0/0/640/200/MessageDemo - PPC output/CLOSE", MODE_NEWFILE))
  {
#endif

    if (PPCPort=(void*) PPCGetTaskAttr(PPCTASKTAG_MSGPORT))
    {
#if DEBUG
      printf("Waiting for M68k message\n");
#endif
      PPCWaitPort(PPCPort);

#if DEBUG
      printf("Getting message\n");
#endif
      if (M68kMsg = PPCGetMessage(PPCPort))
      {
#if DEBUG
        printf("Message: ");
        printf((char*) PPCGetMessageAttr(M68kMsg, PPCMSGTAG_DATA));
#endif
        PPCReplyMessage(M68kMsg);
      }
      else
      {
#if DEBUG
        printf("Did not get m68k msg\n");
#endif
      }

#if DEBUG
      printf("Allocating memory for message body\n");
#endif
      if (Body = PPCAllocVec(sizeof(TEXT), MEMF_PUBLIC))
      {
#if DEBUG
        printf("Creating reply port\n");
#endif
        MyTags[0].ti_Tag = TAG_DONE;
        if (ReplyPort = PPCCreatePort(MyTags))
        {
#if DEBUG
          printf("Creating message\n");
#endif
          if (PPCMsg = PPCCreateMessage(ReplyPort, sizeof(TEXT)))
          {
#if DEBUG
            printf("Sending message\n");
#endif
            strcpy(Body, TEXT);

            PPCSendMessage(StartupData->MsgPort,
                           PPCMsg,
                           Body,
                           sizeof(TEXT),
                           0x87654321);

#if DEBUG
            printf("Waiting for reply\n");
#endif
            PPCWaitPort(ReplyPort);

#if DEBUG
            printf("Deleting message\n");
#endif
            PPCDeleteMessage(PPCMsg);

          }
          else
          {
#if DEBUG
            printf("Could not create ppc msg\n");
#endif
          }

#if DEBUG
          printf("Deleting reply port\n");
#endif
          while (PPCDeletePort(ReplyPort) == FALSE);

        }
        else
        {
#if DEBUG
          printf("Could not create reply port\n");
#endif
        }

#if DEBUG
        printf("Freeing message body memory\n");
#endif
        PPCFreeVec(Body);
      }
      else
      {
#if DEBUG
        printf("Could not alloc mem for msg body\n");
#endif
      }
    }
    else
    {
#if DEBUG
      printf("Could not find the PPC Task`s msgport\n");
#endif
    }

#if DEBUG
    printf("Closing output\n");
    PPCClose(MyFile);
  }
#endif
}

void printf(char *String)
{
  PPCWrite(MyFile, String, strlen(String));
}

