#ifndef _SYS_VFS_H_
#define _SYS_VFS_H

typedef long fsid_t [2];

#define ST_RDONLY  0x01
#define ST_NOSUID  0x02
#define ST_NOTRUNC 0x04

struct statfs {
	long	f_type;     /* type of filesystem */
	long	f_bsize;    /* optimal transfer block size */
	long	f_blocks;   /* total data blocks in file system */
	long	f_bfree;    /* free blocks in fs */
	long	f_bavail;   /* free blocks avail to non-superuser */
	long	f_files;    /* total file nodes in file system */
	long	f_ffree;    /* free file nodes in fs */
	fsid_t	f_fsid;     /* file system id */
	long	f_namelen;  /* maximum length of filenames */
#define 	f_namemax      f_namelen
	char	f_basetype [32];
	long	f_flag;
};

int statfs (const char *path, struct statfs *s);
int fstatfs (int filedes, struct statfs *s);

#endif
