#ifndef _SYS_TYPES_INCLUDED
#define _SYS_TYPES_INCLUDED

#ifndef _BOOL_T
#define _BOOL_T
     typedef int bool_t;
#endif /* _DEV_T */

#ifndef _DEV_T
#define _DEV_T
     typedef long dev_t;
#endif /* _DEV_T */

#ifndef _ENUM_T
#define _ENUM_T
     typedef int enum_t;		/* For device numbers */
#endif /* _DEV_T */

#ifndef _INO_T
#define _INO_T
     typedef unsigned long ino_t;	/* For file serial numbers */
#endif /* _INO_T */

#ifndef _MODE_T
#define _MODE_T
     typedef unsigned short mode_t;	/* For file types and modes */
#endif /* _MODE_T */

#ifndef _NLINK_T
#define _NLINK_T
     typedef short nlink_t;		/* For link counts */
#endif /* _NLINK_T */

#ifndef _OFF_T
#define _OFF_T
     typedef long off_t;		/* For file offsets and sizes */
#endif /* _OFF_T */

#ifndef _PID_T
#define _PID_T
     typedef long pid_t;		/* For process and session IDs */
#endif /* _PID_T */

#ifndef _GID_T
#define _GID_T
     typedef long gid_t;		/* For group IDs */
#endif /* _GID_T */

#ifndef _UID_T
#define _UID_T
     typedef long uid_t;		/* For user IDs */
#endif /* _UID_T */

#ifndef _TIME_T
#define _TIME_T
     typedef long time_t;		/* For times in seconds */
#endif /* _TIME_T */

#ifndef _SIZE_T
#define _SIZE_T
     typedef unsigned int size_t;	/* Type returned by sizeof() */
#endif /* _SIZE_T */

#ifndef _SSIZE_T
#define _SSIZE_T
      typedef int ssize_t;		/* Signed version of size_t */
#endif /* _SSIZE_T */

#ifndef _SITE_T
#define _SITE_T
     typedef unsigned short __site_t;	/* see stat.h */
#endif /* _SITE_T */

#ifndef _CNODE_T
#define _CNODE_T
     typedef unsigned short __cnode_t;	/* see stat.h */
#endif /* _CNODE_T */

   typedef long __daddr_t;		/* For disk block addresses */
   typedef char *__caddr_t;		/* For character addresses */
   typedef long __swblk_t;

#ifndef _CADDR_T
#define _CADDR_T
     typedef __caddr_t		caddr_t;   /* also in ptrace.h */
#endif /* _CADDR_T */

   typedef unsigned char  ubit8;
   typedef unsigned short ubit16;
   typedef unsigned long  ubit32;
   typedef char 	  sbit8;
   typedef short	  sbit16;
   typedef long 	  sbit32;

   typedef ubit8	  u_char;
   typedef ubit16	  u_short;
   typedef ubit32	  u_long;
   typedef ubit32	  u_int;

   typedef __swblk_t	  swblk_t;
   typedef __daddr_t	  daddr_t;
   typedef __site_t	  site_t;
   typedef __cnode_t	  cnode_t;

   typedef long 	  paddr_t;
   typedef short	  cnt_t;
   typedef unsigned int   space_t;
   typedef unsigned int   prot_t;
   typedef unsigned long  cdno_t;
   typedef unsigned short use_t;

   typedef struct _physadr { int r[1]; } *physadr;
   typedef struct _quad { long val[2]; } quad;

   typedef char spu_t;

#include <sys/commtime.h>

#define btod(p, t) ((t)(((long)p)<<2))
#define dtob(p) ((BPTR)((long)(p)>>2))

#define MIN(x, y) ((x) < (y) ? (x):(y))
#define MAX(x, y) ((x) > (y) ? (x):(y))
#ifndef min
#define min(x, y) MIN(x, y)
#endif
#ifndef max
#define max(x, y) MAX(x, y)
#endif

#define DOS_TRUE -1
#define DOS_FALSE 0

#ifndef NULL
#define NULL 0L
#endif

/* Types, macros, etc. for select() */

#ifndef MAXFUPLIM
/*
 * MAXFUPLIM is the absolute limit of open files per process.  No process,
 * even super-user processes may increase u.u_maxof beyond MAXFUPLIM.
 * MAXFUPLIM means maximum files upper limit.
 * Important Note:  This definition should actually go into h/param.h, but
 * since it is needed by the select() macros which follow, it had to go here.
 * I did not put it in both files since h/param.h includes this file and that
 * would be error prone anyway.
 */
#define MAXFUPLIM 128	/* Max SOCKETS allowed */

/*
 * These macros are used for select().  select() uses bit masks of file
 * descriptors in longs.  These macros manipulate such bit fields (the
 * file sysrem macros uses chars).  FD_SETSIZE may be defined by the user,
 * but must be >= u.u_highestfd + 1.  Since we know the absolute limit on
 * number of per process open files is 2048, we need to define FD_SETSIZE
 * to be large enough to accomodate this many file descriptors.  Unless the
 * user has this many files opened, he should redefine FD_SETSIZE to a
 * smaller number.
 */
#define FD_SETSIZE MAXFUPLIM

     typedef long fd_mask;

#define NFDBITS (sizeof(fd_mask) * 8)           /* 8 bits per byte */

#ifndef howmany
#define howmany(x,y) (((x)+((y)-1))/(y))
#endif

     typedef struct fd_set {
       fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
     } fd_set;

#define FD_SET(n,p)  ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n,p) ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n,p) ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p) memset((p), 0, sizeof(*(p)))

#endif /* not MAXFUPLIM */

#endif /* _SYS_TYPES_INCLUDED */
