/*
 * inetconfig.h     -- Tag definitions for the ConfigureInet() function
 */

#include <utility/tagitem.h>

/* Tags */

/* INET_Gateway specifies whether inet.library should act as an IP gateway and
 * forward IP packets or merely ignore packets that don't belong to the given
 * machine.  ti_Data of TRUE turns gateway code ON.  ti_Data of FALSE turns
 * gateway code OFF.
 */

/* INET_DNS specifies whether we should use DNS to resolve hostnames and
 * addresses (if it's otherwise configured). ti_Data of TRUE turns DNS ON.
 * ti_Data of FALSE turns DNS OFF.
 */

/* INET_Query specifies that ti_Data points to a memory area at least
 * sizeof (struct InetQuery) and that the elements in the structure
 * should be filled in with the current values.
 */

/* INET_Errno specifies that ti_Data points to a "int *" where errors
 * should be stored (this would override a specification from setup_sockets()).
 */

/* INET_FDCallBack specifies that ti_Data points to a procedure which is
 * to be used to check for the validity of a socket number, prior to it
 * being assigned (this would override a specification from s_dev_func()).
 * The prototype is: u_long (__asm *function) (register __a0 int fd);
 */

/* INET_InputCallBack specifies that ti_Data points to a procedure that
 * will be called for every input packet. If that procedure returns zero,
 * the packet is passed to the protocol stack, otherwise the packet is
 * "dropped".
 * The prototype is: ULONG __asm InputCallBack (register __d0 int packettype,
 *						register __a0 void *sana2_device,
 *						register __a1 void *mbuf);
 */

/* INET_OutputCallBack specifies that ti_Data points to a procedure that
 * will be called for every output packet. If that procedure returns zero,
 * the packet is passed to the device driver, otherwise the packet is
 * "dropped".
 * The prototype is: ULONG __asm OutputCallBack (register __d0 int packettype,
 *						 register __a0 void *sana2_device,
 *						 register __a1 void *mbuf);
 */

/* INET_SignalIO specifies that ti_Data points to the signal bit that should
 * be Signal()'ed when SIGIO events occur. If there is an already existing
 * SIGIO signal, it will be freed. Changing this could cause severe problems
 * to already open sockets. When cleanup_sockets() is executed, or the
 * library is closed, the signal will be freed by the library, and should
 * _not_ be freed by the calling program.
 */

/* INET_SignalUrgent specifies that ti_Data points to the signal bit that should
 * be Signal()'ed when SIGURG events occur. If there is an already existing
 * SIGURG signal, it will be freed. Changing this could cause severe problems
 * to already open sockets. When cleanup_sockets() is executed, or the
 * library is closed, the signal will be freed by the library, and should
 * _not_ be freed by the calling program.
 */

/* INET_MaxSocks specifies that ti_Data points to value of the maximum number
 * of sockets that should be allowed to be opened by this program. This number
 * may not exceed FD_SETSIZE (currently 128), and will be ignored if it is, or
 * if it is less than or equal to zero.
 */

/* INET_ExtendedQuery specifies that ti_Data points to a memory area at least
 * sizeof (struct InetExtendedQuery) and that the elements in the structure
 * should be filled in with the current values.
 */

#define INET_Dummy	    (TAG_USER + 0xB8000)
#define INET_Gateway	    (INET_Dummy + 1)
#define INET_Query	    (INET_Dummy + 2)
#define INET_DNS	    (INET_Dummy + 3)
#define INET_Errno	    (INET_Dummy + 4)
#define INET_FDCallBack     (INET_Dummy + 5)
#define INET_InputCallBack  (INET_Dummy + 6)
#define INET_OutputCallBack (INET_Dummy + 7)
#define INET_SignalIO	    (INET_Dummy + 8)
#define INET_SignalUrgent   (INET_Dummy + 9)
#define INET_MaxSocks	    (INET_Dummy + 11)
#define INET_ExtendedQuery  (INET_Dummy + 12)

struct InetQuery
{
    BOOL iq_Gateway;
    BOOL iq_DNS;
};

struct InetExtendedQuery
{
    LONG    iq_Gateway;
    LONG    iq_DNS;
    LONG    iq_SignalIO;
    LONG    iq_SignalUrgent;
    LONG    iq_MaxSocks;
    LONG   *iq_Errno;
    LONG    iq_Filler [14];
};
