#ifndef _CLIB_RPC_PROTOS
#define _CLIB_RPC_PROTOS

#include <stdio.h>
#include <rpc/auth.h>
#include <rpc/clnt.h>
#include <rpc/svc.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

typedef bool_t (*resultproc_t)(caddr_t, struct sockaddr_in *);

/*Prototypes for functions defined in auth_none.c */

AUTH *authnone_create(void);

/*Prototypes for functions defined in auth_unix.c */

AUTH *authunix_create(char *, uid_t, gid_t, int, gid_t *);
AUTH *authunix_create_default(void);

/*Prototypes for functions defined in authunix_prot.c */

int xdr_authunix_parms(XDR *, struct authunix_parms *);

/*Prototypes for functions defined in bindresvport.c */

int bindresvport(int, struct sockaddr_in *);

/*Prototypes for functions defined in clnt_generic.c */

CLIENT *clnt_create(char *, u_long, u_long, char *);

/*Prototypes for functions defined in clnt_perror.c */

char *clnt_sperror(CLIENT *, char *);
void clnt_perror(CLIENT *, char *);
char *clnt_sperrno(enum clnt_stat);
void clnt_perrno(enum clnt_stat);
char *clnt_spcreateerror(char *);
void clnt_pcreateerror(char *);

/*Prototypes for functions defined in clnt_raw.c */

CLIENT *clntraw_create(u_long, u_long);

/*Prototypes for functions defined in clnt_simple.c */

int callrpc(char *, u_long, u_long, u_long, xdrproc_t, char *, xdrproc_t, char *);

/*Prototypes for functions defined in clnt_tcp.c */

CLIENT *clnttcp_create(struct sockaddr_in *, u_long, u_long, int *, u_int, u_int);

/*Prototypes for functions defined in clnt_udp.c */

CLIENT *clntudp_bufcreate(struct sockaddr_in *, u_long, u_long, struct timeval, int *, u_int, u_int);
CLIENT *clntudp_create(struct sockaddr_in *, u_long, u_long, struct timeval, int *);

/*Prototypes for functions defined in get_myaddress.c */

void get_myaddress(struct sockaddr_in *);

/*Prototypes for functions defined in getrpcent.c */

struct rpcent *getrpcbynumber(int);
struct rpcent *getrpcbyname(char *);
void setrpcent(int);
void endrpcent(void);
struct rpcent *getrpcent(void);

/*Prototypes for functions defined in getrpcport.c */

int getrpcport(char *, u_long, u_long, u_long);

/*Prototypes for functions defined in gettimeofday.c */

int gettimeofday(struct timeval *, struct timezone *);

/*Prototypes for functions defined in pmap_clnt.c */

int pmap_set(u_long, u_long, int, u_int);
int pmap_unset(u_long, u_long);

/*Prototypes for functions defined in pmap_getmaps.c */

struct pmaplist *pmap_getmaps(struct sockaddr_in *);

/*Prototypes for functions defined in pmap_getport.c */

u_short pmap_getport(struct sockaddr_in *, u_long, u_long, u_int);

/*Prototypes for functions defined in pmap_prot.c */

int xdr_pmap(XDR *, struct pmap *);

/*Prototypes for functions defined in pmap_prot2.c */

int xdr_pmaplist(XDR *, struct pmaplist **);

/*Prototypes for functions defined in pmap_rmt.c */

enum clnt_stat pmap_rmtcall(struct sockaddr_in *, u_long, u_long, u_long, xdrproc_t, caddr_t, xdrproc_t, caddr_t, struct timeval, u_long *);
int xdr_rmtcall_args(XDR *, struct rmtcallargs *);
int xdr_rmtcallres(XDR *, struct rmtcallres *);
enum clnt_stat clnt_broadcast(u_long, u_long, u_long, xdrproc_t, caddr_t, xdrproc_t, caddr_t, resultproc_t);

/*Prototypes for functions defined in requester.c */

BOOL requester(UBYTE *, UBYTE *, char *, ...);

/*Prototypes for functions defined in rpc_callmsg.c */

int xdr_callmsg(XDR *, struct rpc_msg *);

/*Prototypes for functions defined in rpc_prot.c */

int xdr_opaque_auth(XDR *, struct opaque_auth *);
int xdr_accepted_reply(XDR *, struct accepted_reply *);
int xdr_rejected_reply(XDR *, struct rejected_reply *);
int xdr_replymsg(XDR *, struct rpc_msg *);
int xdr_callhdr(XDR *, struct rpc_msg *);
void _seterr_reply(struct rpc_msg *, struct rpc_err *);

/*Prototypes for functions defined in svc.c */

void xprt_register(SVCXPRT *);
void xprt_unregister(SVCXPRT *);
int svc_register(SVCXPRT *, u_long, u_long, void (*)(), int);
void svc_unregister(u_long, u_long);
int svc_sendreply(SVCXPRT *, xdrproc_t, caddr_t);
void svcerr_noproc(SVCXPRT *);
void svcerr_decode(SVCXPRT *);
void svcerr_systemerr(SVCXPRT *);
void svcerr_auth(SVCXPRT *, enum auth_stat);
void svcerr_weakauth(SVCXPRT *);
void svcerr_noprog(SVCXPRT *);
void svcerr_progvers(SVCXPRT *, u_long, u_long);
void svc_getreq(int);
void svc_getreqset(fd_set *readfds);

/*Prototypes for functions defined in svc_auth.c */

enum auth_stat _authenticate(struct svc_req *, struct rpc_msg *);
enum auth_stat _svcauth_null(struct svc_req *, struct rpc_msg *);

/*Prototypes for functions defined in svc_auth_unix.c */

enum auth_stat _svcauth_unix(struct svc_req *, struct rpc_msg *);
enum auth_stat _svcauth_short(struct svc_req *, struct rpc_msg *);

/*Prototypes for functions defined in svc_raw.c */

SVCXPRT *svcraw_create(void);

/*Prototypes for functions defined in svc_run.c */

void svc_run(void);

/*Prototypes for functions defined in svc_simple.c */

int registerrpc(u_long, u_long, u_long, char *(*)(char *), xdrproc_t, xdrproc_t);

/*Prototypes for functions defined in svc_tcp.c */

SVCXPRT *svctcp_create(int, u_int, u_int);
SVCXPRT *svcfd_create(int, u_int, u_int);

/*Prototypes for functions defined in svc_udp.c */

SVCXPRT *svcudp_bufcreate(int, u_int, u_int);
SVCXPRT *svcudp_create(int);
int svcudp_enablecache(SVCXPRT *, u_long);

/*Prototypes for functions defined in xdr.c */

void xdr_free(xdrproc_t, char *);
int xdr_void(XDR *, void *);
int xdr_int(XDR *, int *);
int xdr_u_int(XDR *, u_int *);
int xdr_long(XDR *, long *);
int xdr_u_long(XDR *, u_long *);
int xdr_short(XDR *, short *);
int xdr_u_short(XDR *, u_short *);
int xdr_char(XDR *, char *);
int xdr_u_char(XDR *, u_char *);
int xdr_bool(XDR *, int *);
int xdr_enum(XDR *, int *);
int xdr_opaque(XDR *, caddr_t, u_int);
int xdr_bytes(XDR *, char **, u_int *, u_int);
int xdr_netobj(XDR *, struct netobj *);
int xdr_union(XDR *, int *, char *, struct xdr_discrim *, xdrproc_t);
int xdr_string(XDR *, char **, u_int);
int xdr_wrapstring(XDR *, char **);

/*Prototypes for functions defined in xdr_array.c */

int xdr_array(XDR *, caddr_t *, u_int *, u_int, u_int, xdrproc_t);
int xdr_vector(XDR *, char *, u_int, u_int, xdrproc_t);

/*Prototypes for functions defined in xdr_float.c */

int xdr_float(XDR *, float *);
int xdr_double(XDR *, double *);

/*Prototypes for functions defined in xdr_mem.c */

void xdrmem_create(XDR *, caddr_t, u_int, enum xdr_op);

/*Prototypes for functions defined in xdr_rec.c */

void xdrrec_create(XDR *, u_int, u_int, caddr_t, int (*)(void *, caddr_t, int),
		   int (*)(void *, caddr_t, int));
int xdrrec_skiprecord(XDR *);
int xdrrec_eof(XDR *);
int xdrrec_endofrecord(XDR *, int);

/*Prototypes for functions defined in xdr_reference.c */

int xdr_reference(XDR *, caddr_t *, u_int, xdrproc_t);
int xdr_pointer(XDR *, char **, u_int, xdrproc_t);

/*Prototypes for functions defined in xdr_stdio.c */

void xdrstdio_create(XDR *, FILE *, enum xdr_op);
#endif
