#ifndef  CLIB_NIPC_PROTOS_H
#define  CLIB_NIPC_PROTOS_H

/*
**	$Id: nipc_protos.h 1.2 1994/10/16 09:45:50 heinz Exp $
**
**	C prototypes. For use with 32 bit integers only.
**
**	(C) Copyright 1990-1994 Commodore-Amiga, Inc.
**	    All Rights Reserved
*/

#ifndef  EXEC_TYPES_H
#include <exec/types.h>
#endif
#ifndef  UTILITY_TAGITEM_H
#include <utility/tagitem.h>
#endif
#ifndef  ENVOY_NIPC_H
#include <envoy/nipc.h>
#endif
/*--- functions in V39 or higher (Release 3) ---*/
BOOL AddRoute( ULONG network, ULONG gateway, UWORD hops, WORD ttl );
APTR DeleteRoute( ULONG network );
/*--- (5 function slots reserved here) ---*/
struct Transaction *AllocTransactionA( struct TagItem *tags );
struct Transaction *AllocTransaction( Tag tag1, ... );
APTR FreeTransaction( struct Transaction *transaction );
/*---------------- Entities ---------------------------------------------------*/
struct Entity *CreateEntityA( struct TagItem *tags );
struct Entity *CreateEntity( Tag tag1, ... );
VOID DeleteEntity( struct Entity *entity );
struct Entity *FindEntity( STRPTR hostname, STRPTR entityname,
	struct Entity *src_entity, ULONG *detailerror );
VOID LoseEntity( struct Entity *entity );
/*---------------- NIPC I/O ---------------------------------------------------*/
BOOL DoTransaction( struct Entity *dest_entity, struct Entity *src_entity,
	struct Transaction *transaction );
BOOL BeginTransaction( struct Entity *dest_entity, struct Entity *src_entity,
	struct Transaction *transaction );
struct Transaction *GetTransaction( struct Entity *entity );
VOID ReplyTransaction( struct Transaction *transaction );
BOOL CheckTransaction( struct Transaction *transaction );
VOID AbortTransaction( struct Transaction *transaction );
VOID WaitTransaction( struct Transaction *transaction );
VOID WaitEntity( struct Entity *entity );
/*---------------- Network Information ----------------------------------------*/
BOOL GetEntityName( struct Entity *entity, STRPTR string, ULONG maxlen );
BOOL GetHostName( struct Entity *entity, STRPTR string, ULONG maxlen );
BOOL NIPCInquiryA( struct Hook *hook, ULONG maxTime, ULONG maxResponses,
	struct TagItem *tagList );
BOOL NIPCInquiry( struct Hook *hook, ULONG maxTime, ULONG maxResponses,
	Tag tag1, ... );
ULONG PingEntity( struct Entity *pingtarget, ULONG maxTime );
ULONG GetEntityAttrsA( struct Entity *entity, struct TagItem *tagList );
ULONG GetEntityAttrs( struct Entity *entity, Tag tag1, ... );
VOID SetEntityAttrsA( struct Entity *entity, struct TagItem *tagList );
VOID SetEntityAttrs( struct Entity *entity, Tag tag1, ... );
/*---------------- NIPC Buffer Management Routines ----------------------------*/
/*--- functions in V40 or higher (Release 3.1) ---*/
struct NIPCBuff *AllocNIPCBuff( ULONG entries );
struct NIPCBuffEntry *AllocNIPCBuffEntry( void );
ULONG CopyNIPCBuff( struct NIPCBuff *src_buff, struct NIPCBuff *dest_buff,
	ULONG srcoffset, ULONG dstoffset, ULONG length );
ULONG CopyToNIPCBuff( UBYTE *src_data, struct NIPCBuff *dest_buff,
	ULONG dstoffset, ULONG length );
ULONG CopyFromNIPCBuff( struct NIPCBuff *src_buff, UBYTE *dest_data,
	ULONG srcoffset, ULONG length );
VOID FreeNIPCBuff( struct NIPCBuff *buff );
VOID FreeNIPCBuffEntry( struct NIPCBuffEntry *entry );
ULONG NIPCBuffLength( struct NIPCBuff *buff );
VOID AppendNIPCBuff( struct NIPCBuff *first, struct NIPCBuff *second );
UBYTE *NIPCBuffPointer( struct NIPCBuff *buff, struct NIPCBuffEntry **,
	ULONG offset );
#endif   /* CLIB_NIPC_PROTOS_H */
