#ifndef  CLIB_ACCOUNTS_PROTOS_H
#define  CLIB_ACCOUNTS_PROTOS_H

/*
**	$Id: accounts_protos.h,v 1.3 1994/10/01 17:45:51 heinz Exp $
**
**	C prototypes. For use with 32 bit integers only.
**
**	(C) Copyright 1990-1994 Commodore-Amiga, Inc.
**	    All Rights Reserved
*/

#ifndef  EXEC_TYPES_H
#include <exec/types.h>
#endif
#ifndef  UTILITY_TAGITEM_H
#include <utility/tagitem.h>
#endif
#ifndef  ENVOY_ACCOUNTS_H
#include <envoy/accounts.h>
#endif
/*--- functions in V37 or higher (Release 2.04) ---*/
/* User and Group structure Allocation/Deallocation */
struct UserInfo *AllocUserInfo( void );
struct GroupInfo *AllocGroupInfo( void );
VOID FreeUserInfo( struct UserInfo * );
VOID FreeGroupInfo( struct GroupInfo * );
/* User Verification functions * */
ULONG VerifyUser( STRPTR userName, STRPTR password, struct UserInfo *user );
ULONG MemberOf( struct GroupInfo *group, struct UserInfo *user );
/* Functions to find users/groups or build lists of users/groups/members * */
ULONG NameToUser( STRPTR userName, struct UserInfo *user );
ULONG NameToGroup( STRPTR groupName, struct GroupInfo *group );
ULONG IDToUser( UWORD userID, struct UserInfo *user );
ULONG IDToGroup( UWORD groupID, struct GroupInfo *group );
ULONG NextUser( struct UserInfo *user );
ULONG NextGroup( struct GroupInfo *group );
ULONG NextMember( struct GroupInfo *group, struct UserInfo *user );
/* New Functions added for Revision 4 * */
STRPTR ECrypt( STRPTR buffer, STRPTR password, STRPTR username );
ULONG VerifyUserCrypt( STRPTR userName, STRPTR password,
	struct UserInfo *user );
#endif   /* CLIB_ACCOUNTS_PROTOS_H */
