/* Grab.rexx */
/* This demonstrates how to automatically build a CDXL file. */

/* The boss says "I wanna see RESULTS!" */
options results

/* Send commands to Art Department Professional */
address "ADPro"

/* We want to load frames from the FrameGrabber */
LFORMAT "FRAMEGRABBER"

/* We want normal IFF output files */
SFORMAT "IFF"

/* Search for the first frame of my scene */
address VIDEODISC.1 search 14173

/* We'll grab 1200 frames worth */
do frame = 1 to 1200

	address "ADPro"

	/* Grab the video */
	load "it" "FIELD1"

	/* I'm grabbing a letterboxed image, so I can throw some */
	/* of it away */
	OPERATOR "CROP_IMAGE" 280 120 20 40

	/* Shrink the image to the destination size */
	ABS_SCALE 192 82

	/* Generate the HAM image */
	EXECUTE

	/* Save it where XLMake can get at it */
	SAVE "RAM:Temp" "IMAGE"

	/* Some commands for COMMAND */
	ADDRESS COMMAND

	/* Keep the user informed */
	say "Saving frame #" frame

	/* Append the frame we just saved onto the end of our CDXL file */
	XLMAKE "-h" "RAM:Temp" "SDH0:bladerunner.xl"

	/* I know I'm going to have 15 frames / second or less, */
	/* so it's OK to only grab every other frame */
	address videodisc.1 step 2

/* Keep doin' it 'til it's done. */
end
