/***********************************************************************
***
*** CDTV - Read Preferences
***
***     Copyright (C) 1990 Commodore-Amiga, Inc.
***     Permission granted for use in CDTV applications.
***     Author: Carl Sassenrath, Ukiah, CA  (30-DEC-90)
***
************************************************************************
***
***     What:
***       This example will read the CDTV preferences data
***       structure from bookmark memory.  If the structure
***       cannot be found, an error will result.
***
***     Notes:
***       1. Read the notes in cdtvprefs.h!
***       2. Currently tested with Manx C compiler only.
***
***
***********************************************************************/

#include <exec/types.h>
#include <exec/io.h>
#include <devices/bookmark.h>
#include <devices/cdtvprefs.h>

extern  struct  IOStdReq *CreateStdIO();
extern  struct  MsgPort  *CreatePort();
struct  IOStdReq *IOReq1 = NULL;
struct  MsgPort  *IOPort = NULL;
struct  CDTVPrefs ThePrefs;

char    AssertFail[] = "Assertion failed (MUST)";
#define MUST(expr)  if (!(expr)) Quit(AssertFail);

/***********************************************************************
***
***  Main
***
***********************************************************************/
main(argc,argv)
        int argc;
        char *argv[];
{
        int err;

        printf("CDTV Read Preferences Example (30-Dec-90)\n");

        Init();

        if (DoIOR(IOReq1, CMD_READ, 0, sizeof(ThePrefs), &ThePrefs))
                Quit("CMD_READ failed");

        printf("Prefs contents: %d %d %d %d 0x%x\n",
                ThePrefs.DisplayX,
                ThePrefs.DisplayY,
                ThePrefs.Language,
                ThePrefs.AudioVol,
                ThePrefs.Flags);

        Quit(0);
}

/***********************************************************************
***
***  Init -- initialize program and structures
***
***********************************************************************/
Init()
{
        MUST(IOPort = CreatePort(0,0));
        MUST(IOReq1 = CreateStdIO(IOPort));

        if (OpenDevice("bookmark.device",BID_CDTVPREFS,IOReq1,0))
                Quit("Bookmark device will not open");
}

/***********************************************************************
***
***  Quit -- exit program and clean-up.  Return an error if needed.
***
***********************************************************************/
Quit(s)
        char *s;        /* error message */
{
        if (IOReq1)
        {
                if (IOReq1->io_Device) CloseDevice(IOReq1);
                DeleteStdIO(IOReq1);
        }
        if (IOPort)     DeletePort(IOPort);
        if (s) {printf("\nERROR: %s\n",s); exit(40);}
        else exit(0);
}

/***********************************************************************
***
***  DoIOR -- execute a device command
***
***********************************************************************/
DoIOR(req,cmd,off,len,data)
        struct IOStdReq *req;
        int cmd;
        long off;
        long len;
        APTR data;
{
        req->io_Command = cmd;
        req->io_Offset = off;
        req->io_Length = len;
        req->io_Data   = data;
        return DoIO(req);
}

