*
*  memcard_Boot.asm
*
*	Test $E00000 memory card at reboot for DIAG_CART and RomTag success.
*
*	Kaori Kuwata/CDTV Project  Feb 7,1991
*
*
	INCLUDE	"exec/types.i"
	INCLUDE	"exec/resident.i"
	INCLUDE "hardware/custom.i"
	INCLUDE "hardware/cia.i"

TRYDIAG		EQU	0

CUSTOM		EQU	$DFF000
CIAADDRA	EQU	$BFE201
CIAAPRA		EQU	$BFE001

VERSION		EQU	34

CARTBASE	EQU	$E00000
COOKIE		EQU	$1111

COLORON		EQU	$0200
CC_PINK		EQU	$0F89
CC_PURPLE	EQU	$086B

ODELAY		EQU	$16
IDELAY		EQU	$8000

RW_PROTECT	EQU	$5257	;Write Protect code
		CODE
Start:
* This doesn't work - I don't know why... RomTag Works though

	IFGT	TRYDIAG

CartCookie:	DC.W	COOKIE

DiagCartCode:
*--- Turn off ROM phantom and clear overlay
	MOVE.B	#(CIAF_OVERLAY!CIAF_LED),CIAADDRA
	MOVE.B	#CIAF_LED,CIAAPRA

*--- Disable and clear all interrupts
	MOVE.L	#CUSTOM,a0
	MOVE	#$7FFF,d0
	MOVE	d0,intena(a0)
	MOVE	d0,intreq(a0)
	MOVE	d0,dmacon(a0)

*--- Make a pink screen for a bit
	MOVE.W	#COLORON,bplcon0(a0)
	MOVE.W	#0,bpldat(a0)
	MOVE.W	#CC_PINK,color(a0)

	MOVE.L	#ODELAY,d1
1$	MOVE.L	#IDELAY,d0
2$	SUB.L	#1,d0
	BNE.S	2$
	SUB.L	#1,d1
	BNE.S	1$

	JMP 	(a5)

	DC.L	0

	ENDC

	DC.W	RW_PROTECT			;Write protect code
RomTag:
						;STRUCTURE RT,0
	DC.W	RTC_MATCHWORD			;UWORD RT_MATCHWORD
	DC.L	CARTBASE+(RomTag-Start)		;APTR  RT_MATCHTAG
	DC.L	CARTBASE+(endtag-Start)		;APTR  RT_ENDSKIP
	DC.B	RTF_COLDSTART			;UBYTE RT_FLAGS
	DC.B	VERSION				;UBYTE RT_VERSION
	DC.B	0				;UBYTE RT_TYPE
	DC.B	70				;BYTE  RT_PRI
	DC.L	CARTBASE+(modName-Start)	;APTR  RT_NAME
	DC.L	CARTBASE+(idtag-Start)		;APTR  RT_IDSTRING
	DC.L	CARTBASE+(Init-Start)		;APTR  RT_INIT
						;LABEL RT_SIZE

modName:
	DC.B	'romTag.memcard_Boot',0
	DC.W	0
idtag:
	DC.B    'memcard_Boot (07 Feb 91)',13,10,0
	CNOP	0,4
	DC.W	0
endtag:

Init:
*--- Make a purple screen for a bit
	MOVE.L	#CUSTOM,a0
	MOVE.W	#COLORON,bplcon0(a0)
	MOVE.W	#0,bpldat(a0)
	MOVE.W	#CC_PURPLE,color(a0)

	MOVE.L	#ODELAY,d1
1$	MOVE.L	#IDELAY,d0
2$	SUB.L	#1,d0
	BNE.S	2$
	SUB.L	#1,d1
	BNE.S	1$

	RTS

	END

