/****************************************************************************
*                                                                           *
* Copyright (c) 1991 Commodore Business Machines, Inc.                      *
* The source code examples included are used on the Welcome Disc.  These    *
* examples are provided for information purposes only, on an "as is" basis. *
* No warranties of any nature, express or implied, are made.  Any use       *
* of these examples is at your own risk with no liability or responsability *
* of any kind being assumed by Commodore, its suppliers and developers,     *
* or their employees.                                                       *
*                                                                           *
* Subject to these limitations, executables based upon these examples       *
* may be developed and used in software for the Commodore CDTV.   All       *
* other rights are reserved.                                                *
*                                                                           *
****************************************************************************/


/****************************************************************************

  prefs.c -- written by Ray Lambert for Theta Systems, Inc. -- jan-apr 1991

****************************************************************************/


#include "keeper.h"
#include <exec/io.h>
#include <graphics/gfxbase.h>
#include <graphics/view.h>
#include <proto/exec.h>
#include "cdtvprefs.h"

extern struct GfxBase *GfxBase;


/*
**  This routine attempts to get the CDTV preferences -- if the preferences
**  prove be be elusive for any reason it sets up some sensible defaults.
**  Note that ASL is only concerned with view centering, language selection
**  and audio volume, and therefore generally sets up defaults only for these.
**  We take deafult view centering information from Workbench's view (which
**  is expected to still be active when this routine is called), and set our
**  default language to UNKNOWN.  We set the default audio volume to full
**  volume because the user can always lower the volume on their television
**  or stereo receiver, but if our volume isn't loud enough they may not be
**  capable of raising that volume sufficiently.
*/
void ReadPrefs(struct CDTVPrefs *prefs)
{
  unless( BookMarkPrefs(prefs) )
    {
      prefs->DisplayX = GfxBase->ActiView->DxOffset;  /* get view positioning */
      prefs->DisplayY = GfxBase->ActiView->DyOffset;  /* from Intuition view  */
      prefs->AudioVol = 16;
      prefs->Flags    = (CDTVPF_AUDIOVOL|CDTVPF_AMPM);
      prefs->Language = CDTVLANG_UNKNOWN;
    }
}


/*
**  An example of reading the CDTV preferences...
*/
int BookMarkPrefs(struct CDTVPrefs *prefs)
{
  struct IOStdReq *io;
  struct MsgPort  *mp;
  int rc = FALSE;

/** try opening 'bookmark.device' **/
  unless( mp = CreatePort(0,0) ) goto fail1;
  unless( io = CreateStdIO(mp) ) goto fail2;
  if (OpenDevice("bookmark.device",BID_CDTVPREFS,io,0)) goto fail3;

/** try reading prefs from 'bookmark.device' **/
  io->io_Command = CMD_READ;
  io->io_Data    = (APTR)prefs;
  io->io_Length  = sizeof(*prefs);
  io->io_Offset  = 0;
  if ( (DoIO(io) == 0) && (prefs->Language != CDTVLANG_UNKNOWN) ) rc = TRUE;
  CloseDevice(io);

fail3:
  DeleteStdIO(io);
fail2:
  DeletePort(mp);
fail1:
  return(rc);
}
