*****************************************************************************
*
*	packcmap.asm -- written by Ray Lambert for Theta Systems, Inc.
*
*	Copyright 1991 Commodore Business Machines, Inc.
*
*****************************************************************************

		INCLUDE		"keeper.i"

*****************************************************************************
*
* Synopsis:
*	void PackCMAP(UBYTE *src, UWORD *cmap, ULONG colors)
*
* Parameters:
*	src	: pointer to source data in RGB bytes
*	cmap	: pointer to detination color map
*	colors	: number of colors to pack
*
* Returns:	(in D0:)
*	none
*
* Description:
* 	This routine takes RGB bytes from 'src' and packs them into 'cmap'
*	nybbles.  'colors' indicates the number of cmap entries to be 
*	packed -- 'src' is expected to contain 'colors' * 3 bytes.
*
*****************************************************************************

		FUNCTION	_PackCMAP,0
		ARGUMENTS
		ARG		_APTR,src
		ARG		_APTR,cmap
		ARG		_ULONG,colors
		push.l		d2

		move.l		colors(a5),d0
		move.l		src(a5),a0
		move.l		cmap(a5),a1
		dec.l		d0		; correct for dbra
1$
		move.b		(a0)+,d1	; d1: xxRx
		lsl.w		#4,d1		; d1: xRx0
		move.b		(a0)+,d1	; d1: xRGx
		and.w		#$0ff0,d1	; d1: 0RG0
		move.b		(a0)+,d2	; d2: xxBx
		lsr.b		#4,d2		; d2: xx0B
		or.b		d2,d1		; d1: 0RGB
		move.w		d1,(a1)+
		dbra		d0,1$

		pull.l		d2
		RETURN		_PackCMAP


		END
