
*
* stdasm.i : ray's standard assembler thingies
*
		INCLUDE 	"exec/exec_equ.i"
		INCLUDE 	"exec/types.i"
		INCLUDE 	"exec/libraries.i"

*
* some constants
*
ABS_EXECBASE	EQU		4
CHIPBASE	EQU		$00DFF000
CIAABASE	EQU		$00BFE001
CIABBASE	EQU		$00BFD000

*
* standard library base pointers
*
		XREF		_DOSBase
		XREF		_GfxBase
		XREF		_IntuitionBase

*
* macros
*
* use the following macro when A6 is correct
*
JSRLIB		MACRO
		JSR		_LVO\1(A6)
		ENDM
*
* use the following macros when A6 is incorrect
*
JSRSYS		MACRO
		MOVE.L		ABS_EXECBASE,A6
		JSRLIB		\1
		ENDM

JSRDOS		MACRO
		MOVE.L		_DOSBase,A6
		JSRLIB		\1
		ENDM

JSRINT		MACRO
		MOVE.L		_IntuitionBase,A6
		JSRLIB		\1
		ENDM

JSRGFX		MACRO
		MOVE.L		_GfxBase,A6
		JSRLIB		\1
		ENDM

*
* miscellaneous
*
INC		MACRO
		addq.\0		#1,\1
		ENDM

DEC		MACRO
		subq.\0		#1,\1
		ENDM

BLO		MACRO
		bcs.\0		\1
		ENDM

BHS		MACRO
		bcc.\0		\1
		ENDM

PUSH		MACRO
		move.\0		\1,-(sp)
		ENDM

PULL		MACRO
		move.\0		(sp)+,\1
		ENDM

PUSHM		MACRO
		movem.\0	\1,-(sp)
		ENDM

PULLM		MACRO
		movem.\0	(sp)+,\1
		ENDM

* USAGE: FUNCTION <function name>,<size of stack frame>[,<reg list for save>]
* FUNCTION macro; declares a C-language-callable function; may also be used
* for any function which expects a C-language-like interface (stack frame,
* etc.); function is externally defined (XDEF); A5 is saved and an optional 
* local stack frame is created both using the LINK instruction (if no local
* stack frame is required pass 0 for <size of stack frame>); an optional
* register list may also be provided to be saved via MOVEM.L
FUNCTION	MACRO
		XDEF		\1
\1		link		a5,#-\2
		IFEQ NARG-3
\1_REGS		REG		\3
		movem.l		\3,-(sp)
		ENDC
		ENDM

* USAGE: RETURN <function name>
* RETURN macro; returns from a C-language-callable function which was defined
* with the FUNCTION macro; any registers that were saved by FUNCTION are
* restored and UNLK is called to restore A5 and to free the local stack
* frame; lastly, RTS is exectued
RETURN		MACRO
		IFD \1_REGS
		movem.l		(sp)+,\1_REGS
		ENDC
		unlk		a5
		rts
		ENDM

* USAGE: ARGUMENT [offset]
* ARGUMENT macro; initializes argument pointer for ARG macro;
* optional argument replaces stack frame default offset which is 8 based on
* existence of return address and usage of the LINK instruction;
ARGUMENTS	MACRO
		IFEQ NARG-1
_ARGPT_		SET		\1
		MEXIT
		ENDC
_ARGPT_		SET		8
		ENDM

* USAGE: ARG <type>, <name>
* ARG macro; assigns current argument pointer to argument name and
* advances argument pointer to next argument position; argument pointer
* is advanced by the size of the argument data type; for unusual data types
* a label or numeric constant may be used in place of argument type;
* argument type should otherwise be one of those defined below
ARG		MACRO
\2		SET		_ARGPT_
_ARGPT_		SET		_ARGPT_+\1
		ENDM

* USAGE: LOCAL_STACK [start]
* LOCAL_STACK macro; initializes the stack frame pointer for the AUTO macro;
* optional start value may be used to initilize the stack frame pointer to
* a value other than the default of 0
LOCAL_STACK	MACRO
		IFEQ NARG-1
_AUTOPT_	SET		\1
SFSIZE		SET		+\1
		MEXIT
		ENDC
_AUTOPT_	SET		0
SFSIZE		SET		0
		ENDM

* USAGE: AUTO <type>, <name>
* AUTO macro; assigns current stack frame pointer to argument name and
* advances stack frame pointer to next stack frame position; stack frame 
* pointer is advanced by the size of the argument data type; for unusual 
* data types a label or numeric constant may be used in place of argument 
* type; argument type should otherwise be one of those defined below
AUTO		MACRO
_AUTOPT_	SET		_AUTOPT_-\1
\2		SET		_AUTOPT_
SFSIZE		SET		SFSIZE+\1
		ENDM

* argument types
_BOOL		EQU		2
_BYTE		EQU		1
_UBYTE		EQU		1
_WORD		EQU		2
_UWORD		EQU		2
_SHORT		EQU		2
_USHORT		EQU		2
_LONG		EQU		4
_ULONG		EQU		4
_FLOAT		EQU		4
_APTR		EQU		4
_BPTR		EQU		4
_CPTR		EQU		4
_RPTR		EQU		2
_LABEL		EQU		0
