#include <exec/types.h>
#include <graphics/gfx.h>
#include <libraries/dos.h>

#define DBG           0

#define CHIPBASE      ((struct Custom *)0x00DFF000)
#define until(x)      while(!(x))
#define unless(x)     if (!(x))

/*
**  the structure used to track a resident bitmap -- expand or shrink
**  as neccessary to include more or less PLANEPTRs
*/
struct BLITmap
{
  short w;        /* bitmap pixel width                           */
  short h;        /* bitmap pixel height                          */
  short d;        /* bitmap depth (number of planes)              */
  short wpl;      /* data words per bitmap line                   */
  ULONG modes;    /* video modes bits                             */
  UWORD cmap[32]; /* color map                                    */
  PLANEPTR m;     /* optional mask plane (built algorithmically)  */
  PLANEPTR p[8];  /* pointers to individual planes                */
};

extern struct BLITmap *loadILBM(char *);
extern void unloadILBM(struct BLITmap *);
extern void BLITmap2BitMap(struct BLITmap *,struct BitMap *);
