*****************************************************************************
*
*	Blackcfg -- written by Ray Lambert for Theta Systems, Inc.
*
*	Copyright 1991 Commodore Business Machines, Inc.
*
*****************************************************************************


		INCLUDE		"keeper.i"
		INCLUDE		"exec/ports.i"
		INCLUDE		"libraries/dos.i"
		INCLUDE		"libraries/dosextens.i"
		INCLUDE		"libraries/dos_equ.i"


		CSEG


startup
* save command tail info in safe registers
		move.l		d0,d3
		move.l		a0,a3
* check if we've been run from Workbench or CLI
		move.l		#0,a1
		jsrsys		FindTask		; get task ptr
		move.l		d0,a1
		tst.l  		pr_CLI(a1)
		bne     	cli_startup

* wb_startup -- humor Workbench a little then quit
		lea		pr_MsgPort(a1),a2       ; our process port
		move.l		a2,a0
		jsrlib		WaitPort
		move.l		a2,a0
		jsrlib		GetMsg
		move.l		d0,d2
		jsrlib		Forbid
		move.l		d2,a1
		jsrlib		ReplyMsg
		rts

cli_startup	lea		dosname,a1	; open dos.library
		moveq.l		#0,d0
		jsrlib		OpenLibrary
		move.l		d0,_DOSBase
		bne		1$
		move.l		#RETURN_FAIL,d0
		bra		abort
* get console output handle
1$		jsrdos		Output
		move.l		d0,stdout

* process command line
       		move.b		#0,-1(a3,d3.w)	; 0-delimit the command line
2$		move.b		(a3),d0		; skip leading spaces
		cmp.b		#$20,d0
		beq		3$
		cmp.b		#$09,d0		; and tabs!
		bne		4$
3$		inc.l		a3
		bra		2$

* attempt to open the file
4$		tst.b		(a3)		; no filename?
		bne		5$
		lea		usagemsg,a0
		bra		abortmsg
5$		move.l		a3,d1
		move.l		#MODE_OLDFILE,d2
		jsrlib		Open
		move.l		d0,file
		bne		6$
		lea		badfilemsg,a0
		bra		abortmsg
* patch mouse pointer colors offsets $66, $68, $6a
6$		move.l		file,d1
		move.l		#$66,d2
		move.l		#OFFSET_BEGINNING,d3
		jsrlib		Seek
		move.l		file,d1
		lea		zeros,a0
		move.l		a0,d2
		move.l		#6,d3
		jsrlib		Write
* patch screen colors offsets $6e, $70, $72, $74
		move.l		file,d1
		move.l		#$6e,d2
		move.l		#OFFSET_BEGINNING,d3
		jsrlib		Seek
		move.l		file,d1
		lea		zeros,a0
		move.l		a0,d2
		move.l		#8,d3
		jsrlib		Write
* all done!
		lea		okaymsg,a0
abortmsg	bsr		putmsg
abort		move.l		_DOSBase,a6
		cmp.l		#0,a6
		beq		98$
		move.l		file,d1
		beq		99$
		jsrlib		Close
99$		move.l		a6,a1
		jsrsys		CloseLibrary
98$		moveq		#0,d0
		rts



putmsg
		pushm.l		d2/d3/a6
		move.l		a0,a1
1$		tst.b		(a1)+
		bne		1$
		dec.l		a1
		sub.l		a0,a1
		move.l		a1,d3		; string length
		move.l		a0,d2		; string pointer
		move.l		stdout,d1	; console file handle
		beq		ng
		move.l		_DOSBase,a6
		cmp.l		#0,a6
		beq		ng
		jsrlib		Write
ng		pullm.l		d2/d3/a6
		rts



		DSEG

_DOSBase	dc.l		0
stdout		dc.l		0
file		dc.l		0
zeros		dc.w		0,0,0,0
dosname		dc.b		'dos.library',0
usagemsg	dc.b		10,'Blackcfg -- A tool to make all colors stored in a',10
		dc.b		'Preferences file (system-configuration) black for',10
		dc.b		'booting with a black screen.',10,10
		dc.b		'Written by Ray Lambert for Theta Systems, Inc.',10
		dc.b		'Copyright 1991 Commodore Business Machines, Inc.',10,10
		dc.b		'Usage: blackcfg <system-configuration-file>',10
		dc.b		'TAKE HEED!! This file will be irreversibly modified!',10,10,0
badfilemsg	dc.b		'Sorry, unable to open that file.',10,0
okaymsg		dc.b		'Done!',10,0


		END
