#ifndef BOOKMARK_H
#define BOOKMARK_H
/*
** Bookmark/Cardmark Device Include File
**
**	Copyright (c) 1991 Commodore Electronics Ltd.
**	All rights reserved. Confidential and Proprietary.
**	CDTV is a trademark of Commodore Electronics Ltd.
**
**	Written by: Carl Sassenrath
**	            Sassenrath Research, Ukiah, CA
**
**	Version of: March 8, 1991
*/

#ifndef	EXEC_IO_H
#include <exec/io.h>
#endif

/*
** Bookmark (Cardmark) Device Names
**
**	Names passed to OpenDevice to identify the device.
*/
#define	BOOKMARK_NAME	"bookmark.device"
#define	CARDMARK_NAME	"cardmark.device"

/*
** Bookmark (Cardmark) Device Commands
*/
#define	BD_TYPEMEM	 9
#define	BD_SIZEMEM	10
#define	BD_INITMEM	11
#define	BD_CREATEDEV	12
#define	BD_CREATE	13
#define	BD_DELETE	14
#define	BD_MAXSIZE	15
#define	BD_AVAIL	16
#define	BD_SIZEOF	17
#define	BD_SETPRI	18
#define	BD_CHECK	19
#define	BD_PURGE	20
#define	BD_DUMP		21
#define	BD_LOAD		22

/*
** Bookmark (CardMark) Device Errors
*/
#define	BDERR_OPENFAIL	-1	/* OpenDevice() failed		*/
#define	BDERR_ABORTED	-2	/* Command has been aborted	*/
#define	BDERR_NOTVALID	-3	/* IO request not valid		*/
#define	BDERR_NOCMD	-4	/* No such command		*/
#define	BDERR_BADARG	-5	/* Bad command argument		*/
#define	BDERR_EXISTS	-6	/* Bookmark already exists	*/
#define	BDERR_NOMARK	-7	/* No bookmark present		*/
#define	BDERR_TOOBIG	-8	/* Bookmark larger than allowed	*/
#define	BDERR_NOSPACE	-9	/* Not enough space in memory	*/
#define	BDERR_PASTEND	-10	/* Length + Offset > Bookmark	*/

/*
** Bookmark ID Structure
*/
struct BookmarkID
{
	UWORD Manufacturer;
	UWORD Product;
};

#define	MAKEBID(m,p) ((ULONG)(((UWORD)(m)<<16)|(UWORD)(p)))

#endif	/* BOOKMARK_H */
