/* :ts=8
*
*	deboxproto.h
*
* William A. Ware					9006.20
* Adjustments to types (void *), readability
* ennhancement.						9010.01	ewhac
*
**
**      Copyright (c) 1991 Commodore Electronics Ltd.
**      All rights reserved. Confidential and Proprietary.
**      CDTV is a trademark of Commodore Electronics Ltd.
**/


/* PRIVATE */
VOID			Eor		(UBYTE *, ULONG, UBYTE *);

/* PUBLIC */
BYTE 			CheckHeader	(struct CompHeader *header);
ULONG			HeaderSize	(struct CompHeader *header);
void			*NextComp	(struct CompHeader *header, void *indata);
LONG 			DecompData	(struct CompHeader *header,
					 void *indata, void *outdata);

ULONG			BMInfoSize	(struct CompHeader *header, void *indata);
struct BMInfo		*DecompBMInfo	(struct BMInfo *bminfo,
					 struct CompHeader *header, void *indata);
VOID			FreeBMInfo	(struct BMInfo *bminfo);
LONG 			DecompBitMap	(struct CompHeader *header, void *indata,
					 struct BitMap *bitmap, UBYTE *mask);
LONG			MemSet		(void *buffer, BYTE value, ULONG size);
struct BitMap  		*AllocBitMap	(UWORD depth, UWORD width, UWORD height);
VOID			FreeBitMap	(struct BitMap *bitmap);

struct SuperView	*CreateView	(struct SuperView *superview, struct BitMap *bitmap,
					 UWORD width, UWORD height, UWORD modes);
VOID			DeleteView	(struct SuperView *superview);
VOID			CenterViewPort	(struct View *view,struct ViewPort *viewport);

int			CycleColors	(struct BMInfo *bminfo, ULONG microsec);

#ifndef  NO_PRAGMAS
/*----------------------------------------------------------------------*/
/*pragma libcall DeBoxBase Decomp 1E BA9804*/
/*pragma libcall DeBoxBase STDDecomp 24 0A9804*/
/*pragma libcall DeBoxBase Eor 2A 90803*/
/*- header*/
#pragma libcall DeBoxBase CheckHeader 30 801
#pragma libcall DeBoxBase HeaderSize 36 801
#pragma libcall DeBoxBase NextComp 3C 9802
/*- decompression*/
#pragma libcall DeBoxBase DecompData 42 A9803
/*- bitmap decompression.*/
#pragma libcall DeBoxBase BMInfoSize 48 9802
#pragma libcall DeBoxBase DecompBMInfo 4E A9803
#pragma libcall DeBoxBase FreeBMInfo 54 801
#pragma libcall DeBoxBase DecompBitMap 5A BA9804
/*- other*/
#pragma libcall DeBoxBase MemSet 60 10803
#pragma libcall DeBoxBase AllocBitMap 66 21003
#pragma libcall DeBoxBase FreeBitMap 6C 801
/*- view*/
#pragma libcall DeBoxBase CreateView 72 2109805
#pragma libcall DeBoxBase DeleteView 78 801
#pragma libcall DeBoxBase CenterViewPort 7E 9802
/*- cycle*/
#pragma libcall DeBoxBase CycleColors 84 0802

#endif
