* :ts=8
*
*	debox.i -- Header for ASM decompress code
*
* William A. Ware					9006.20
* Regenerated by hand.  MASSIVE CHANGES!		9010.01
**
**      Copyright (c) 1991 Commodore Electronics Ltd.
**      All rights reserved. Confidential and Proprietary.
**      CDTV is a trademark of Commodore Electronics Ltd.
**

		IFND	DEBOX_I
DEBOX_I		SET	1

		IFND	EXEC_TYPES_I
		include	"exec/types.i"
		ENDC

		IFND	GRAPHICS_VIEW_I
		include	"graphics/view.i"
		ENDC


*\
* DeBox file types.
*/
DEBOXTYPE_UNKNOWN	EQU	0	; Unspecified data.
DEBOXTYPE_PIC		EQU	1	; Picture.

*\
* Error codes.
*/
DEBOXERR_HEADER		EQU	-1	; Header is invalid.
DEBOXERR_DATA		EQU	-2	; Data has an error in it.
DEBOXERR_TYPE		EQU	-3	; Data is the wrong type of file.
					; ie DEBOXTYPE_UNKNOWN instead of
					; DEBOXTYPE_PIC.
DEBOXERR_MEMORY		EQU	-4	; Not enough memory to decompress
					; file.

	STRUCTURE CompHeader,0
		UBYTE	ci_Check	; Checksum for the header.
		UBYTE	ci_Version	; Version for the compression.
		UBYTE	ci_pad		; Reserved for future use.
		UBYTE	ci_Type		; Type of data, e.g. DEBOXTYPE_PIC,
					; DEBOXTYPE_UNKNOWN, et al.
		ULONG	ci_DataInfo	; Info on data -- for library's use.
		LONG	ci_Size		; Size of uncompressed data.
		LONG	ci_CSize	; Size of compressed data.
	LABEL	ci_SIZEOF


*\
* Notes on BMInfo:
*
* bmi_TotalSize:
*	DecompBMInfo() allocates everything together so there are private
* parts after this structure.  This is the total size of the entire
* structure, public and private.
*
* bmi_TransparentColor:
*	If BMIF_TRANSPARENT_COLOR is set in bmi_Flags, then this field can be
* used to make a mask out of the decompressed bit map.
*/
	STRUCTURE BMInfo,0
		ULONG	bmi_TotalSize	; See notes above.
		APTR	bmi_ColorMap	; Pointer to an Amiga colormap.
		APTR	bmi_RangeInfo	; Pointer to RangeInfos.
		UWORD	bmi_Width	; Dimensions of the picture.
		UWORD	bmi_Height
		UBYTE	bmi_Depth	; Number of bitplanes.
		UBYTE	bmi_Flags	; See below.
		UWORD	bmi_Modes	; View modes (HIRES, LACE, etc.)
		UBYTE	bmi_NumColors	; Number of colors.
		UBYTE	bmi_NumRanges	; Number of RangeInfos.
		UBYTE	bmi_TransparentColor	; See notes above.
		UBYTE	bmi_pad1	; Reserved for future use.
		ULONG	bmi_pad2
	LABEL	bmi_SIZEOF

*\
* BMInfo Flags.
*/
		BITDEF	BMI,HAS_COLORS,0	; BMInfo has a colormap.
		BITDEF	BMI,HAS_MASK,1		; Bitmap has mask plane.
		BITDEF	BMI,HAS_RANGES,2	; BMInfo has RangeInfos.
		BITDEF	BMI,TRANSPARENT_COLOR,3	; See notes above.


*\
* Notes on RangeInfo:
*
* rgi_Size:
*	Contains the total size of the RangeInfo structure.  If there is an
* array of RangeInfos, this value may be used as an offset from the current
* RangeInfo to the next one in the array.
*
* rgi_CArray[]:
*	It contains color table indicies.  It specifies the order in which
* colors should be rotated through the colormap.  For example, if rgi_CArray
* were to contain 1,2,4, you would cycle register 1 into register 2,
* register 2 into register 4, and register 4 into register 1.
*/
	STRUCTURE RangeInfo,0
		UWORD	rgi_Size	; See notes above.
		UBYTE	rgi_Low		; Start at rgi_CArray[rgi_Low]
		UBYTE	rgi_High	; and end at rgi_CArray[rgi_High]
		BYTE	rgi_Dir		; -1:Left, 0:Off, 1: Right
		UBYTE	rgi_Flags	; Flags (none defined as of yet).
		UWORD	rgi_Seconds	; Time between each cycle.
		ULONG	rgi_MicroSeconds
		UWORD	rgi_SecondsLeft	; Countdown variables.
		ULONG	rgi_MicroLeft	; Both modified by CycleRanges().
		ULONG	rgi_reserved
		STRUCT	rgi_CArray,32	; See notes above.
	LABEL	rgi_SIZEOF


	STRUCTURE SuperView,v_SIZEOF	; sv_View
	 	STRUCT	sv_ViewPort,vp_SIZEOF
		STRUCT	sv_RasInfo,ri_SIZEOF
		LONG	sv_Flags
	LABEL	sv_SIZEOF

*\
* SuperView Flags.
*/
	BITDEF	SV,ALLOCATED,1	; This structure created by CreateView().


	 ENDC
