
/****************************************************************************
*   Function:    int sockp(long d)                                          *
*   Operation:   to pause for the specified number of milliseconds          *
*   Returns:     (none)                                                     *
*   Parameters:  d, duration in milliseconds, long data type                *
****************************************************************************/

#include "socko.h"

#include <stdio.h>

#ifdef UNIX
# include <sys/types.h>
#else
# include <tklib.h>
#endif

#ifdef SYSV
#ifdef SEQ
# include <time.h>
#else
# include <sys/time.h>
#endif
#else
# include <sys/timeb.h>
#endif

void sockp(d)
  long d;
{
#ifdef SYSV
  struct tm *itimer;
  time_t t;
  long t1, t2;

  t = time(NULL);
  itimer = localtime(&t);
  t1 = itimer->tm_sec * 1000;
  t2 = itimer->tm_sec * 1000 + d;

  while (t1 < t2) {
    t = time(NULL);
    itimer = localtime(&t);
    t1 = itimer->tm_sec * 1000;
  }
#else
  struct timeb tstruct;
  long t1, t2;

  ftime(&tstruct);
  t1 = tstruct.time * 1000 + tstruct.millitm;
  t2 = t1;

  while (t1 + d > t2) {
    ftime(&tstruct);
    t2 = tstruct.time * 1000 + tstruct.millitm;
  }
#endif
}
