        PAGE    60,132
NAME    HDSNIFF
        TITLE   HDSniff.Com Version 2.6
Comment 

Tells you how your AT/XT hard disks were last low-level formatted.

Needs no parameters.
example of use:

HdSniff
or
HDSniff | More
or
HDSniff >Temp.Dat


This program is copyrighted, however it may be copied freely and
used for any purpose except military.

Here is a typical output for an XT with one 72 MB hard disk:

 HDSniff 2.6 ۲

(C) Copyright 1989, 1990, 1991, 1992 Roedy Green Canadian Mind Products
May be freely copied and used for non military purposes only.

Ferrets out the parameters that were used to perform
the last low-level hard disk format.

All numbers are both in decimal and [hex].

Low level formatting parameters for DISK 0   [0=C: 1=D:]

XT style disk controller presumed

1024 [400] / 918 [396] = Number of cylinders (per drive parms/per drive table)
8 [8] / 15 [F] = Number of heads (per drive parms/per drive table)
918 [396] = Starting cylinder for reduced write current
918 [396] = Starting cylinder for write precompensation
7 [7] = Maximum bits of error burst to attempt to correct (usually 7 to 11)
2 [2] = Step control byte
  (bit 7 = disable retries; bit 6 = disable ECC retries)
  (bits 2..0 = seek step PULSE rate, faster than track-to-track seek rate)
  (approx 12 s for modern buffered seeks, 3 ms for older unbuffered.)
  Brand      Debug Init Step byte code interpreted as step pulse rate
         
  Adaptec    g=c800:ccc 3=13 s, 2=30 s, 5=70 s, 4=200 s, 0=3 ms
  DTC5150CRH g=c800:5   2=12 s, 5=70 s, 4=200 s, 0,1,6,7=3 ms
  DTC5150XL  g=c800:5   0=5,10,20,30,40,50,60,70 s (cannot tell which!)
  IBM/Xebec             5=70 s, 4=200 s, 0,6,7=3 ms
  Omti       g=c800:6   1=10 s, 2=25 s, 3=40 s, 5=70 s, 4=200 s,
                        0,6,7=3 ms
  WD-old     g=c800:5   5=70 s, 4=200 s, 0,6,7=3 ms
  WD1002-WX1 g=c800:5   3,7=10.5 s, 2=22.5 s, 6=28.5 s, 1=46.5 s,
                        5=70.5 s, 4=202.5 s, 0=3.1 ms
  WD1002-27X g=c800:5   3,7=8 s, 1,2,4,5,6=24 s, 0=3 ms
  WD10025WX2 g=c800:5   3,7=18 s, 6=30 s, 1=45 s, 2=60 s, 5=75 s,
                        4=210 s, 0=3ms
  WD1004-WX1 g=c800:5   3,7=12 s, 6=27 s, 1=51 s, 2=63 s, 5=75 s,
                        4=207 s, 0=3 ms
  WD1004-27X g=c800:5   3,7=8 s, 1,2,4,5,6=24 s, 0=3 ms
  WD1004A27X g=c800:5   3,7=11 s, 1,2,4,5,6=24 s, 0=3.3 ms
  WD-XT-GEN1 g=c800:5   3,7=18 s, 6=30 s, 1=45 s, 2=60 s, 5=75 s,
                        4=210 s, 0=3ms
  WD-XT-GEN2 g=c800:5   3,7=18 s, 6=30 s, 1=45 s, 2=60 s, 5=75 s,
                        4=210 s, 0=3ms

4 [4] = Standard timeout value
25 [19] = Formatting timeout value
10 [A] = Disk check timeout value
17 [11] / 0 [0] = sectors per track (per drive parms/per drive table)
   (usually 17 for MFM, 26 for RLL, 36 for ESDI)

When information gleaned from get-drive-parameters
(ROM BIOS INT 13 function 08) conflicts with that gleaned from
get-drive-table (INT 41/46), trust get-drive-parameters.

See HDSNIFF.TXT for information on interpreting these results.

To see everything before it scrolls off the screen try:
  HDSniff | MORE
or
  HDSniff >LPT1:
or
  HDSniff >Temp.Dat

Purpose
=======

HDSniff will tell you the parameters that were used the last
time your hard disk was low-level formatted.  It displays
information from hard disk BIOS INT 13 function 08 get drive
parameters and from the INT 41/46 get drive table.  This can be
useful if you need to reformat your hard disk, or if you want to
ensure the formatting was done correctly.

The following parameters are often specified incorrectly during
low level format and result is flaky operation.

- Starting cylinder for reduced write current.
- Starting cylinder for write precompensation.
- Step control byte seek step PULSE rate, faster than
  track-to-track seek rate, ranging from 12 s for modern
  buffered seeks to 3 ms for older unbuffered seeks.

Interpreting HDNSNIFF Results
=============================

From the drive manufacturer you must determine the number of
cylinders, heads, starting reduced write cylinder and write
precomp cylinder.  Many BBS's also post lists of such information.
If the cylinders and heads are incorrect, you are wasting part
of your disk.  If the RWC and WP are incorrect you might expect
unreliable operation.

The ECC burst length should be a number between 5 and 11.
Setting it smaller is more conservative.  ECC will not attempt
to correct serious errors without telling you.  When ECC tries
to correct serious errors it does not always succeed, but it
lets you carry on without notice.  Setting the ECC burst length
larger allows you to carry on and recover from serious errors,
though you never hear about them unless you use HDTest.

If the step pulse rate is set too fast (lower number) you can
expect slower response due to corrected seek errors.  If the
pulse rate is too slow (higher number) you can expect slower
response due to the disk waiting needlessly long for pulses.
Sometimes there can also be seek errors.

Most AT controllers use 35 s fixed by the motherboard BIOS.
Ontrack offer a utility to override this.

It is hard to get information about the optimal pulse rates for
disk drives.  As rule of thumb try 3 ms for very old drives with
unbuffered seeks, 30 s for 20 MB disks, and 18 s for 30 to 40
MB disks, and 12 s for premium voice coil drives.

If any parameters are incorrect, you must back up everything
twice, redo the low level format, the FDISK, the FORMAT C:/S/V
and restore your data.

HDSNIFF currently cannot tell you the interleave.  Use Gibson
SpinRite to determine the optimum interleave and correct it.

Caveats
=======

Information about the size of a disk is indirectly recorded in
four separate places:

1. the drive table accessed via int 41/46
2. BIOS via int 13 ah=08
3. the partition table in the mini partition-selector boot on track 0
4. the BPB in the boot on track 0 of the DOS partition

Unhappily these do not all necessarily agree.
HDSniff will tell you about 1 and 2.
FDisk will tell you about 3.
ChkDsk will tell you about 4.
I have found 2 to be the most reliable, and 1 the least.

Some controllers fail to record the RWC (Reduced Write current
Cylinder) and WPC (Write Precompensation Cylinder) in the drive
table.  If you plan to reformat your disk, get the proper values
from the disk manufacturer or from tables in OnTrack software or
from tables posted on BIX.

Why Copyright?
==============

In the past all CMP software was public domain.  Now we are
releasing only copyrighted software.  We did this because
Rockwell International (a major American defense contractor)
asked my permission to use my public domain RESTORE program to
distribute their software.  I refused to bend my no military use
rule.  They told me they were going to continue using it anyway.
I found out legally I had no way to stop them because we did not
display a copyright notice.

If there is any doubt whatsoever if your use of HDSniff
constitutes military use, you must get clearance with Canadian
Mind Products.

Future possible enhancements include:
=====================================

 0. display the AT drive type index.
 1. calculate the current interleave and suggest the optimum.
 2. display the partition sizes.
 3. display the cluster sizes of each partition.
 4. display other partition stats such as free space,
    number of directories, location of interesting tables.
 5. Determine the DOS version in MSDOS.SYS and Command.com


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.0 Written 1988 April 6.

Version 1.1
  - added note that seek step pulse rate 2 is 30 ms

Version 1.2 1988 November 14
  - added per int 13 for cyls and heads
  - Determine AT vs XT then trim the display.
  - added more explanation of pulse rate

Version 1.3 1989 March 31
  - new version handles 80386 accelerator in XT style machine
    with XT style disk controller.
    Now makes XT AT determination based on ECC length.
  - added Western digital XT-GEN controller documentation.
  - reordered step list by speed.
  - changed landing zone usual message.

Version 1.4 1989 April 6
   - added further step pulse info for WD controllers
   - info on interpreting results embedded in source code.

Version 1.5 1989 May 4
   - added Xebec controller infor.

Version 1.6 1989 June 19
   - added info on sources of info and which can be trusted
   - fixed bug in HaveXT HaveAT comment

Version 1.7 1989 July 27
   - suppress the discrepancy comment when there is no discrepancy.

Version 1.8 1989 Sept 26
   - acknowledge ESDI drives

Version 1.9 1990 May 15
   - flashier banner
   - new address
   - added decoding of several additional WD controllers.
   - added explanation of HDSniff | MORE to output.

Version 2.0 1990 Sep 12
   - added WD1002A-27X to step pulse rate list
   - added DTC5150XL and DTC5150CRH

Version 2.1 1991 April 4
   - fix bug that gave wrong results on second disk.
     DI register was not properly preserved.
   - bug discovered by James Cox, JaCoRa on BIX.

Version 2.2 1991 April 6
   - fix bug that some Phoenix bioses trash DI on int 13 function 08

Version 2.3 1993 June 7
   - fix bug.  D: drive table was using int 41 instead of 46 and
     thus getting the wrong number.s
   - embed the new address and phone number.

Version 2.4 1994 August 7
   - D: problems fixed yet again.  Presume that first entry of int 46
     gives D:

Version 2.5 1996 October 25
- embed POB 707 Quathiaski Cove address


Version 2.6 1998 November 8
- embed Barker address

 ; end of comment

;===========================

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;============================

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;============================
;       register conventions:
;       preserved across calls DS: CS: ES: SS: CX SI DI
;       trashed across calls AX BX DX
;============================

DriveTab Struc                  ; Drive Table accessible Via
                                ; BIOS int 41H for C: and 46H for D:
        Max_Cyl         dw ?    ; Max number of cylinders
        Max_Heads       db ?    ; Max number of heads
        Red_Write_Cyl   dw ?    ; starting reduced write cylinder
        Precomp_Cyl     dw ?    ; starting write precompensation
        Ecc_Burst       db ?    ; max ECC burst length (bits)
        Step_Control    db ?
        Std_TimeOut     db ?
        Fmt_TimeOut     db ?
        Chk_TimeOut     db ?
        Land_Zone       dw ?
        Sects_Per_Track db ?
        reserved        db ?    ; 1 byte reserved
DriveTab Ends

;============================

code    segment para
        assume  cs:code,ds:code
        org     100h

HDSniff proc    far

start:
        lea     dx,Welcome$
        Call    Say
        mov     di,0080h        ; drive no. for c:
        mov     dx,di           ; get drv parms for disk c:
        mov     ax,0800h        ; ah 08 = get disk parameters
        int     13h             ; into CX/DX

        mov     cl,dl           ; put drv count in cx
        xor     ch,ch           ; zero high order byte of drive count
        jcxz    quit            ; zero drives--exit procedure
        xor     DI,DI           ; loop with DI=0,1,2...
sloop:                          ; loop once for each drive c: d:...
        call    Sniff1
        inc     DI              ; inc to next drive  D:
        loop    sloop

quit:
        test    byte ptr IsConflict,-1  ; Was there a conflict?
        jz      NoConflict      ; no bypass message
        lea     dx,Conflict$
        Call    Say
NoConflict:
        lea     dx,Interpret$   ; note on how to interpret results
        Call    Say
        mov     ax,4c00h        ; exit to DOS
        int     21h

;============

Say     Proc
;       on entry DX points to a string to display terminated by $
;       displays string
        Push    AX
        mov     ah,9
        Int     21h
        Pop     AX
        ret
Say     EndP

;============

SayNum PROC Near
;       on entry displays number in AX in Decimal and [hex]
        PUSH    AX
        Call    SayDec
        lea     dx,leftbr$
        Call    Say
        POP     AX
        Call    SayHex
        lea     dx,rightbr$
        Call    Say
        ret
SayNum  EndP

;============

SayDec PROC     NEAR
;       call with number in range 0..65535 in AX
;       converts it to ASCII and displays it on the screen
;       If it is 0 shows as 0.
;       leading 0's are suppressed.
;       field is exactly wide enough to hold the number.
;       No leading or trailing spaces.  DISPLAYED IN DECIMAL
        PUSH    DI              ; preserve DI
        MOV     BX,10d
        MOV     DI,5            ; work right to left building digits at PAD
SayDecLoop:
        DEC     DI
        XOR     DX,DX           ; DX:AX / 10
        DIV     BX              ; AX=quot DX=remdr
        ADD     DL,'0'          ; convert digit to ASCII
        MOV     PAD[DI],DL
        OR      AX,AX
        JNZ     SayDecLoop
SayDecDone:
;       Number is ready
        lea     dx,pad[di]
        call    Say             ; terminated by $
        POP     DI
        RET
SayDec  ENDP

;========================

SayHex PROC     NEAR
;       call with number in range 0..65535 in AX
;       converts it to ASCII and displays it on the screen
;       If it is 0 shows as 0.
;       leading 0's are suppressed.
;       field is exactly wide enough to hold the number.
;       No leading or trailing spaces.  DISPLAYED IN HEX
;       This is not the fastest way of doing HEX, but it was
;       quickest to code given I had already written SayDec.
        push    di              ; preserve DI
        mov     bx,10h
        mov     di,5            ; work right to left buil       ding digits at PAD
SayHexLoop:
        dec     di
        xor     dx,dx           ; DX:AX / 10h
        div     bx              ; AX=quot DX=remdr
        cmp     dl,9
        JG      HexChar
        add     dl,'0'          ; convert digit to ASCII
        JMP     StoreChar
HexChar:
        add     dl,'A'-0ah      ; convert A..H
StoreChar:
        mov     pad[DI],DL
        OR      AX,AX
        JNZ     SayHexLoop
SayHexDone:
;       Number is ready
        lea     dx,pad[di]
        call    Say             ; terminated by $
        pop     di
        ret
SayHex  ENDP

;=================================

Sniff_Max_Cyl PROC Near
;       Displays Total Cyls on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table
        mov     dx,0080h        ; get total cyls from BIOS
        add     dx,di
        mov     ax,0800h
        push    di              ; Some Phoenix BIOSes return ES:di
        int     13h
        pop     di
        xor     ax,ax
        mov     al,cl
        shl     ax,1
        shl     ax,1
        mov     al,ch
        inc     ax              ; include landing zone
        inc     ax              ; max cyl # -> total cyls
        push    ax              ; Save Cyl count per BIOS
        Call    SayNum
        mov     ax,ES:[SI].Max_Cyl ; get total cyls from drive table
        pop     bx              ; total cyls per BIOS
        cmp     ax,bx
        je      Cyls_Agree
        mov     byte ptr IsConflict,-1  ; note there was a conflict
        lea     dx,Slash$       ; display both versions of truth
        Call    Say
        Call    SayNum
        lea     dx,Max_Cyl$
        Call    Say
        lea     dx,Disagree$
        Call    Say
        Ret
Cyls_Agree:
        lea     dx,Max_Cyl$
        Call    Say
        lea     dx,Agree$
        Call    Say
        Ret
Sniff_Max_Cyl ENDP

;=================================

Sniff_Max_Heads PROC Near
;       Displays Total Heads on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table
        mov     dx,0080h        ; get total heads from BIOS
        add     dx,di
        mov     ax,0800h
        push    di              ; Some Phoenix BIOSes return ES:di
        int     13h
        pop     di
        xor     ax,ax
        mov     al,dh
        inc     ax              ; max head # -> total head
        push    ax              ; Save head count per BIOS
        Call    SayNum
        mov     al,ES:[SI].Max_Heads
        xor     ah,ah
        pop     bx              ; total heads per BIOS
        cmp     ax,bx
        je      heads_Agree
        lea     dx,Slash$
        Call    Say
        Call    SayNum
        Lea     dx,Max_Heads$
        Call    Say
        lea     dx,Disagree$
        Call    Say
        Ret
Heads_Agree:
        Lea     dx,Max_Heads$
        Call    Say
        lea     dx,Agree$
        Call    Say
        Ret
Sniff_Max_Heads ENDP

;=================================

Sniff_Red_Write_Cyl PROC Near
;       Displays reduced write cyl on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table

        mov     ax,ES:[SI].Red_Write_Cyl
        Call    SayNum
        lea     dx,Red_Write_Cyl$
        Call    Say
        Ret
Sniff_Red_Write_Cyl ENDP

;=================================

Sniff_PreComp_Cyl PROC Near
;       Displays Precompensation Cyl on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table
        mov     ax,ES:[SI].Precomp_Cyl
        Call    SayNum
        lea     dx,Precomp_Cyl$
        Call    Say
        Ret
Sniff_PreComp_Cyl ENDP

;=================================

Sniff_Ecc_Burst PROC Near
;       Displays ECC burst length on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table

        mov     al,ES:[SI].Ecc_Burst
        xor     ah,ah
        Call    SayNum
        lea     dx,Ecc_Burst$
        Call    Say
        Ret
Sniff_Ecc_Burst ENDP

;=================================

Sniff_Step_Control_AT PROC Near
;       Displays AT Step Control Byte on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table

        mov     al,ES:[SI].Step_Control
        xor     ah,ah
        Call    SayNum
        lea     dx,Step_Control_AT$
        Call    Say
        Ret
Sniff_Step_Control_AT ENDP

;=================================

Sniff_Step_Control_XT PROC Near
;       Displays XT Step Control Byte on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table

        mov     al,ES:[SI].Step_Control
        xor     ah,ah
        Call    SayNum
        lea     dx,Step_Control_XT$
        Call    Say
        Ret
Sniff_Step_Control_XT ENDP

;=================================

Sniff_TimeOut PROC Near
;       Displays the three Timeout Values on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table

        mov     al,ES:[SI].Std_TimeOut
        xor     ah,ah
        Call    SayNum
        lea     dx,Std_TimeOut$
        Call    Say

        mov     al,ES:[SI].Fmt_TimeOut
        xor     ah,ah
        Call    SayNum
        lea     dx,Fmt_TimeOut$
        Call    Say

        mov     al,ES:[SI].Chk_TimeOut
        xor     ah,ah
        Call    SayNum
        lea     dx,Chk_TimeOut$
        Call    Say
        Ret
Sniff_TimeOut ENDP

;=================================

Sniff_Land_Zone PROC Near
;       Displays Landing Zone on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table

        mov     ax,ES:[SI].Land_Zone
        Call    SayNum
        lea     dx,Land_Zone$
        Call    Say
        Ret
Sniff_Land_Zone ENDP

;=================================

Sniff_Sects_Per_Track PROC Near
;       Displays sectors per track on one Drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table
        mov     dx,0080h        ; get sectors from BIOS
        add     dx,di
        mov     ax,0800h
        push    di              ; Some Phoenix BIOSes return ES:di
        int     13h
        pop     di
        mov     al,cl
        and     ax,111111b      ; mask off cyl number
        push    ax              ; Save sectors per BIOS
        Call    SayNum
        mov     al,ES:[SI].Sects_Per_Track
        xor     ah,ah
        pop     bx              ; total sectors per BIOS
        cmp     ax,bx
        je      Sectors_Agree
        lea     dx,Slash$
        Call    Say
        Call    SayNum
        Lea     dx,Sects_Per_Track$
        Call    Say
        lea     dx,Disagree$
        Call    Say
        lea     dx,Expect_Sectors$
        Call    Say
        Ret
Sectors_Agree:
        Lea     dx,Sects_Per_Track$
        Call    Say
        lea     dx,Agree$
        Call    Say
        lea     dx,Expect_Sectors$
        Call    Say
        Ret
Sniff_Sects_Per_Track ENDP

;=================================

Point1  PROC    Near
;       prints out drive table for 1 drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Compute ES:SI so that it points to the drive table
;       Initially Int 41 and 46 return a list of up to 15 types.
;       But BIOS init corrects it to point to entry we are using.

        push    di
        Lea     DX,Disk_no$     ; describe which disk 0=C:
        Call    Say
        mov     ax,di           ; disk number decimal only
        Call    SayDec
        Lea     DX,Disk_noC$
        Call    Say

        mov     al,41h          ; C: use 41h, D: use 46h
        cmp     di,1
        jne     UseCtable
        mov     al,46h
UseCtable:
        mov     ah,35h          ; get int 41/46 pointer to drive table
        int     21h             ; ES:BX points to drive table
                                ; get drive table info
        mov     si,bx           ; save address in SI so wont get
                                ; trashed
        pop     di
        Ret

Point1  ENDP

;=================================

Discrim PROC    Near
;       Decide if have XT or AT type controller, XT=1 or AT=0
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table
        mov     al,ES:[SI].Ecc_Burst
        or      al,al
        Ret
Discrim ENDP

;=================================

Sniff1  PROC    Near
;       prints out drive table for 1 drive
;       DI indexes drive wanted usually 0 = C: 1= D:
;       Sacrosanct ES:SI points to the drive table
        PUSH    CX
                                ; WE MUST PRESERVE DI throughout!
        Call    Point1          ; get pointer to drive table
        Call    Discrim         ; discriminate AT vs XT via chip
        JNZ     HaveXT

HaveAT:                         ; We have an AT controller
        lea     dx,AT$
        call    Say
        Call    Sniff_Max_Cyl
        Call    Sniff_Max_Heads
        Call    Sniff_Precomp_Cyl
        Call    Sniff_Step_Control_AT
        Call    Sniff_Land_Zone
        Call    Sniff_Sects_Per_Track
        POP     CX
        RET

HaveXT:                         ; We have an XT controller
        lea     dx,XT$
        call    Say
        Call    Sniff_Max_Cyl
        Call    Sniff_Max_Heads
        Call    Sniff_Red_Write_Cyl
        Call    Sniff_Precomp_Cyl
        Call    Sniff_Ecc_Burst
        Call    Sniff_Step_Control_XT
        Call    Sniff_TimeOut
        Call    Sniff_Sects_Per_Track
        POP     CX
        RET

Sniff1  ENDP
;======================================
        EVEN
PAD     DB      "00000$"        ; where numeric output built by SayNum
;======================================
IsConflict DB   0               ; 0 = no conflict -1 = conflict
                                ; between drive table and BIOS
;======================================
Welcome$ Label Byte
        CR
        DB      ' HDSniff 2.6 ۲'
        CR
        CR
        db      '(C) Copyright 1989-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        db      'May be freely copied and used for non military purposes only.'
        CR
        CR
        db      'Ferrets out the parameters that were used to perform'
        CR
        db      'the last low-level hard disk format.'
        CR
        CR
        db      'All numbers are both in decimal and [hex].'
        EOS

AT$     label Byte
        CR
        db 'AT style disk controller presumed'
        CR
        EOS

XT$     label Byte
        CR
        db 'XT style disk controller presumed'
        CR
        EOS

Disk_No$ Label Byte
        CR
        db 'Low level formatting parameters for DISK $'

Disk_NoC$ Label Byte
        db '   [0=C: 1=D:]'
        EOS

leftbr$ label Byte
        db ' [$'

rightbr$ label Byte
        db ']$'

Slash$ label Byte
        db ' / $'

Max_Cyl$ Label Byte
        db ' = Number of cylinders$'

Max_Heads$ label Byte
        db ' = Number of heads$'

Red_Write_Cyl$ label Byte
        db ' = Starting cylinder for reduced write current '
        EOS
        ; only applies to XT

Precomp_Cyl$ label Byte
        db ' = Starting cylinder for write precompensation '
        EOS

Ecc_Burst$ label Byte
        db ' = Maximum bits of error burst to attempt to correct'
        db ' (usually 7 to 11)'
        EOS
        ; only applies to XT

Step_Control_AT$ label Byte
        db ' = Step control byte'
        CR
        db '  (bit 7 = disable retries; bit 6 = disable ECC retries)'
        CR
        db '  (bit 3 = more than 8 heads)'
        EOS

Step_Control_XT$ label Byte
        db ' = Step control byte'
        CR
        db '  (bit 7 = disable retries; bit 6 = disable ECC retries)'
        CR
        db '  (bits 2..0 = seek step PULSE rate, faster than track-to-track seek rate)'
        CR
        db '  (approx 12 s for modern buffered seeks, 3 ms for older unbuffered.)'
        CR
        db '  Brand      Debug Init Step byte code interpreted as step pulse rate'
        CR
        db '         '
        CR
        db '  Adaptec    g=c800:ccc 3=13 s, 2=30 s, 5=70 s, 4=200 s, 0=3 ms'
        CR
        db '  DTC5150CRH g=c800:5   2=12 s, 5=70 s, 4=200 s, 0,1,6,7=3 ms'
        CR
        db '  DTC5150XL  g=c800:5   0=5,10,20,30,40,50,60,70 s (cannot tell which!)'
        CR
        db '  IBM/Xebec             5=70 s, 4=200 s, 0,6,7=3 ms'
        CR
        db '  Omti       g=c800:6   1=10 s, 2=25 s, 3=40 s, 5=70 s, 4=200 s,'
        CR
        db '                        0,6,7=3 ms'
        CR
        db '  WD-old     g=c800:5   5=70 s, 4=200 s, 0,6,7=3 ms'
        CR
        db '  WD1002-WX1 g=c800:5   3,7=10.5 s, 2=22.5 s, 6=28.5 s, 1=46.5 s,'
        CR
        DB '                        5=70.5 s, 4=202.5 s, 0=3.1 ms'
        CR
        db '  WD10025WX2 g=c800:5   3,7=18 s, 6=30 s, 1=45 s, 2=60 s, 5=75 s,'
        CR
        db '                        4=210 s, 0=3ms'
        CR
        db '  WD1002-27X g=c800:5   3,7=8 s, 1,2,4,5,6=24 s, 0=3 ms'
        CR
        db '  WD1004-WX1 g=c800:5   3,7=12 s, 6=27 s, 1=51 s, 2=63 s, 5=75 s,'
        CR
        DB '                        4=207 s, 0=3 ms'
        CR
        db '  WD1004-27X g=c800:5   3,7=8 s, 1,2,4,5,6=24 s, 0=3 ms'
        CR
        db '  WD1004A27X g=c800:5   3,7=11 s, 1,2,4,5,6=24 s, 0=3.3 ms'
        CR
        db '  WD-XT-GEN1 g=c800:5   3,7=18 s, 6=30 s, 1=45 s, 2=60 s, 5=75 s,'
        CR
        db '                        4=210 s, 0=3ms'
        CR
        db '  WD-XT-GEN2 g=c800:5   3,7=18 s, 6=30 s, 1=45 s, 2=60 s, 5=75 s,'
        CR
        db '                        4=210 s, 0=3ms'
        CR
        EOS

; Timeouts only apply to XT

Std_TimeOut$ label byte
        db ' = Standard timeout value'
        EOS

Fmt_TimeOut$ label byte
        db ' = Formatting timeout value'
        EOS

Chk_TimeOut$ label byte
        db ' = Disk check timeout value'
        EOS

Land_Zone$ label byte
        db ' = landing zone (usually the last Cylinder+1)'
        EOS
        ; Drive table usually 0 in XT

Sects_Per_Track$ label byte
        db ' = sectors per track$'
        ; Drive table has 0 in XT, but BIOS still works

Expect_Sectors$ label byte
        db '   (usually 17 for MFM, 26 for RLL, 36 for ESDI)'
        EOS

Conflict$ label byte
        CR
        db 'When information gleaned from get-drive-parameters'
        CR
        db '(ROM BIOS INT 13 function 08) conflicts with that gleaned from'
        CR
        db 'get-drive-table (INT 41/46), trust get-drive-parameters.'
        EOS

Agree$ label byte
        EOS

Disagree$ label byte
        db ' (per drive parms/per drive table)'
        EOS

Interpret$ label byte
        CR
        db 'See HDSNIFF.TXT for information on interpreting these results.'
        CR
        CR
        db 'To see everything before it scrolls off the screen try:'
        CR
        db '  HDSniff | MORE'
        CR
        db 'or'
        CR
        db '  HDSniff >LPT1:'
        CR
        db 'or'
        CR
        db '  HDSniff >Temp.Dat'
        EOS

HDSniff endp


code    ends
        end     start
