/**[f******************************************************************
* control.c -
*
* Copyright (C) 1988,1989 Aldus Corporation
* Copyright (C) 1988-1990 Microsoft Corporation.
* Copyright (C) 1989,1990, 1991 Hewlett-Packard Company.
* All rights reserved.  Company confidential.
*
**f]*****************************************************************/
  
/*$Header: control.c,v 3.890 92/02/06 16:11:33 dtk FREEZE $*/
  
/*$Log:	control.c,v $
 * Revision 3.890  92/02/06  16:11:33  16:11:33  dtk (Doug Kaltenecker)
 * Win3.1 Freeze
 * 
 * Revision 3.879  92/02/04  16:40:45  16:40:45  daniels (Susan Daniels)
 * Fix #807:  Typo Conditional compile based on Win31 instead of WIN31.
 * 
 * Revision 3.878  92/01/23  11:51:57  11:51:57  daniels (Susan Daniels)
 * Rest of fix for Bug #789:  add code to initialize epNband to 0 in STARTDOC.
 * 
 * Revision 3.877  92/01/21  11:08:22  11:08:22  daniels (Susan Daniels)
 * Fix Bug #789:  Still some funny stuff to check out.
 * 
 * Revision 3.876  92/01/10  11:00:45  11:00:45  jsmart (Jerry Smart)
 * Bug fix #765   WordPerfect graphics had garbage after first page.
 * reset TEXTBAND to FALSE after last band   -  jcs
 * 
 * Revision 3.875  91/12/18  13:51:29  13:51:29  daniels (Susan Daniels)
 * Change parameter to SetEnvironment for Win31 -- use device not port.
 * 
 * Revision 3.874  91/12/05  11:14:16  11:14:16  daniels (Susan Daniels)
 * Fix BUG #759: SETCOPYCOUNT escape only setting one byte.  Changed type
 * casts so the entire int of input data is copied into the output data.
 * 
 * Revision 3.873  91/12/03  08:59:45  08:59:45  daniels (Susan Daniels)
 * Saved wrong stuff for fix for BUG #744.  This is the real stuff.
 * 
 * Revision 3.872  91/12/02  16:43:43  16:43:43  dtk (Doug Kaltenecker)
 * Changed the ifdef TT build variables to ifdef WIN31.
 * 
 * Revision 3.871  91/12/02  16:13:48  16:13:48  daniels (Susan Daniels)
 * Bug #744: FaceLift passing bad lpInData to RESETDEVICE.
 * 
 * Revision 3.870  91/11/08  11:43:16  11:43:16  dtk (Doug Kaltenecker)
 * 3.1 Release Candidate 1
 * 
 * Revision 3.865  91/11/01  13:51:14  13:51:14  dtk (Doug Kaltenecker)
 * Beta release for Windows 3.1
 * 
 * Revision 3.864  91/11/01  13:23:18  13:23:18  daniels (Susan Daniels)
 * Fix reopened BUG #529: NEXTBAND returning 0 instead of error code.
 * Changed AbortJob().
 * 
 * Revision 3.863  91/10/28  14:09:39  14:09:39  dtk (Doug Kaltenecker)
 * added #ifdef WIN31 around RESETDEVICE 
 * 
 * Revision 3.862  91/10/25  13:46:35  13:46:35  dtk (Doug Kaltenecker)
 * BETA
 * 
 * Revision 3.860  91/10/23  09:48:00  09:48:00  dtk (Doug Kaltenecker)
 * WinWird Release
 * 
 * Revision 3.853  91/10/22  16:50:16  16:50:16  daniels (Susan Daniels)
 * Complying with MS request to change ENUMPAPERBINS and GETSETPAPERBINS to
 * 3.77 functionality for backwards compatibility.  This removes the fixes
 * for Bugs #197 and #562, except the loop termination fix for 197 remains.
 * 
 * Revision 3.852  91/10/09  14:59:03  14:59:03  dtk (Doug Kaltenecker)
 * BETA
 * 
 * Revision 3.850  91/10/04  16:49:09  16:49:09  dtk (Doug Kaltenecker)
 * WINWORD RELEASE CANDIDATE
 * 
 * Revision 3.840  91/09/28  14:16:34  14:16:34  dtk (Doug Kaltenecker)
 * RELEASE CANDIDATE 3 FOR WINWORD
 * 
 * Revision 3.831  91/09/27  16:53:04  16:53:04  daniels (Susan Daniels)
 * Fix Bug #671:  needed to add line to set epPgChng in GETSETPAPERBINS
 * so that mixed bin printing still works in Win 30.
 * 
 * Revision 3.830  91/09/18  16:32:50  16:32:50  dtk (Doug Kaltenecker)
 * RELEASE
 * 
 * Revision 3.822  91/09/16  10:33:09  10:33:09  dtk (Doug Kaltenecker)
 * WINWORD RELEASE CANDIDATE 2 FOR WIN30.
 * 
 * Revision 3.821  91/09/12  13:19:29  13:19:29  dtk (Doug Kaltenecker)
 * *** empty log message ***
 * 
 * Revision 3.820  91/09/06  14:11:28  14:11:28  dtk (Doug Kaltenecker)
 * RELEASE CANDIDATE FOR WINWORD 2.0
 * 
 * Revision 3.815  91/09/05  09:40:40  09:40:40  daniels (Susan Daniels)
 * Use type casting to fix compiler warnings generated by fix for Bug #590.
 * 
 * Revision 3.814  91/09/04  16:22:54  16:22:54  dtk (Doug Kaltenecker)
 * Added build.h to include lists and put in the LPDOCINFO structure
 * from windows.h.
 * 
 * Revision 3.813  91/09/04  11:42:33  11:42:33  dtk (Doug Kaltenecker)
 * Put #ifdef TT around the freeing of the ttfsum and added build.h.
 * 
 * Revision 3.812  91/08/22  14:31:26  14:31:26  dtk (Doug Kaltenecker)
 * BETA
 * 
 * Revision 3.809  91/08/22  09:10:36  09:10:36  daniels (Susan Daniels)
 * Fix Bug #590: MS changes for STARTDOC escape for Win 31.
 * 
 * Revision 3.808  91/08/16  13:07:35  13:07:35  daniels (Susan Daniels)
 * Fix BUG 560: Eli printing too slow.  Send down escape sequences for
 * paper size and paper tray only on first page or when they change.
 * 
 * Revision 3.807  91/08/08  10:30:44  10:30:44  dtk (Doug Kaltenecker)
 * PREBETA3
 * 
 * Revision 3.805  91/08/06  09:16:32  09:16:32  dtk (Doug Kaltenecker)
 * Deallocted the ttfsum memory in initstartdoc.
 * 
 * Revision 3.804  91/08/02  15:44:32  15:44:32  dtk (Doug Kaltenecker)
 * Took out memory stuff in NEWFRAME and added FRAGMEM to memused 
 * in UnloadSofts to account for fragmented memory in printer.
 * 
 * Revision 3.803  91/08/01  17:22:13  17:22:13  daniels (Susan Daniels)
 * Fix bug #562:  GETSETPAPERBINS not setting bin.
 * 
 * Revision 3.802  91/07/22  12:53:35  12:53:35  oakeson (Ken Oakeson)
 * BETA
 * 
 * Revision 3.800  91/07/19  12:17:44  12:17:44  daniels (Susan Daniels)
 * RESETDEVICE:  no longer copy handle to font summary from old to new.
 * 
 * Revision 3.799  91/07/02  11:51:02  11:51:02  daniels (Susan Daniels)
 * Beta
 * 
 * Revision 3.797  91/06/28  15:52:17  15:52:17  stevec (Steve Claiborne)
 * Fixed bug #521 - where text was being clipped incorrectly in Excel and 
 * headers/footers weren't being printed.
 * 
 * Revision 3.796  91/06/26  11:25:21  11:25:21  stevec (Steve Claiborne)
 * BETA
 * 
 * Revision 3.791  91/06/26  11:03:06  11:03:06  daniels (Susan Daniels)
 * RESETDEVICE: save PageCount.
 * 
 * Revision 3.790  91/06/11  16:02:37  16:02:37  stevec (Steve Claiborne)
 * Freeze
 * 
 * Revision 3.786  91/06/11  15:43:13  15:43:13  dtk (Doug Kaltenecker)
 * Prettified files!
 * 
* Revision 3.785  91/05/22  14:56:20  14:56:20  stevec (Steve Claiborne)
* Beta version to MS
*
* Revision 3.780  91/05/15  15:56:28  15:56:28  stevec (Steve Claiborne)
* Beta
*
* Revision 3.778  91/05/15  14:52:01  14:52:01  stevec (Steve Claiborne)
* Fixed problem where the driver wouldn't print pcx files on second pg.
*
* Revision 3.777  91/05/15  14:41:57  14:41:57  daniels (Susan Daniels)
* Fix Bug #197.
*
* Revision 3.776  91/05/14  15:00:41  15:00:41  daniels (Susan Daniels)
* Fix Bug #197: ENUMPAPERBINS returning incorrect list.
*
* Revision 3.775  91/04/05  14:30:21  14:30:21  stevec (Steve Claiborne)
* Beta release to MS
*
* Revision 3.770  91/03/25  15:35:21  15:35:21  stevec (Steve Claiborne)
* maintance release
*
* Revision 3.760  91/03/12  07:52:02  07:52:02  stevec (Steve Claiborne)
* Maintance release
*
* Revision 3.756  91/03/06  11:05:01  11:05:01  stevec (Steve Claiborne)
* Fixed bug #148 - listed as a compiler bug.  This problem was fixed earlier,
* it just didn't get checked in.  The compiler does some weird things, so
* I put 3 calls into control.c that calls myWrite() with nothing to print.
* This seems to clear up the compiler bug???
*
* Revision 3.755  91/03/03  07:45:26  07:45:26  stevec (Steve Claiborne)
* March 3 Freeze
*
* Revision 3.721  91/02/11  19:10:10  19:10:10  daniels (Susan Daniels)
* Adding ELI
*
* Revision 3.720  91/02/11  09:14:44  09:14:44  stevec (Steve Claiborne)
* Aldus version
*
* Revision 3.711  91/02/08  16:24:30  16:24:30  stevec (Steve Claiborne)
* Added debuging
*
* Revision 3.710  91/02/04  15:47:04  15:47:04  stevec (Steve Claiborne)
* Aldus freeze
*
* Revision 3.701  91/02/04  12:34:25  12:34:25  oakeson (Ken Oakeson)
* Added SETCHARSET support
*
* Revision 3.700  91/01/19  08:59:45  08:59:45  stevec (Steve Claiborne)
* Release
*
* Revision 3.685  91/01/14  15:42:37  15:42:37  stevec (Steve Claiborne)
* Freeze
*
* Revision 3.682  91/01/14  14:58:25  14:58:25  stevec (Steve Claiborne)
* Changed call to ScaleWidths to use MasterUnits.  The previous version
* caused a divide by 0 error.   SJC
*
* Revision 3.681  91/01/14  10:16:58  10:16:58  stevec (Steve Claiborne)
* Updated the copy right stmt.
*
* Revision 3.680  91/01/10  16:16:03  16:16:03  stevec (Steve Claiborne)
* Freeze
*
* Revision 3.671  91/01/08  11:17:30  11:17:30  stevec (Steve Claiborne)
* Fixed bug #108.  Infinate loop occured while printing in real mode
* and in draft quality.   SJC
*
* Revision 3.670  90/12/14  14:53:29  14:53:29  stevec (Steve Claiborne)
* freeze for 12-14-90 ver. 3.670
*
* Revision 3.668  90/12/14  10:33:46  10:33:46  stevec (Steve Claiborne)
* Fixed bug #102 by calling clear_band in Nextband, band==0.  SJC
*
* Revision 3.667  90/12/14  09:10:43  09:10:43  stevec (Steve Claiborne)
* fixed bug 99 by NULLing hCharDL and freeing up the font summary struct.
* in InitStartDoc.  SJC
*
* Revision 3.666  90/12/12  11:28:22  11:28:22  stevec (Steve Claiborne)
* Moved quick exit routine in NextBand to default: case.  This fixes
* Bug #98.  SJC
*
* Revision 3.665  90/12/10  15:35:12  15:35:12  stevec (Steve Claiborne)
* Freeze
*
* Revision 3.662  90/12/10  14:42:26  14:42:26  jsmart ()
* Fixed bug #77 - COM10 only envelope that worked  jcs
*
* Revision 3.661  90/12/10  10:03:39  10:03:39  stevec (Steve Claiborne)
* Removed some unreferenced local variables.  SJC
*
* Revision 3.660  90/12/07  14:49:43  14:49:43  stevec (Steve Claiborne)
* Freeze 12-7-90
*
* Revision 3.651  90/11/30  12:17:04  12:17:04  stevec (Steve Claiborne)
* Fixed bug that printed 2nd copy of a document as all black.  SJC
*
* Revision 3.650  90/11/30  08:11:37  08:11:37  stevec (Steve Claiborne)
* Freeze 3.650, 11-30-90
*
* Revision 3.613  90/11/28  11:00:47  11:00:47  stevec (Steve Claiborne)
* Changed first band TEXT/GRAPHICS request in Bandinfo to FALSE for each
* to fix Paintbrush printing problem
*
* Revision 3.612  90/11/28  09:45:35  09:45:35  stevec (Steve Claiborne)
* Set ANYGRX in Bandinfo
*
* Revision 3.611  90/11/27  09:00:17  09:00:17  stevec (Steve Claiborne)
* Changed logic in allocate_mem to clear band only when a band has been
* allocated or when in real mode and no band has been declared yet!
* SJC - 11-27-90
*
* Revision 3.609  90/11/14  15:58:38  15:58:38  stevec (Steve Claiborne)
* Fixed bug #82 which enabled PM to use vectored fonts.  Also improved
* performance by reducing the calls to clear_band.  SJC
*
* Revision 3.608  90/11/09  11:29:51  11:29:51  stevec (Steve Claiborne)
* Modified file to print raster first, text last.  SJC
*
* Revision 3.607  90/10/25  17:02:34  17:02:34  oakeson (Ken Oakeson)
* Removed ifdefs for truetype code
*
* Revision 3.606  90/10/02  13:58:10  13:58:10  daniels (Susan Daniels)
* Fixed Bug #70: bugs in EnumPaperBins().
*
* Revision 3.605  90/09/27  09:57:37  09:57:37  daniels ()
* Corrected (tray = max) to (tray == max).
*
* Revision 3.604  90/09/13  16:20:51  16:20:51  daniels ()
* Fixed Bug #60:  Microsofts File-Print-Options paper feed
* button inactive when LJ IIID selected.  Fix in EnumPaperBins().
*
* Revision 3.603  90/09/13  09:09:44  09:09:44  root ()
* Cleaned up formatting problem.
*
* Revision 3.602  90/08/24  11:25:57  11:25:57  daniels ()
* Adding HP copyright statement
*
* Revision 3.601  90/08/14  15:24:19  15:24:19  oakeson (Ken Oakeson)
* Added TrueType support
*
* Revision 3.600  90/08/03  11:09:07  11:09:07  stevec (Steve Claiborne)
* This is the Aug. 3 release ver. 3.600
*
* Revision 3.550  90/07/27  11:30:04  11:30:04  root ()
* Experimental freeze 3.55
*
* Revision 3.541  90/07/27  08:14:16  08:14:16  oakeson ()
* Grab kerning and ext text metrics from resources too.
*
* Revision 3.540  90/07/25  12:33:38  12:33:38  stevec (Steve Claiborne)
* Experimental freeze 3.54
*
* Revision 3.523  90/07/21  10:34:37  10:34:37  stevec (Steve Claiborne)
* Removed PCL_* lock functions
* Added huge bitmap capabilities
*
* Revision 3.522  90/06/21  17:04:00  17:04:00  daniels ()
* Put duplexing back in with #ifdef DUPLEX
*
*/
  
/***************************************************************************/
/******************************   control.c   ******************************/
/*
*  Control: Driver ESCAPE functions.
*
*
* The following line was copied from the Microsoft driver for the Aug '90
* mini-release of the Boise driver. This code affects grayscale.
*
* 30 jan 90    clarkc  Set ANYGRX if not in 300 dpi.
*
* End of graysacle code addtion.
*
* 04 feb 92  SD     BUG #807:  ChangeEnvironment() - Changed conditional compile
*                              flag from Win31 to WIN31.
* 23 jan 92  SD     BUG #789:  STARTDOC needs to initialize epNband to 0.  After
*                              aborting a print job, sometimes epNband was not
*                              reset, causing NEXTBAND to execute the wrong
*                              case.
* 21 jan 92  SD     BUG #789:  AbortJob needs to set epDoc to zero;  Need to
*                              save the error code that is in epDoc before
*                              the call to AbortJob.  Control_II needs to 
*                              return the error.
* 6  dec 91  SD     BUG #759:  Typecast lpInData and lpOutData.
* 2  dec 91  SD     BUG #744:  Facelift RESETDEVICE bug.  Add check for valid
*                   lpInData.
* 1  nov 91  SD     BUG #529 reopened:  NEXTBAND returning 0 instead of
*                   error code.
* 22 oct 91  SD     BUG - MS request to return to 3.77 implementation of
*                   GETSETPAPERBINS and ENUMPAPERBINS  for backwards com-
*                   patibility for AmiPro and WinWord1.x mixed bins.  So,
*                   removed fixes for #197 and 562, except kept correct
*                   loop termination that was in #197.
* 27 aug 91  SD     BUG #671: Dual bin printing not  working in WinWord.
* 21 aug 91  SD     BUG #590:  Change STARTDOC per MS Win 31 changes.
* 14 aug 91  SD     BUG #560:  Paper size and source commands need to be
*                   monitored and only sent when necessary within a document.
*                   Sending on each page was killing IIISi throughput.
* 01 aug 91   SD    Bug #562:  Fixing #197 corrected list of strings.  Code
*                   to set new bin depended on old incorrect list.
* 17 jul 91   SD    Bug #125 (new #383):  Do not copy old value for epHFntSum;
*                   this value is obtained during Enable() so the new value is
*                   the one we want. Do copy ephDC, epMode, and epDoc.
*                   Don't bother to copy epCurTTFont, epNextTTFont, epLPFntSum,
*                   or epHWidths as these are reinitialized in NEXTBAND.
* 26 jun 91   SD    Added save epPageCount field in RESETDEVICE.
* 14 may 91   SD    Added RESETDEVICE: Note - Unable to test this!!! Bug #125.
* 06 may 91   SD    Fixed Bug #197: EnumPaperBins() returned incorrect list
*                                   of strings.
* 13 sep 90   SD    Fixed Bug #60:  EnumPaperBins() always returned false.
*                   The test for the return value (tray < DMBIN_LAST)
*                   corrected to (tray == max).
*  11 jun 90   SD    Used #ifdef DUPLEX to put back in duplexing support.
* 14 feb 90   VO      Added provisions for scaling in loadPFMStruct()
* 01 feb 90    Ken O   Removed duplexing support
* 20 jan 90    Ken O   Removed non-Galaxy support
* 30 nov 89    peterbe Visual edge calls in ifdef now.
* 19 sep 89    peterbe Moved IIP support from include file.
* 13 jul 89    peterbe Moved #include newpattr.h to newprint subdirectory.
* 20 jun 89    peterbe Added #include for new stuff in DRAWPATTERNRECT code.
* 08 may 89    peterbe Cosmetics
*   2-07-89    jimmat  Driver Initialization changes.
*   2-22-89    jimmat  Device Mode Dialog box changes for Windows 3.0.
*/
  
//#define DEBUG
  
#include "generic.h"
#include "resource.h"
#include "strings.h"
#include "spool.h"
#define FONTMAN_UTILS
#include "fontman.h"
#include "memoman.h"
#include "environ.h"
#include "utils.h"
#include "dump.h"
#include "extescs.h"
#include "qsort.h"
#include "paper.h"
#include "truetype.h"
#include "build.h"
  
  
/*  Utilities
*/
#include "message.c"
#include "lockfont.c"
#include "makefsnm.c"
#include "loadfile.c"
  
/*
* The following code was copied from the Microsoft driver for the Aug '90
* mini-release of the Boise driver. This code affects huge bitmaps.
* The following is taken from WINDOWS.H, which has to many
* conflicting definitions to be included here.
*/
  
DWORD FAR PASCAL GetFreeSpace(WORD);
  
#define GMEM_NOT_BANKED     0x1000
#define min(a,b)        ((a) < (b) ? (a) : (b))
  
WORD FAR PASCAL GetDeviceCaps(HDC,WORD);
  
#define LINECAPS 30
#define RASTERCAPS 38

typedef struct  /* also from windows.h 9/91 - dtk */
{
    short   cbSize;
    LPSTR   lpszDocName;
    LPSTR   lpszOutput;
}DOCINFO, FAR * LPDOCINFO;

/****/


extern WORD __AHINCR;
#define ahincr  ((WORD)(&__AHINCR))
  
#define LOWORD(l)       ((WORD)(l))
#define HIWORD(l)       ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
/* End of huge bitmap code addition */
  
/* Turn on duplexing support
*/
#define DUPLEX
  
/*  Debug
*/
#define DBGeli(msg)   /* DBMSG(msg)*/
#define DBGtrace(msg) DBMSG(msg)
#define DBGErr(msg)   DBMSG(msg)
#define DBGMem(msg)   /*DBMSG(msg)*/
#define DBGBandInfo(msg) DBMSG(msg)
  
#define LOCAL static
  
/*  Constants used by ChangeEnvironment().
*/
#define CHG_ORIENT   1
#define CHG_PAPERBIN 2
  
/*  set this bit to change current rather than default paper bin
*/
#define GSPB_CURRENT 0x8000
#define GSPB_DEFAULT 0x0000
  
/*  For DRAWPATTERNRECT
*/
typedef struct {
    POINT prPosition;
    POINT prSize;
    WORD  prStyle;
    WORD  prPattern;
} DRAWPATRECT;
typedef DRAWPATRECT FAR * LPDRAWPATRECT;
  
  
/*  For SETALLJUSTVALUES
*/
typedef struct {
    short nCharExtra;
    WORD nCharCount;
    short nBreakExtra;
    WORD nBreakCount;
} ALLJUSTREC;
typedef ALLJUSTREC FAR * LPALLJUSTREC;
  
/*  BinInfo data structures for GETSETPAPERBINS.
*/
typedef struct {
    short binNum;
    short numOfBins;
    short reserve1;
    short reserve2;
    short reserve3;
    short reserve4;
} BININFO;
typedef BININFO FAR * LPBININFO;
  
#define MAXBINS ((DMBIN_LAST - DMBIN_FIRST) + 2)
#define BINSTRLEN 24
  
typedef struct {
    short binList[1];
    char paperNames[BINSTRLEN];
} BINLIST;
typedef BINLIST FAR * LPBINLIST;
  
  
extern HANDLE hLibInst;     /* driver's instance handle */
  
  
/*  Forward procs.
*/
LOCAL void CalcBreaks (LPJUSTBREAKREC, short, WORD);
LOCAL void AbortJob (LPDEVICE);
LOCAL BOOL SpoolerON (LPDEVICE);
LOCAL void ChangeEnvironment(LPDEVICE, WORD, short);
LOCAL BOOL EnumPaperBins(LPDEVICE, LPBINLIST, LPBININFO, short far *, short);
LOCAL long ScanSofts(LPDEVICE);
LOCAL void InitStartDoc(LPDEVICE);
LOCAL BOOL LoadPFMStruct(LPDEVICE, LPFONTINFO, LPSTR, WORD);
int FAR PASCAL allocate_mem(LPDEVICE);
LOCAL int PASCAL clear_band(LPDEVICE);
  
  
#ifdef DEBUG
#define DBGepmode(mode) dump_epmode(mode)
LOCAL void dump_epmode(short);
LOCAL void dump_epmode(mode)
short mode;
{
    if (mode & DRAFTFLAG)
        { DBGtrace((" DRAFTFLAG")); }
    if (mode & BREAKFLAG)
        { DBGtrace((" BREAKFLAG")); }
    if (mode & GRXFLAG)
        { DBGtrace((" GRXFLAG")); }
    if (mode & LOWRES)
        { DBGtrace((" LOWRES")); }
    if (mode & TEXTFLAG)
        { DBGtrace((" TEXTFLAG")); }
    if (mode & INFO)
        { DBGtrace((" INFO")); }
    if (mode & ANYGRX)
        { DBGtrace((" ANYGRX")); }
}
#else
#define DBGepmode(mode) /*null*/
#endif
  
/*  Control II
*
*  Windows Escape() function, except QUERYESCSUPPORT.
*/
int far PASCAL Control_II(lpDevice, function, lpInData, lpOutData)
LPDEVICE lpDevice;
short function;
LPSTR lpInData;
LPPOINT lpOutData;
/************************************************************************
DESCRIPTION:
IN:
OUT:
************************************************************************/
{
    unsigned i;
    short n;
    ESCtype escstr;
#ifdef DEBUG_FUNCT
    DB(("Entering Control_II\n"));
#endif
  
    /*
    * The following code was copied from the Microsoft driver for the Aug '90
    * mini-release of the Boise driver. This code affects huge bitmaps.
    */
    if (RealMode)
        lpDevice->epBmpHdr.bmBits = lpDevice->epBmp;
    /* End of huge bitmap code addition. */
  
  
    switch (function)
    {

#ifdef WIN31
        /*Start Implement RESETDEVICE: BUG #125 */
        /* BUG #744:  FaceLift sometimes passes in its own PDEVICE in
         * lpInData instead of the driver's.  Need to verify that it is
         * indeed our PDEVICE and return failure if it is not.  NOTE:
         * checking the first word is not foolproof, but it is better than
         * nothing.  I am assuming that FaceLift's PDEVICE does not start
         * out like HPPCL5A's.  We can't check the printer name easily due to
         * aliasing.
         */
        case RESETDEVICE:
            if ((lpInData) && (((LPDEVICE)lpInData)->epType == DEV_PORT
                                || ((LPDEVICE)lpInData)->epType == DEV_LAND))
            {
                lpDevice->ephDC = ((LPDEVICE)lpInData)->ephDC;
                lpDevice->epMode = ((LPDEVICE)lpInData)->epMode;
                lpDevice->epJob = ((LPDEVICE)lpInData)->epJob;
                lpDevice->epDoc = ((LPDEVICE)lpInData)->epDoc;
                lpDevice->epPtr = ((LPDEVICE)lpInData)->epPtr;
                lpDevice->ephMd = ((LPDEVICE)lpInData)->ephMd;
                lpDevice->epFontBmpMem = ((LPDEVICE)lpInData)->epFontBmpMem;
                lpDevice->epPgSoftNum = ((LPDEVICE)lpInData)->epPgSoftNum;
                lpDevice->epTotSoftNum = ((LPDEVICE)lpInData)->epTotSoftNum;
                lpDevice->epMaxPgSoft = ((LPDEVICE)lpInData)->epMaxPgSoft;
                lpDevice->epPageCount = ((LPDEVICE)lpInData)->epPageCount;
                if (lpDevice->epType !=((LPDEVICE)lpInData)->epType ||
                    lpDevice->epTray !=((LPDEVICE)lpInData)->epTray ||
                    lpDevice->epPaper !=((LPDEVICE)lpInData)->epPaper)
                {
                    lpDevice->epPgChng = TRUE;       /* BUG #560 */
                }
                break;
            }
            else
            {
                return (FALSE);
            }
            /*End Implement RESETDEVICE: BUG #125 */
#endif
  
        case NEXTBAND:
            DBMSG(("entering NEXTBAND\n"));
            DBMSG(("epNumBands=%d\n",lpDevice->epNumBands));
            if (lpDevice->epDoc != TRUE)
            {
                DBGErr(("lpDevice->epDoc != TRUE, goto SpoolFail\n"));
                goto SpoolFail;
            }
  
            n = lpDevice->epNband++;
            DBGtrace(("in NEXTBAND  n=%d\n",n));
  
            DBGtrace(("epNband = %d, epMode = %d",
            lpDevice->epNband, lpDevice->epMode));
            DBGepmode(lpDevice->epMode);
            DBGtrace(("\n"));
  
            switch (n)
            {
                case 0:
                    // reset TEXTBAND everytime n=0 (beginning of page).
                    ComputeBandingParameters(lpDevice,lpDevice->epScaleFac);
                    TEXTBAND=FALSE;
                    /*Clear Mode, then set draftflag */
                    //                    lpDevice->epMode = lpDevice->epMode|DRAFTFLAG;
                    i = 0;
                    i |= lpDevice->epMode & DRAFTFLAG;  /*set draftflag*/
                    lpDevice->epMode = i;
                    // This fixes bug #102.  I don't like this here, because we call clear_band
                    // in allocate_mem.  But it fixes the bug, so what the hey!  Note: at this
                    // time, the band is in lpDevice, which means its a small band.  SJC
                    clear_band(lpDevice);
  
                    if((lpDevice->epDoc=StartSpoolPage(lpDevice->epJob))!=TRUE)
                    {
                        DBGErr(("Failed to StartSpoolPage(), goto SpoolFail\n"));
                        goto SpoolFail;
                    }
  
                    lpDevice->epECtl = -1;
                    lpDevice->epCurTTFont = -1;
                    lpDevice->epCurx = lpDevice->epCury = -1;
                    lpDevice->epXerr = lpDevice->epYerr = 0;
                    lpDevice->epGDItext = lpDevice->epOpaqText = FALSE;
                    lpDevice->epXOffset = lpDevice->epYOffset = 0;
  
                    /*  Increment page count and, if the first page,
                    *  send down job control commands (reset, number
                    *  of copies).
                    */
                    if (++lpDevice->epPageCount == 1) {
                        /*BEGIN ELI --  If ELI, Send down JCL  */
                        DBGeli(("Caps2 = %n,  PJL = %n \n",lpDevice->epCaps2,
                        PJL));
                        if (lpDevice->epCaps2 & PJL)
                        {
                            DBGeli(("Printing ELI start job commands.\n"));
                            // COMPILER/LOADER PATCH - the loader will cause a character translation
                            // to occure on the string PJL_START the 1st time that myWrite is called.
                            // To fix this, we call myWrite 3 times with a string of length of 0.  This
                            // clears up the bug.  This bug only occures with MS C 6.0.  When it is fixed,
                            // remove the next 3 lines.
                            myWrite(lpDevice, " ", 0);
                            myWrite(lpDevice, " ", 0);
                            myWrite(lpDevice, " ", 0);
                            myWrite(lpDevice, PJL_START);
                            myWrite(lpDevice, PJL_ENTER_PCL);
                        }
                        /* END ELI */
  
                        if (lpDevice->epOptions & OPTIONS_RESETJOB)
                            myWrite(lpDevice, RESET);
                        /* BEGIN ELI */
  
                        if (lpDevice->epCaps2 & LOWERBIN)
                        {
                            if (lpDevice->epRearTray)
                            {
                                myWrite(lpDevice, LOWER_OUTPUT);
                            }
                            else
                            {
                                myWrite(lpDevice, UPPER_OUTPUT);
                                if (lpDevice->epOffset)
                                {
                                    myWrite(lpDevice,  OFFSET_OUTPUT);
                                }
                            }
                        }
                        /* END ELI */
  
                        myWrite(lpDevice, (LPSTR)&escstr,
                        MakeEscape((lpESC)&escstr,HP_COPIES,
                        lpDevice->epCopies));
#ifdef DUPLEX
                        if (lpDevice->epCaps & ANYDUPLEX)
                            myWrite(lpDevice, (LPSTR)&escstr,
                            MakeEscape((lpESC)&escstr,HP_DUPLEX,
                            (lpDevice->epDuplex == DMDUP_SIMPLEX) ?
                            0 : ((lpDevice->epDuplex == DMDUP_VERTICAL) ?
                            1: 2)));
                        else
#endif
                            lpDevice->epDuplex = DMDUP_SIMPLEX;
                    }
  
                    DBGtrace(("epPageCount=%d\n", lpDevice->epPageCount));
  
                    /*  Set first band to whole page.  ~~*/
                    SetRect((LPRECT)lpOutData, 0, 0, lpDevice->epPF.xPhys,
                    lpDevice->epPF.yPhys);
  
                    /*  Set graphics rect to whole page, BANDINFO will
                    *  change it if the app uses it.  ~~*/
                    lpDevice->epGrxRect = *((RECT FAR *)lpOutData);
  
                    /*  Set page formatting stuff.  */
                    /* Set only if first page, or if orientation, page size,
                     * or paper source have changed.       BUG #560.
                     */
                    if (lpDevice->epPageCount == 1 || lpDevice->epPgChng)
                    {
#ifdef DUPLEX
                        if ((lpDevice->epDuplex == DMDUP_SIMPLEX) ||
                        (lpDevice->epPageCount %2))
                        {
#endif
                            lpDevice->epPgChng = FALSE; /* BUG #671: moved this inside */
                                                        /* the loop that sends the escape */
                            /*  initialize the page (orientation, size, offset) */
                            if ((lpDevice->epTray == DMBIN_ENVELOPE) &&
                                (lpDevice->epCaps & HPSERIESII) &&
                                (lpDevice->epPaper>= DMPAPER_LETTER) &&
                            (lpDevice->epPaper<= DMPAPER_A4))
                            {
                                /*  Envelope initialization note: we always assume Commercial-10
                                size envelopes. */
                                if (lpDevice->epType == (short)DEV_LAND)
                                    myWrite(lpDevice, LAND_COM10_RESET);
                                else
                                    myWrite(lpDevice, PORT_COM10_RESET);
                            }
                            else
                            {
                                /*  Normal page initialization.
                                */
                                myWrite(lpDevice, (LPSTR)lpDevice->epPF.select,
                                lstrlen((LPSTR)lpDevice->epPF.select));
                            }
  
                            /*  set the paper tray
                            */
                            switch (lpDevice->epTray) {
                                case DMBIN_LOWER:
                                    myWrite(lpDevice, (LPSTR)LOWER_TRAY);
                                    break;
                                case DMBIN_MANUAL:
                                    myWrite(lpDevice, (LPSTR)MAN_FEED);
                                    break;
                                case DMBIN_AUTO:
                                    myWrite(lpDevice, (LPSTR)PAPER_DECK);
                                    break;
                                case DMBIN_ENVELOPE:
                                    if (lpDevice->epCaps & NEWENVFEED)
                                        myWrite(lpDevice, ENV_TRAY);
                                    else
                                        myWrite(lpDevice, MAN_ENVFEED);
                                    break;
                                default:
                                    myWrite(lpDevice, (LPSTR)UPPER_TRAY);
                                    break;
                            }
#ifdef DUPLEX
                        }
#endif
                    } /* end of set page formatting stuff */
                    setnoscale:
                    ((LPPOINT)lpInData)->xcoord=((LPPOINT)lpInData)->ycoord=0;
                    break;
  
                case 1:
                    /* If scaling exists, the graphics were scaled but the clipping region
                    * wasn't.  Set the flag as if we had indeed seen graphics.  30 Jan 90
                    */
                    if (lpDevice->epScaleFac)
                        lpDevice->epMode |= ANYGRX;
                    /* End of grayscale code addition */
  
                    // Now, if protectmode, allocate some RAM for the bitmap.
                    // Either way, we will clear the band also.
                    allocate_mem(lpDevice);
  
                    /* Set desired printer resolution */
                    if (!(lpDevice->epScaleFac))
                        myWrite(lpDevice, (LPSTR) HP_SET_300RES);
                    else
                    {
                        if (lpDevice->epScaleFac==1)
                            myWrite(lpDevice, (LPSTR) HP_SET_150RES);
                        else
                            myWrite(lpDevice, (LPSTR) HP_SET_75RES);
                    }
  
                    /*  Fall through.  Note that GRXFLAG should never be
                    *  set at this point.
                    */
                default:
                    DBMSG(("entering NEXTBAND for default bands.\n"));
                    /*  Send current band to the spooler if it contains
                    *  graphics.
                    */
                    if ((lpDevice->epMode & DRAFTFLAG) ||
                        (   !(lpDevice->epMode & ANYGRX) &&
                        !lpDevice->epGDItext &&
                    n==2)   ) {
                        // Move this test here because we may not know if there is graphics until
                        // n=2.  SJC (case in point - PowerPoint)
                        /*  don't band further if in draftmode or if no
                        *  graphics on the page
                        */
                        DBMSG(("Quick exit, Nextband, n=%d\n",n));
                        // TEXTBAND factors into this to fix bug #108.  This prevents infinate loop
                        // in real & draft mode.
                        if(TEXTBAND)
                            n=lpDevice->epNumBands+2;  //Allows for no more passes
                        else
                            n=lpDevice->epNumBands+1;  //Allows for 1 more pass
                        lpDevice->epNband=n+1;     //After above pass, quit
                        ((LPPOINT)lpInData)->xcoord=((LPPOINT)lpInData)->ycoord=0;
                    }
                    else if ((lpDevice->epMode & GRXFLAG) && (!TEXTBAND)) {
                        /*  If we have skipped previous bands because they
                        *  did not contain graphics, then advance the cursor
                        *  position so we'll place this band correctly.
                        */
                        DBMSG(("NEXTBAND default, GRXFLAG set\n"));
                        if (lpDevice->epMode & SKIPFLAG)
                        {
                            POINT pos;
                            DBMSG(("NEXTBAND default, SKIPFLAG set\n"));
                            ComputeBandStartPosition(&pos, lpDevice, n-1);
  
                            if (lpDevice->epType == (short)DEV_LAND)
                                xmoveto(lpDevice, pos.xcoord);
                            else
                                ymoveto(lpDevice, pos.ycoord);
                            DBMSG(("NEXTBAND default, ret from x/ymoveto\n"));
                        }
  
                        /*  Send the band to the printer.
                        */
                        DBMSG(("NEXTBAND default, about to DUMP\n"));
                        dump(lpDevice);
                        DBMSG(("NEXTBAND default, ret from DUMP\n"));
  
                        /*  Reset the current position because it
                        *  is unknown after sending the bitmap.
                        */
                        lpDevice->epCurx = lpDevice->epCury = -1;
  
                        /*  Clear the bitmap.  */
                        DBMSG (("epNband=%d, epNumBands=%d\n",lpDevice->epNband,lpDevice->epNumBands));
                        clear_band(lpDevice);
  
                        /*  Clear previous flags.
                        */
                        lpDevice->epMode &= ~(GRXFLAG | SKIPFLAG);
                    }
                    else
                    {
                        /*  Skip this band because it does not contain
                        *  graphics.
                        */
                        DBGtrace(("Skip Band\n"));
                        lpDevice->epMode |= SKIPFLAG;
                    }
  
                    ((LPPOINT)lpInData)->xcoord = ((LPPOINT)lpInData)->ycoord
                    = lpDevice->epScaleFac;
                    break;
            }
            /* The following code is outside of the switch (n) statement.
            * It is executed on all nextband calls!
            */
  
            /*  Calculate coordinates for the next band.  */
            if (!ComputeNextBandRect(lpDevice,n+1,(LPRECT)lpOutData)) //||
                //              (n > 1 && !(lpDevice->epMode & ANYGRX) && !lpDevice->epGDItext))
            {
                /* no next band */
                lpDevice->epNband = 0;
                /* reset text band to false   Bug #765   - jcs */
                TEXTBAND=FALSE;
                /* reset to default font */
                myWrite(lpDevice, FONT_DEFAULT);
                myWrite(lpDevice, HP_FF);
                myWriteSpool(lpDevice);
  
                if (lpDevice->epDoc == TRUE)
                    lpDevice->epDoc = EndSpoolPage(lpDevice->epJob);
#ifdef VISUALEDGE
                /* Eject page to LaserPort */
                if (lpDevice->epOptions & OPTIONS_DPTEKCARD)
                    lp_ff(lpDevice);     /* LaserPort */
#endif
                SetRectEmpty((LPRECT)lpOutData);
                ((LPPOINT)lpInData)->xcoord = ((LPPOINT)lpInData)->ycoord = 0;
            }
// lpInData->xcoord and ycoord tell GDI what resolution to associate with
// the next band.  0 means 300 DPI, therefore, on the TEXTBAND, we
// assign 0.  Every other time, we use the epScaleFac.  SJC
            if(TEXTBAND)
               ((LPPOINT)lpInData)->xcoord=((LPPOINT)lpInData)->ycoord=0;
            else
               ((LPPOINT)lpInData)->xcoord=((LPPOINT)lpInData)->ycoord=
               lpDevice->epScaleFac;
//            break;                                    /* BUG #789 */
  
            if (lpDevice->epDoc != TRUE)
                SpoolFail:
            {
                short err = lpDevice->epDoc;            /* BUG #789 */
                SetRectEmpty((LPRECT)lpOutData);
  
                DBGErr(("SpoolFail:  calling AbortJob()\n"));
                AbortJob(lpDevice);
                return (err);                           /* BUG #789 */
            }
  
            /* fall through and return the status
            */
            DBGtrace(("Band Rect is left=%d,top=%d,right=%d,bottom=%d\n",
            (*(LPRECT)lpOutData).left,(*(LPRECT)lpOutData).top,
            (*(LPRECT)lpOutData).right,(*(LPRECT)lpOutData).bottom));
            DBGtrace(("NEXTBAND returning %d\n",lpDevice->epDoc));
            return (lpDevice->epDoc);
        case NEWFRAME:
            DBMSG(("NEW FRAME\n"));
            // following line fixed a bug in the 3.70 driver. Terry
            TEXTBAND=FALSE;
//          lpDevice->epFreeMem = lpDevice->epAvailMem-ScanSofts(lpDevice);
            return (lpDevice->epDoc);
        case GETSCALINGFACTOR:
            DBGtrace(("GETSCALINGFACTOR,returns %d\n",lpDevice->epScaleFac));
            ((LPPOINT)lpOutData)->xcoord = ((LPPOINT)lpOutData)->ycoord =
            lpDevice->epScaleFac;
            break;
        case DRAFTMODE:
            DBGtrace(("DRAFTMODE\n"));
            if (*(short far *)lpInData)
                lpDevice->epMode |= DRAFTFLAG;
            else
                lpDevice->epMode &= ~(DRAFTFLAG);
            break;
        case STARTDOC:
            DBGtrace(("STARTDOC: %ls\n", (LPSTR)lpInData));
  
            if (lpDevice->epDoc != 0)
            {
                /*  There is another job spooling!  Return an "out of space"
                *  err to indicate that the job cannot be processed.
                */
                DBGErr(("...aborting job because another job spooling!\n"));
                return SP_OUTOFDISK;
            }
  
            InitStartDoc(lpDevice);
  
#ifdef VISUALEDGE
            if (lpDevice->epOptions & OPTIONS_DPTEKCARD)
                lp_Reset(lpDevice);     /* LaserPort */
#endif
  
            lpDevice->epFreeMem = lpDevice->epAvailMem - ScanSofts(lpDevice);
            lpDevice->epPageCount = 0;
            lpDevice->epNband = 0;           /* BUG # 789 */
  
            /*check that minimum memory is available*/
            DBGMem(("free mem is %ld\n",lpDevice->epFreeMem));
            if (lpDevice->epFreeMem < MINMEM)
            {
                ErrorMsg(lpDevice, MAX_PERM_DL);
                return FALSE;
            }
#ifdef WIN31
            /*  Bug #590: Change STARTDOC.  if lpOutData is not NULL, and
             *  if lpszOutputName is not NULL, then lpszOutput name contains
             *  the name of the output port. Otherwise, use the output port
             *  from CreateDC.
             */
            if (lpOutData)
                lpOutData = (LPPOINT)((LPDOCINFO)lpOutData)->lpszOutput;
            if (!lpOutData)
                lpOutData = (LPPOINT)lpDevice->epPort;
            if ((lpDevice->epJob = OpenJob((LPSTR)lpOutData,
                lpInData, lpDevice->ephDC)) > 0)
#else  /* end of WIN31; start of Win 30 */
            if ((lpDevice->epJob = OpenJob((LPSTR)lpDevice->epPort,
                lpInData, lpDevice->ephDC)) > 0)
#endif /* End of Win 30 */
            {
                lpDevice->epDoc = TRUE;
            }

#ifdef DEBUG
            else
            {
                DBGErr(("...failed to OpenJob()\n"));
            }
#endif
  
            return (lpDevice->epJob);
  
        case ENDDOC:
            DBGtrace(("ENDDOC\n"));
  
#ifdef DUPLEX
            /*  If printing duplex and we output an uneven number
            *  of pages, then send down an extra page eject.
            */
            if ((lpDevice->epCaps & ANYDUPLEX) &&
                (lpDevice->epDuplex != DMDUP_SIMPLEX) &&
                (lpDevice->epPageCount % 2) && (lpDevice->epDoc == TRUE) &&
                (lpDevice->epDoc = StartSpoolPage(lpDevice->epJob)))
            {
                DBGErr(("UNEVEN NO OF PAGES -- SENDING DOWN PAGE EJECT\n"));
                myWrite(lpDevice, (LPSTR)lpDevice->epPF.select,
                lstrlen((LPSTR)lpDevice->epPF.select));
                ++lpDevice->epPageCount;
                myWriteSpool(lpDevice);
                lpDevice->epDoc = EndSpoolPage(lpDevice->epJob);
            }
#endif
            if ((lpDevice->epOptions & OPTIONS_RESETJOB) &&
                (lpDevice->epDoc == TRUE) &&
                (lpDevice->epDoc = StartSpoolPage(lpDevice->epJob)))
            {
                myWrite(lpDevice, RESET);
                if (lpDevice->epCaps2 & PJL)
                {
                    DBGeli(("Printing PJL at end of job.\n"));
                    myWrite(lpDevice, PJL_START);             /* ELI */
                }
                myWriteSpool(lpDevice);
                lpDevice->epDoc = EndSpoolPage(lpDevice->epJob);
            }
  
#ifdef VISUALEDGE
            if (lpDevice->epOptions & OPTIONS_DPTEKCARD)
                lp_Reset(lpDevice);     /* LaserPort */
#endif
  
            if (lpDevice->epDoc == TRUE)
                CloseJob(lpDevice->epJob);
            lpDevice->epDoc = 0;
            return TRUE;
        case GETPHYSPAGESIZE:
            DBGtrace(("GETPHYSPAGESIZE\n"));
            lpOutData->xcoord = lpDevice->epPF.xPhys;
            lpOutData->ycoord = lpDevice->epPF.yPhys;
            break;
        case GETPRINTINGOFFSET:
            DBGtrace(("GETPRINTINGOFFSET\n"));
            lpOutData->xcoord = lpDevice->epPF.xPrintingOffset;
            lpOutData->ycoord = lpDevice->epPF.yPrintingOffset;
            DBGtrace(("done with GETPRINTINGOFFSET\n"));
            DBGtrace(("xcoord=%d\n",lpOutData->xcoord));
            DBGtrace(("ycoord=%d\n",lpOutData->ycoord));
            break;
        case SETABORTPROC:
            DBGtrace(("SETABORTPROC\n"));
            lpDevice->ephDC = *(HANDLE far *)lpInData;
            break;
        case ABORTDOC:
            DBGtrace(("ABORTDOC\n"));
            AbortJob(lpDevice);
            break;
        case SETCOPYCOUNT:
            DBGtrace(("SETCOPYCOUNT\n"));
  
            /* MSD 11/7/88 don't send the escape here -- it is sent at the
            *  beginning of the print job.
            */
            lpDevice->epCopies = (short) *(LPINT)lpInData;
            *(LPINT)lpOutData =  *(LPINT)lpInData;
            break;
        case BANDINFO:
            DBMSG(("BANDINFO\n"));
            // For sanity, set ANYGRX at this time.  This is because some apps are not
            // behaving nicely by NOT telling us they have graphics (PM does this when
            // it has vector fonts).  This causes us to allocate RAM almost always!
            lpDevice->epMode |= ANYGRX;
            if ((lpDevice->epNband-1)==0) {
                if (lpInData!=NULL) {
                    if (*((BOOL far *)lpInData)++) {
                        /*  set flag to indicate graphics on page */
                        lpDevice->epMode |= ANYGRX;
                        DBGBandInfo(("graphics on page\n"));
                    }
                    if (*((BOOL far *)lpInData)++) {
                        DBGBandInfo(("text on page\n"));
                    }
                    lpDevice->epGrxRect = *((RECT FAR *)lpInData);
                }
                // No text or graphics on first band
                // Next two lines are FALSE which indicates that the app should NOT send
                // Graphics or Text on the 1st band - this is  a skip band.
                *((BOOL far *)lpOutData)++=FALSE;
                *((BOOL far *)lpOutData)=FALSE;
                DBGBandInfo(("BandInfo Rect is left=%d,top=%d,right=%d,bottom=%d\n",
                lpDevice->epGrxRect.left,lpDevice->epGrxRect.top,
                lpDevice->epGrxRect.right,lpDevice->epGrxRect.bottom));
                break;
            }
            if (TEXTBAND) {
                DBMSG(("Setting graphics to false, text to true\n"));
                *((BOOL far *)lpOutData)++=FALSE; /*no graphics on first band*/
                *((BOOL far *)lpOutData)=TRUE; /*text on first band*/
            }
            else {
                DBMSG(("Setting text to false, graphics to true\n"));
                // 10-14-90 Simplified else {} - Set lpOutData to TRUE always for BUG #82
                // SJC
                *((BOOL far *)lpOutData)++=TRUE;/*graphics on all other bands*/
                // text 'cause vector fonts used
                *((BOOL far *)lpOutData)=TRUE;
            }
            break;
        case DEVICEDATA:
            DBGtrace(("DEVICEDATA\n"));
            if (lpInData!=NULL) {
                short bytenum;
                /*  First clear buffer, then output stuff, then
                *  flush the buffer again and return the number
                *  of bytes written.
                */
                bytenum = *((short far *)lpInData)++;
                if (bytenum > 0)
                {
#ifdef VISUALEDGE
                    /* LaserPort */
                    if ( !(lpDevice->epOptions & OPTIONS_DPTEKCARD) ||
                        !lp_DeviceData(lpDevice,(LPSTR)lpInData,(short)bytenum) )
#endif
                    {
                        myWriteSpool(lpDevice);
                        myWrite(lpDevice,(LPSTR)lpInData,(short)bytenum);
                        myWriteSpool(lpDevice);
                    }
                    return(bytenum);
                }
                else
                    return(-1);
            }
            return(-1);
            break;
  
        case SETALLJUSTVALUES: {
            LPEXTTEXTDATA lpExtText = (LPEXTTEXTDATA)lpInData;
            LPALLJUSTREC lpAllJust = (LPALLJUSTREC)lpExtText->lpInData;
            LPDRAWMODE lpDrawMode = lpExtText->lpDrawMode;
            LPFONTINFO lpFont = lpExtText->lpFont;
  
            DBGtrace(("SETALLJUSTVALUES\n"));
  
            lpDrawMode->TBreakExtra = 0;
            lpDrawMode->BreakExtra = 0;
            lpDrawMode->BreakErr = 1;
            lpDrawMode->BreakRem = 0;
            lpDrawMode->BreakCount = 0;
            lpDrawMode->CharExtra = 0;
  
            if (lpFont->dfCharSet == OEM_CHARSET) {
                /*  Vector font: disable ALLJUSTVALUES and
                *  return false.
                */
                lpDevice->epJust = fromdrawmode;
                return FALSE;
            }
  
            if (lpInData) {
                CalcBreaks (&lpDevice->epJustWB, lpAllJust->nBreakExtra,
                lpAllJust->nBreakCount);
                CalcBreaks (&lpDevice->epJustLTR, lpAllJust->nCharExtra,
                lpAllJust->nCharCount);
  
                if (lpDevice->epJustWB.extra || lpDevice->epJustWB.rem ||
                lpDevice->epJustLTR.extra || lpDevice->epJustLTR.rem) {
                    if (lpDevice->epJustLTR.rem)
                        lpDevice->epJust = justifyletters;
                    else
                        lpDevice->epJust = justifywordbreaks;
                }
                else
                    /*  Zero justification == shut off ALLJUSTVALUES.
                    */
                    lpDevice->epJust = fromdrawmode;
            }
            break;
        }
  
        case DRAWPATTERNRECT: {
            LPDRAWPATRECT lpPatRect = (LPDRAWPATRECT)lpInData;
            WORD pattern, style;
  
            DBGtrace(("DRAWPATTERNRECT\n"));
            lpDevice->epMode |= ANYGRX;
  
#ifdef VISUALEDGE
            /* LaserPort does not currently support patterns */
            if (lpDevice->epOptions & OPTIONS_DPTEKCARD)
                return FALSE;       /* LaserPort */
#endif
  
            /* TETRA -- removed HPJET conditional */
  
            if (! TEXTBAND)
                return TRUE;        /* Do not draw rules on non-text bands */
  
            /*  Range-check the pattern based upon kind of rule.
            */
            DBMSG(("style=%d\n",lpPatRect->prStyle));
            DBMSG(("prPattern=%d\n",lpPatRect->prPattern));
            switch (style = lpPatRect->prStyle) {
                case 0:         // black fill
                    pattern = 0;
                    break;
  
                case 1:         // White (erase) fill (III only)
                    /* TETRA -- removed non-Galaxy support */
                    pattern = 0;
                    break;
  
                case 2:         // Shaded gray fill
                    if ((pattern = lpPatRect->prPattern) < 1)
                        pattern = 1;
                    if (pattern > 100)
                        pattern = 100;
                    break;
  
                case 3:         // HP-defined pattern fill
                    if ((pattern = lpPatRect->prPattern) < 1)
                        pattern = 1;
                    if (pattern > 6)
                        pattern = 6;
                    break;
  
                default:
                    pattern = 0;
                    style = 0;
                    break;
            }
  
            /*  Move to output position.
            */
            DBMSG(("xcoord=%d, ycoord=%d\n",lpPatRect->prPosition.xcoord,lpPatRect->prPosition.ycoord));
            xmoveto(lpDevice, lpPatRect->prPosition.xcoord);
            ymoveto(lpDevice, lpPatRect->prPosition.ycoord);
  
            /*  Set size of rule.
            */
            DBMSG(("Size.xcoord=%d\n",lpPatRect->prSize.xcoord));
            DBMSG(("Size.ycoord=%d\n",lpPatRect->prSize.ycoord));
            myWrite(lpDevice, (LPSTR)&escstr,
            MakeEscape((lpESC)&escstr,DOT_HRPS,lpPatRect->prSize.xcoord));
            myWrite(lpDevice, (LPSTR)&escstr,
            MakeEscape((lpESC)&escstr,DOT_VRPS,lpPatRect->prSize.ycoord));
  
            /*  Set the pattern if applicable.
            */
            if (pattern) {
                myWrite(lpDevice, (LPSTR)&escstr,
                MakeEscape((lpESC)&escstr,PAT_ID,pattern));
            }
  
            /*  Output pattern/rule.
            */
            myWrite(lpDevice, (LPSTR)&escstr,
            MakeEscape((lpESC)&escstr,PAT_PRINT,style));
        }
            break;
  
        case ENABLEDUPLEX:
            DBGtrace(("ENABLEDUPLEX\n"));
#ifdef DUPLEX
            if (lpInData && (lpDevice->epCaps & ANYDUPLEX)) {
                lpDevice->epDuplex = *(short far *)lpInData;
                if (lpDevice->epDuplex == 1)
                    lpDevice->epDuplex = DMDUP_VERTICAL;
                else if (lpDevice->epDuplex == 2)
                    lpDevice->epDuplex == DMDUP_HORIZONTAL;
                else
                    lpDevice->epDuplex == DMDUP_SIMPLEX;
  
                /*  If doing duplex on a LaserJet IID in landscape, swap the
                *  duplex bits so it follows the same rules as a LaserJet 2000
                */
                if ((lpDevice->epDuplex != DMDUP_SIMPLEX) &&
                    (lpDevice->epCaps & HPIIDDUPLEX) &&
                    (lpDevice->epType == (short)DEV_LAND))
  
                    lpDevice->epDuplex =
                    (lpDevice->epDuplex == DMDUP_VERTICAL) ?
                    DMDUP_HORIZONTAL : DMDUP_VERTICAL;
            }
            else
                return FALSE;
            break;
#else
            return FALSE;
            break;
#endif
        case GETEXTENDEDTEXTMETRICS:
            DBGtrace(("GETEXTENDEDTEXTMETRICS\n"));
            i = FNTLD_EXTMETRICS;
            goto loadPFM;
        case GETPAIRKERNTABLE:
            DBGtrace(("GETPAIRKERNTABLE\n"));
            i = FNTLD_PAIRKERN;
            goto loadPFM;
        case GETTRACKKERNTABLE:
            DBGtrace(("GETTRACKKERNTABLE\n"));
            i = FNTLD_TRACKKERN;
            loadPFM:
        {
            LPFONTINFO lpFont = ((LPEXTTEXTDATA)lpInData)->lpFont;
            return (LoadPFMStruct(lpDevice, lpFont, (LPSTR)lpOutData, i));
        }
  
        case GETSETPRINTORIENT:
        {
            /*  For this escape, 1 = PORTRAIT, 2 = LANDSCAPE.
            */
            short oldOrient;
  
            DBGtrace(("GETSETPRINTORIENT\n"));
  
            if (lpDevice->epType == (short)DEV_LAND)
                oldOrient = 2;
            else if (lpDevice->epType == (short)DEV_PORT)
                oldOrient = 1;
            else
                oldOrient = -1;
  
            if ((oldOrient > 0) && lpInData)
            {
                short orient = lpDevice->epType;
  
                if (*(short far *)lpInData == 2)
                    orient = (short)DEV_LAND;
                else if (*(short far *)lpInData == 1)
                    orient = (short)DEV_PORT;
                else
                    oldOrient = -1;
  
                if (orient != lpDevice->epType) {
                    ChangeEnvironment(lpDevice, CHG_ORIENT,
                    (orient == (short)DEV_LAND) ? DMORIENT_LANDSCAPE :
                    DMORIENT_PORTRAIT);
                }
            }
  
            return (oldOrient);
        }
  
        case GETSETPAPERBINS:
            DBGtrace(("GETSETPAPERBINS\n"));
  
            if (lpInData) {
                BININFO binInfo;
                LPBININFO lpBinInfo;
                short binNum = (~GSPB_CURRENT) & *((short far *)lpInData);
                short fDefault = !(GSPB_CURRENT & *((short far *)lpInData));
                short xbin[MAXBINS];
  
                if (lpOutData)
                    lpBinInfo = (LPBININFO)lpOutData;
                else
                    lpBinInfo = &binInfo;

                if (EnumPaperBins(lpDevice,0L,lpBinInfo,xbin,MAXBINS) &&
                    (binNum >= 0) && (binNum < lpBinInfo->numOfBins)) {
                    if (fDefault && xbin[binNum] != lpDevice->epTray)
                        /* set the default environment */
                        ChangeEnvironment(lpDevice,CHG_PAPERBIN,xbin[binNum]);
                    else
                    {
                            /* set the bin for the current job */
                            lpDevice->epTray = xbin[binNum];
                            lpDevice->epPgChng = TRUE;   /* Bug #671: added flag update */
                     }
                }
                else
                    return FALSE;
            }
            else if (lpOutData)
                return(EnumPaperBins(
                lpDevice,0L,(LPBININFO)lpOutData,0L,MAXBINS));
            else
                return FALSE;
            break;
  
        case ENUMPAPERBINS:
            DBGtrace(("ENUMPAPERBINS\n"));
  
            if (lpInData && lpOutData) {
                short maxBins = *((short far *)lpInData);
  
                if (maxBins > 0)
                    return(EnumPaperBins(lpDevice,(LPBINLIST)lpOutData,
                    0L,0L,maxBins));
                else
                    return FALSE;
            }
            else
                return FALSE;
            break;
  
        case GETTECHNOLOGY:
#ifdef VISUALEDGE
            if (lpDevice->epOptions & OPTIONS_DPTEKCARD)
                lmemcpy((LPSTR)lpOutData, (LPSTR)"PCL\0LaserPort\0\0", 15);
            else
#endif
                lmemcpy((LPSTR)lpOutData, (LPSTR)"PCL\0\0", 5);
            break;
  
        case SETCHARSET:
            DBGtrace(("SETCHARSET\n"));
  
            if (*((short far *)lpInData))
                lpDevice->epPubTrans = TRUE;
            else
            {
                lpDevice->epPubTrans = FALSE;
  
                /* Reset secondary font */
                myWrite(lpDevice, RESET_SECOND);
            }
            break;
  
        default:
            return FALSE;
    }
  
#ifdef DEBUG_FUNCT
    DB(("Exiting Control_II \n"));
#endif
    return TRUE;  /*return true if Escape is successful*/
}
  
/*  CalcBreaks
*/
LOCAL void CalcBreaks (lpJustBreak, BreakExtra, Count)
LPJUSTBREAKREC lpJustBreak;
short BreakExtra;
WORD Count;
{
#ifdef DEBUG_FUNCT
    DB(("Entering CalcBreaks\n"));
#endif
    if (Count > 0)
    {
        /*  Fill in JustBreak values.  May be positive or negative.
        */
        lpJustBreak->extra = BreakExtra / (short)Count;
        lpJustBreak->rem = BreakExtra % (short)Count;
        lpJustBreak->err = (short)Count / 2 + 1;
        lpJustBreak->count = Count;
        lpJustBreak->ccount = 0;
  
        /*  Negative justification:  invert rem so the justification algorithm
        *  works properly.
        */
        if (lpJustBreak->rem < 0)
        {
            --lpJustBreak->extra;
            lpJustBreak->rem += (short)Count;
        }
    }
    else
    {
        /*  Count = zero, set up justification rec so the algorithm
        *  always returns zero adjustment.
        */
        lpJustBreak->extra = 0;
        lpJustBreak->rem = 0;
        lpJustBreak->err = 1;
        lpJustBreak->count = 0;
        lpJustBreak->ccount = 0;
    }
#ifdef DEBUG_FUNCT
    DB(("Exiting CalcBreaks\n"));
#endif
}
  
/*  AbortJob
*
*  Abort the print job -- send down an escape-E to reset the printer
*  if its okay to do that.
*/
LOCAL void AbortJob (lpDevice)
LPDEVICE lpDevice;
{
#ifdef DEBUG_FUNCT
    DB(("Entering AbortJob\n"));
#endif
    DBGtrace(("AbortJob()\n"));
  
    if (lpDevice->epJob)
    {
        DBGtrace(("AbortJob(): epJob == TRUE\n"));
  
        if (SpoolerON(lpDevice))
        {
            /*  Spooler on, DeleteJob() will discard the current
            *  page without sending any miscellaneous data to
            *  the printer.
            */
            DBGtrace(("AbortJob(): DeleteJob (spooler ON)\n"));
            DeleteJob(lpDevice->epJob, 0);
        }
        else
        {
            /*  Spooler off, output a RESET and end the job normally,
            *  this will flush the job out of the printer (the last
            *  page will probably come out garbaged).
            */
            if ((lpDevice->epOptions & OPTIONS_RESETJOB) &&
                (lpDevice->epDoc == TRUE) &&
                (lpDevice->epDoc = StartSpoolPage(lpDevice->epJob)))
            {
                DBGtrace(
                ("AbortJob(): StartSpoolPage, send RESET, EndSpoolPage\n"));
  
                myWrite(lpDevice, RESET);
                DBGeli(("After RESET during Abort.\n"));
                if (lpDevice->epCaps2 & PJL)
                {
                    DBGeli(("Printing PJL after Abort\n"));
                    myWrite(lpDevice, PJL_START);             /* ELI */
                }
                myWriteSpool(lpDevice);
                lpDevice->epDoc = EndSpoolPage(lpDevice->epJob);
            }
  
#ifdef VISUALEDGE
            if (lpDevice->epOptions & OPTIONS_DPTEKCARD)
                lp_Reset(lpDevice);     /* LaserPort */
#endif
  
            DBGtrace(("AbortJob(): CloseJob (spooler OFF)\n"));
            CloseJob(lpDevice->epJob);
        }
  
        /* BUG #789:  DO zero out negative epDoc.  Error is now trapped 
         * before the call to AbortJob now.  If error is not zeroed out, 
         * the next STARTDOC can have the negative epDoc and will think there
         * is a job going.
         */  
//        if (lpDevice->epDoc > 0)         /* BUG #529: don't zero out negatives */
            lpDevice->epDoc = 0;
        lpDevice->epJob = 0;
    }
#ifdef DEBUG_FUNCT
    DB(("Exiting AbortJob\n"));
#endif
}
  
/*  SpoolerON
*
*  Return TRUE if spooler=yes in the win.ini file.
*/
LOCAL BOOL SpoolerON (lpDevice)
LPDEVICE lpDevice;
{
    char nmWin[32];
    char nmSpl[32];
    char s[12];
  
#ifdef DEBUG_FUNCT
    DB(("Entering SpoolerON\n"));
#endif
    lmemset(s, 0, sizeof(s));
  
    if (LoadString(hLibInst, IDS_WINDOWS, nmWin, sizeof(nmWin)) &&
        LoadString(hLibInst, IDS_SPOOLER, nmSpl, sizeof(nmSpl)) &&
        GetProfileString(nmWin, nmSpl, s, s, sizeof(s)))
    {
        if ((s[0] == 'n') || (s[0] == 'N'))
            return FALSE;
        else
            return TRUE;
    }
#ifdef DEBUG_FUNCT
    DB(("Exiting SpoolerON\n"));
#endif
}
  
/*  ChangeEnvironment
*
*  An escape has been executed which changes the environment -- get the
*  current environment and make the change, write it back, then broadcast
*  a WM_DEVMODECHANGE message.  Responsible applications should then
*  Disable() and then (re-) Enable() the driver to correctly effect the
*  change.
*/
LOCAL void
ChangeEnvironment(LPDEVICE lpDevice, WORD field, short value) {
  
    PCLDEVMODE pclDevmode;
#ifdef DEBUG_FUNCT
    DB(("Entering ChangeEnvironment\n"));
#endif
  
    /*  Get the current environment.
    */
    MakeEnvironment(&pclDevmode, lpDevice->epDevice, lpDevice->epPort, NULL);
  
    /*  Modify the specified field.
    */
    switch (field) {
  
        case CHG_ORIENT:
            pclDevmode.dm.dmOrientation = value;
            break;
  
        case CHG_PAPERBIN:
            pclDevmode.dm.dmDefaultSource = value;
            break;
    }
  
    /*  Update the environment with the change.
    */
#ifdef WIN31    
    SetEnvironment(pclDevmode.dm.dmDeviceName, (LPSTR)&pclDevmode, sizeof(PCLDEVMODE));
#else
    SetEnvironment(lpDevice->epPort, (LPSTR)&pclDevmode, sizeof(PCLDEVMODE));
#endif
  
    /*  Tell the world.
    */
    SendMessage(0xffff, WM_DEVMODECHANGE, 0, (LONG)(LPSTR)lpDevice->epDevice);
#ifdef DEBUG_FUNCT
    DB(("Exiting ChangeEnvironment\n"));
#endif
}
  
/*  EnumPaperBins
*
*  Count the number of paper bins that are currently in use.  If passed
*  in lpBinInfo, then collect the number of bins and the bin number
*  (0 through MAXBINS) of the currently selected paper bin.  If passed
*  in xbin, then build a translation table which relates the bin number
*  (0 through MAXBINS) to the devmode tray number (DMBIN_FIRST...).
*  If passed in lpOut, then fill in a structure with bin numbers and
*  corresponding paper description strings.
*/
LOCAL BOOL
EnumPaperBins(LPDEVICE lpDevice, LPBINLIST lpOut, LPBININFO lpBinInfo,
short far *lpXbin, short max) {
  
    int   i, tray;
    LPSTR lpPaperNames = 0L;
    short far *lpBinList = 0L;
    short cBins = 0;
#ifdef DEBUG_FUNCT
    DB(("Entering EnumPaperBins\n"));
#endif
  
    DBGtrace(("EnumPaperBins(%lp,%lp,%lp,%lp, %d)\n",
    lpDevice, lpOut, lpBinInfo, lpXbin, max));
  
    if (lpOut) {
        lpBinList = lpOut->binList;
        lpPaperNames = (LPSTR)lpOut->binList + (max * 2);
    }
  
    if (lpBinInfo)
        lmemset((LPSTR)lpBinInfo, 0, sizeof(BININFO));
  
    for (cBins = 0, tray = DMBIN_FIRST; (tray <= DMBIN_LAST) &&
    (cBins < max); ++tray) {

        i = 0;                                /* BUG #70 -- added init for i */
  
        switch (tray) {
  
            case DMBIN_UPPER:
                i = IDS_UPPER;
                break;
            case DMBIN_LOWER:
                if (lpDevice->epCaps & LOTRAY)  /* BUG #70 -- Removed ';' */
                    i = IDS_LOWER;
                break;
            case DMBIN_MANUAL:
                if (!(lpDevice->epCaps & NOMAN))
                    i = IDS_MANUAL;
                break;
            case DMBIN_ENVELOPE:
                if (lpDevice->epCaps & ANYENVFEED)
                    i = IDS_ENVELOPE;
                break;
            case DMBIN_AUTO:
                if (lpDevice->epCaps & AUTOSELECT)
                    i = IDS_AUTO;
                    break;               /* BUG #70 -- added break stmt */
            default:
                i = 0;
                break;
        }
  
        if (i) {
  
            /*  Bin translation table.
             */
            if (lpXbin)
                *(lpXbin++) = tray;
  
            /*  List of bin indices and corresponding description strings.
             */
            if (lpOut) {
  
                *(lpBinList++) = cBins;
                LoadString(hLibInst, i, lpPaperNames, BINSTRLEN);
                lpPaperNames += BINSTRLEN;
            }
  
            if (lpBinInfo) {
  
                /*  Current tray selection.
                 */
                if (lpDevice->epTray == tray)
                    lpBinInfo->binNum = cBins;
            }
            cBins++;
        }
    }
  
    if (lpBinInfo)
        lpBinInfo->numOfBins = cBins;
  
#ifdef DEBUG_FUNCT
    DB(("Exiting EnumPaperBins\n"));
#endif
    return (tray >= max);                   /* BUG #60 */
}
  
LOCAL long ScanSofts(lpDevice)
LPDEVICE lpDevice;
/*this is called at start of a page in order to find how much memory is
occupied by downloaded fonts. The routine also clears the onPage flags
and sets epTotSoftNum in lpDevice and returns the sum of memory used by all
permanents. Memory is in
bytes. It also resets the printer if the fontsummary information has been
newly created in order that any previous temp soft fonts are deleted*/
{
    LPFONTSUMMARYHDR lpFontSummary;
    LPFONTSUMMARY   lpSummary;  /*array of all fonts*/
    short  ind,len;
    long memused=0L;
#ifdef DEBUG_FUNCT
    DB(("Entering ScanSofts\n"));
#endif
  
    if (!(lpFontSummary = lockFontSummary(lpDevice)))
    {
        /*if fontsummary can't be accessed then exit*/
        DBGErr(("ScanSofts: can't access fontsummary table\n"));
    }
    else {
        lpSummary=&lpFontSummary->f[0];
        len = lpFontSummary->len;
  
        /*traverse the list of fonts and check for any that are downloaded*/
  
        for (ind=0; ind < len; ++ind, ++lpSummary) {
            if ((lpSummary->memUsage != 0) && (lpSummary->indDLName==-1 ||
            lpSummary->LRUcount!=-1)) {
                DBMSG(("ScanSofts:MEM for fontind %d is %ld\n",ind,
                lpSummary->memUsage));
                memused += lpSummary->memUsage;
                lpSummary->onPage = FALSE;
                lpDevice->epTotSoftNum++;
            }
        }
        unlockFontSummary(lpDevice);
    }
#ifdef DEBUG_FUNCT
    DB(("Exiting ScanSofts\n"));
#endif

    /* subtract off the memory we think will get fragmented
     */
    memused += FRAGMEM;

    return memused;
}
  
LOCAL void InitStartDoc(lpDevice)
LPDEVICE lpDevice;
{
    LPFONTSUMMARYHDR lpFontSummary;
    LPFONTSUMMARY   lpSummary;  /*array of all fonts*/
    short  ind,len;
    long memused=0L;
#ifdef DEBUG_FUNCT
    DB(("Entering InitStartDoc\n"));
#endif
  
    if (!(lpFontSummary = lockFontSummary(lpDevice)))
    {
        /* if fontsummary can't be accessed then exit
         */
        DBGErr(("ScanPermSofts: can't access fontsummary table\n"));
    }
    else 
    {
        lpSummary=&lpFontSummary->f[0];
        len = lpFontSummary->len;
        /*traverse the list of fonts clear onPage flags*/
        for (ind=0; ind < len; ++ind, ++lpSummary) {
            lpSummary->onPage = FALSE;
            lpSummary->LRUcount = -1;
            if (lpSummary->hCharDL) 
            {
                GlobalFree(lpSummary->hCharDL);
                lpSummary->hCharDL = 0;
                DBMSG(("hCharDL=%lp\n",lpSummary->hCharDL));
            }
        }
        unlockFontSummary(lpDevice);
    }

    lpDevice->epPgSoftNum=0;
    lpDevice->epFontSub=FALSE;

#ifdef WIN31

    /* free up handle to the tt font sum if it exists
     */
    if (lpDevice->epTTFSum)
    {
        GlobalFree(lpDevice->epTTFSum);
        lpDevice->epTTFSum = 0;
    }

#endif

}
  
/*  LoadPFMStruct
*
*  Load a printer font metrics structure, like width, pair-kern, or
*  track-kern tables.
*/
LOCAL BOOL LoadPFMStruct(lpDevice, lpFont, lpDest, kind)
LPDEVICE lpDevice;
LPFONTINFO lpFont;
LPSTR lpDest;
WORD kind;
{
    LPFONTSUMMARYHDR lpFontSummary;
    LPFONTSUMMARY lpSummary;
    int success = 0;
    short fontInd;
  
    /*** Tetra begin ***/
    LPPFMHEADER lpPFM;
    HANDLE hResData, hResInfo;
    LPSTR lpSource,
    lpETM,
    lpPFMExt;
    EXTTEXTMETRIC ETM;
    PFMEXTENSION PFMExt;
    unsigned sizeWidthTable;
    /*** Tetra end ***/
  
#ifdef DEBUG_FUNCT
    DB(("Entering LoadPFMStruct\n"));
#endif
    DBGtrace(("LoadPFMStruct(%lp.%lp.%lp.%d)\n",
    lpDevice, lpFont, lpDest, (WORD)kind));
  
    /* TrueType fonts don't kern
    */
    if (lpFont->dfType & TYPE_TRUETYPE)
        return 0;
  
    if (lpFontSummary = lockFontSummary(lpDevice))
    {
        fontInd = ((LPPRDFONTINFO)lpFont)->indFontSummary;
  
        if ((fontInd >= 0) && (fontInd < lpFontSummary->len))
        {
            lpSummary = &lpFontSummary->f[fontInd];
  
            if (lpSummary->indPFMName > -1)
                success = loadStructFromFile(lpFontSummary,lpSummary,lpDest,
                kind);
            else
            {
                /* Tetra -- extract data from resources too */
  
                /*  The fontSummary font came from a resource (ROM or cartridge
                *  font), load and lock the resource file.
                */
  
                /*  Find the font resource.
                */
                if (!(hResInfo = FindResource(hLibInst,
                    (LPSTR)(long)(lpSummary->offset), (LPSTR)(long)MYFONT)))
                {
                    DBGErr(("Could not *find* resource\n"));
                    return(0L);
                }
  
                /*  Load (actually, only locate) font resource.
                */
                if (!(hResData = LoadResource(hLibInst, hResInfo)))
                {
                    DBGErr(("Could not *load* resource\n"));
                    return(0L);
                }
  
                /*  Lock (and load) font resource.
                */
                if (!(lpPFM = (LPPFMHEADER)LockResource(hResData)))
                {
                    DBGErr(("Could not *lock* resource\n"));
                    FreeResource(hResData);
                    return(0);
                }
  
  
                /*  Copy extended text metrics from resource file.
                */
  
                sizeWidthTable = (lpSummary->dfPitchAndFamily & 0x1) ?
                ((lpSummary->dfLastChar - lpSummary->dfFirstChar)*2+4):0;
  
  
                lpPFMExt = ((LPSTR)lpPFM->dfCharOffset + sizeWidthTable);
  
  
                lmemcpy ((LPSTR)&PFMExt, lpPFMExt, sizeof(PFMEXTENSION));
  
                if (success = (int)PFMExt.dfExtMetricsOffset)
                {
                    lpETM = ((LPSTR)lpPFM + PFMExt.dfExtMetricsOffset);
                    lmemcpy ((LPSTR)&ETM, lpETM, sizeof(EXTTEXTMETRIC));
  
                    switch(kind) {
  
                        case(FNTLD_EXTMETRICS):
                        {
                            lmemcpy (lpDest, lpETM, sizeof(EXTTEXTMETRIC));
                            success = sizeof(EXTTEXTMETRIC);
                            break;
                        }
  
                        case(FNTLD_PAIRKERN):
                        {
  
  
                            if (success = (int)PFMExt.dfPairKernTable) /* =, not == */
                            {
                                lpSource = ((LPSTR)lpPFM + PFMExt.dfPairKernTable);
                                lmemcpy(lpDest, lpSource,
                                ETM.emKernPairs * sizeof(KERNPAIR));
                                success = ETM.emKernPairs;
                                break;
                            }
                        }
  
                        case(FNTLD_TRACKKERN):
                        {
                            if (success = (int)PFMExt.dfTrackKernTable) /* =, not == */
                            {
                                lpSource = ((LPSTR)lpPFM + PFMExt.dfPairKernTable);
                                lmemcpy(lpDest, lpSource,
                                ETM.emKernTracks * sizeof(KERNTRACK));
                                success = ETM.emKernTracks;
                            }
                        }
                    } /* end of case */
                }
  
                /*  Free up resource.
                */
                GlobalUnlock(hResData);
                FreeResource(hResData);
            }
  
            /*  If pair kern table, sort it.
            */
            if (kind == FNTLD_PAIRKERN)
                pksort((LPKERNPAIR)lpDest, success);
  
            /*** Tetra II begin ***/
            /*** Added provision for kern pair scaling ***/
            if ((kind == FNTLD_PAIRKERN) &&
                (lpSummary->scaleInfo.scalable) &&
                (success))
            {
                LPKERNPAIR lpKernPair = (LPKERNPAIR)lpDest;
                /*** Tetra II kernpair bugfix begin ***/
                short kernCount = success;
                /*** Tetra II kernpair bugfix end ***/
  
  
                for (; kernCount > 0; kernCount--)
                {
                    /*** Kern tracing begin ***/
  
                    lpKernPair->kpKernAmount = ScaleWidth((long)
                    (lpKernPair->kpKernAmount), (long)
                    ((LPPRDFONTINFO)lpFont)->scaleInfo.emMasterUnits,
                    (long) (lpFont->dfPixHeight),
                    (long) (lpFont->dfVertRes));
  
                    /*** Kern tracing end ***/
  
                    (LPKERNPAIR)lpKernPair++;
  
                    /*       lpKernPair = (LPKERNPAIR)((LPSTR)lpKernPair + sizeof(LPKERNPAIR));
                    */
                }
            }
  
            /*** Added provision for kern track scaling ***/
            if ((kind == FNTLD_TRACKKERN) &&
                (lpSummary->scaleInfo.scalable) &&
                (success))
            {
                LPKERNTRACK lpKernTrack = (LPKERNTRACK)lpDest;
                short kernCount = (success / sizeof(KERNTRACK));
  
  
                for (; kernCount > 0; kernCount--)
                {
                    lpKernTrack->ktMinAmount = ScaleWidth((long)
                    (lpKernTrack->ktMinAmount), (long)
                    ((LPPRDFONTINFO)lpFont)->scaleInfo.emMasterUnits,
                    (long) (lpFont->dfPixHeight),
                    (long) (lpFont->dfVertRes));
                    lpKernTrack->ktMaxAmount = ScaleWidth((long)
                    (lpKernTrack->ktMaxAmount), (long)
                    ((LPPRDFONTINFO)lpFont)->scaleInfo.emMasterUnits,
                    (long) (lpFont->dfPixHeight),
                    (long) (lpFont->dfVertRes));
                    (LPKERNTRACK)lpKernTrack++;
                }
            }
  
            /*** Added provision for extended text metrics structure scaling ***/
            if ((kind == FNTLD_EXTMETRICS) &&
                (lpSummary->scaleInfo.scalable) &&
                (success))
            {
                LPEXTTEXTMETRIC lpExtMetrics = (LPEXTTEXTMETRIC) lpDest;
  
  
                lpExtMetrics->emCapHeight = ScaleVertical
                (lpExtMetrics->emCapHeight,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emXHeight = ScaleVertical (lpExtMetrics->emXHeight,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emLowerCaseAscent = ScaleVertical
                (lpExtMetrics->emLowerCaseAscent,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emLowerCaseDescent = ScaleVertical
                (lpExtMetrics->emLowerCaseDescent,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emSuperScript = ScaleVertical
                (lpExtMetrics->emSuperScript,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emSubScript = ScaleVertical
                (lpExtMetrics->emSubScript,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emSuperScriptSize = ScaleVertical
                (lpExtMetrics->emSuperScriptSize,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emSubScriptSize = ScaleVertical
                (lpExtMetrics->emSubScriptSize,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emUnderlineOffset = ScaleVertical
                (lpExtMetrics->emUnderlineOffset,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emUnderlineWidth = ScaleVertical
                (lpExtMetrics->emUnderlineWidth,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emDoubleUpperUnderlineOffset = ScaleVertical
                (lpExtMetrics->emDoubleUpperUnderlineOffset,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emDoubleLowerUnderlineOffset = ScaleVertical
                (lpExtMetrics->emDoubleLowerUnderlineOffset,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emDoubleUpperUnderlineWidth = ScaleVertical
                (lpExtMetrics->emDoubleUpperUnderlineWidth,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emDoubleLowerUnderlineWidth = ScaleVertical
                (lpExtMetrics->emDoubleLowerUnderlineWidth,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emStrikeOutOffset = ScaleVertical
                (lpExtMetrics->emStrikeOutOffset,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
                lpExtMetrics->emStrikeOutWidth = ScaleVertical
                (lpExtMetrics->emStrikeOutWidth,
                lpSummary->scaleInfo.emMasterUnits,
                lpFont->dfPixHeight);
            }
            /*** Tetra II end ***/
  
        }
  
        unlockFontSummary(lpDevice);
    }
  
#ifdef DEBUG_FUNCT
    DB(("Exiting LoadPFMStruct\n"));
#endif
    return (success);
}
  
int FAR PASCAL allocate_mem(lpDevice)
LPDEVICE lpDevice;
{
    /*
    *       09 apr 90   t-bobp  Move protect mode allocation
    *               here from reset.c.
    *       28 mar 90   t-bobp  In protect mode use a buffer
    *               outside of lpDevice.
    */
#ifdef DEBUG_FUNCT
    DB(("Entering allocate_mem\n"));
#endif
    DBGtrace(("Entering allocate_mem, ANYGRX=%d\n",lpDevice->epMode&ANYGRX));
    DBMSG(("lpDevice=%lp\n",lpDevice));
    DBMSG(("lpDevice->epBmpHdr.bmBits=%lp\n",lpDevice->epBmpHdr.bmBits));
  
    if (! HIWORD(lpDevice->epBmpHdr.bmBits) &&
    (lpDevice->epMode & ANYGRX)) {
        if (ProtectMode) {
            /*
            * 03 apr 90 t-bobp  Putting in calculations for
            *           finding max band depth in
            *           protected mode.
            */
            HANDLE sel;
            DWORD cb;
            int i;
            int PageDepth;
            int tmp;
            int iBandDepth;
            int hbmp = 0;        /* Default to no huge bitmaps */
  
            DBMSG(("Test succeeded; allocating memory\n"));
            hbmp = ( GetDeviceCaps(lpDevice->ephDC,RASTERCAPS) & RC_BITMAP64 );
  
            if ( lpDevice->epType == DEV_LAND )
                PageDepth = lpDevice->epPF.xImage >> lpDevice->epScaleFac;
            else
                PageDepth = lpDevice->epPF.yImage >> lpDevice->epScaleFac;
  
            tmp = PageDepth / DEF_BANDDEPTH + 1;
  
#ifdef DEBUG
            for (i = GetProfileInt("hppcl", "numbands", 1);
                i <= tmp; ++i )
#else
                for ( i = 1; i <= tmp; ++i )
#endif
                {
                    iBandDepth = lpDevice->epBandDepth =
                    ((PageDepth / i) == PageDepth) ? (PageDepth) : (PageDepth/i)+1;
                    // Landscape needs word aligned widthbytes, thus
                    // banddepth must be a multiple of 16.
                    if ( lpDevice->epType == DEV_LAND )
                        iBandDepth = lpDevice->epBandDepth=(iBandDepth+15) & 0xFFF0;
                    else
                        iBandDepth = lpDevice->epBandDepth=(iBandDepth+7) & 0xFFF8;
  
                    DBMSG(("epBandDepth=%d\n",lpDevice->epBandDepth));
                    ComputeBandingParameters(lpDevice,lpDevice->epScaleFac);
                    DBMSG(("epNumBands=%d\n",lpDevice->epNumBands));
  
                    cb = ComputeBandBitmapSize(lpDevice,&lpDevice->epPF,
                    lpDevice->epScaleFac,
                    (lpDevice->epType==(short)DEV_LAND)?
                    DMORIENT_LANDSCAPE :
                    DMORIENT_PORTRAIT,
                    iBandDepth);
                    DBMSG(("epNumBands=%d\n",lpDevice->epNumBands));
  
                    if ( (! hbmp && cb > 0x10000L ) ||
                        (StandardMode && cb > 0xFA000 ) ||
                        (cb>(GetFreeSpace(GMEM_NOT_BANKED)/2)) )
                        continue;
  
                    sel = GlobalAlloc(GMEM_MOVEABLE,cb);
                    if ( ! sel && i == tmp ) {
                        DBGtrace(("NEXTBAND: ...returning out of memory\n"));
                        return SP_OUTOFMEMORY;
                    }
                    else if ( sel )
                        break;
                }
            lpDevice->epBmpHdr.bmBits = GlobalLock(sel);
        } // if (protectmode)...
        // Now clear the NEW band - protectmode or real
        clear_band(lpDevice);
    } // ANYGRX && !Already allocated
    // Now, sence we have allocated memory for banding - we don't want text to
    // be printed, so TEXTBAND gets set to false
    DBMSG(("Setting TEXTBAND to False\n"));
    TEXTBAND=FALSE;
    DBGtrace(("Exiting allocate_mem "));
    DBMSG(("bitmap pointer=%lp\n",lpDevice->epBmpHdr.bmBits));
#ifdef DEBUG_FUNCT
    DB(("Exiting allocate_mem\n"));
#endif
}
  
int clear_band(lpDevice)
LPDEVICE lpDevice;
{
    register char far *p;
#ifdef DEBUG_FUNCT
    DB(("Entering clear_band\n"));
#endif
    DBMSG(("entering clear_band to clear bmp\n"));
    /*
    * The following code was copied from the Microsoft driver for the Aug '90
    * mini-release of the Boise driver. This code affects huge bitmaps.
    */
    // Changed from epBmp
    p = (LPSTR)lpDevice->epBmpHdr.bmBits;
    DBMSG(("*********** Global size=%lp\n",GlobalSize(HIWORD(p))));
    DBMSG(("*********** ahincr=%d\n",ahincr));
    DBMSG(("*********** bitmap pointer=%lp\n",p));
    if ( ProtectMode )
        hmemset(p,0xFF,GlobalSize(HIWORD(p)));
    else
        lmemset((LPSTR)p,0xFF,
        (lpDevice->epBmpHdr.bmWidthBytes*
        lpDevice->epBmpHdr.bmHeight));
    /* End of huge bitmap code addition */
#ifdef DEBUG_FUNCT
    DB(("Exiting clear_band\n"));
#endif
}
