;
;	FILE:	vgareg.inc
;	DATE:	08/07/1990
;	AUTHOR: Jim Keller
;
;	This module holds constants for the various registers on the
;	IBM standard VGA.
;

VGAREG_MISC_R			equ	03CCH
VGAREG_MISC_W			equ	03C2H
VGAREG_FEATURE_R		equ	03CAH
VGAREG_FEATURE_W		equ	03DAH
VGAREG_STATUS0_R		equ	03C2H
VGAREG_STATUS1_R		equ	03DAH
VGAREG_PALETTE_PIXEL_MASK	equ	03C6H
VGAREG_PALETTE_STATE		equ	03C7H
VGAREG_PALETTE_READ_INDEX	equ	03C7H
VGAREG_PALETTE_WRITE_INDEX	equ	03C8H
VGAREG_PALETTE_DATA		equ	03C9H



;	The SEQUENCER REGISTERS

VGAREG_SQ_ADDR			equ	03C4H
VGAREG_SQ_DATA			equ	03C5H
VGAREG_SQ_RESET 		equ	0000H
VGAREG_SQ_CLOCKING		equ	0001H
VGAREG_SQ_MAP_MASK		equ	0002H
VGAREG_SQ_FONT			equ	0003H
VGAREG_SQ_MODE			equ	0004H
VGAREG_SQ_POINTER_ADDRESS	equ	0094H
VGAREG_SQ_HORZ_POSITION_HIGH    equ     009CH
VGAREG_SQ_HORZ_POSITION_LOW	equ	009DH
VGAREG_SQ_VERT_POSITION_HIGH	equ	009EH
VGAREG_SQ_VERT_POSITION_LOW	equ	009FH
VGAREG_SQ_BACKLATCH_0		equ	00A0H
VGAREG_SQ_BACKLATCH_1		equ	00A1H
VGAREG_SQ_BACKLATCH_2		equ	00A2H
VGAREG_SQ_BACKLATCH_3		equ	00A3H
VGAREG_SQ_CURSOR                equ     00A5H
VGAREG_SQ_XMISCCTL2		equ	00C8H
VGAREG_SQ_XALU_CONTROL		equ	00CDH
VGAREG_SQ_XALU			equ	00CEH
VGAREG_SQ_SPLITBANK             equ     00E0H
VGAREG_SQ_SRC_SPLITBANK         equ     00E8H
VGAREG_SQ_DST_SPLITBANK 	equ	00E9H
VGAREG_SQ_FASTFORE              equ     00F0H
VGAREG_SQ_MASKED_WRITE_CONTROL	equ	00F3H
VGAREG_SQ_FOREBACK_PATTERN	equ	00F5H
VGAREG_SQ_BANK_SELECT		equ	00F6H
VGAREG_SQ_EXTENDED_PAGE 	equ	00F9H
VGAREG_SQ_FOREGROUND_COLOR	equ	00FAH
VGAREG_SQ_BACKGROUND_COLOR	equ	00FBH
VGAREG_SQ_COMPATIBILITY         equ     00FCH
VGAREG_SQ_FOREBACK_MODE 	equ	00FEH
VGAREG_SQ_INTERFACE		equ	00FFH


;	THE CRT CONTROLLER REGISTERS

VGAREG_CR_ADDR			equ	03D4H
VGAREG_CR_DATA			equ	03D5H
VGAREG_CR_HORZ_TOTAL		equ	0000H
VGAREG_CR_HORZ_DISPLAY_END	equ	0001H
VGAREG_CR_HORZ_BLANKING_START	equ	0002H
VGAREG_CR_HORZ_BLANKING_END	equ	0003H
VGAREG_CR_HORZ_RETRACE_START	equ	0004H
VGAREG_CR_HORZ_RETRACE_END	equ	0005H
VGAREG_CR_VERT_TOTAL		equ	0006H
VGAREG_CR_OVERFLOW		equ	0007H
VGAREG_CR_PRESET_ROW_SCAN	equ	0008H
VGAREG_CR_CHAR_HEIGHT		equ	0009H
VGAREG_CR_CURSOR_START		equ	000AH
VGAREG_CR_CURSOR_END		equ	000BH
VGAREG_CR_DISPLAY_START_HIGH	equ	000CH
VGAREG_CR_DISPLAY_STAR_LOW	equ	000DH
VGAREG_CR_CURSOR_LOCATION_HIGH	equ	000EH
VGAREG_CR_CURSOR_LOCATION_LOW	equ	000FH
VGAREG_CR_VERT_RETRACE_START	equ	0010H
VGAREG_CR_VERT_RETRACE_END	equ	0011H
VGAREG_CR_VERT_DISPLAY_END      equ     0012H
VGAREG_CR_LINE_LENGTH		equ	0013H
VGAREG_CR_UNDERLINE_ROW_SCAN	equ	0014H
VGAREG_CR_VERT_BLANKING_START	equ	0015H
VGAREG_CR_VERT_BLANKING_END	equ	0016H
VGAREG_CR_MODE			equ	0017H
VGAREG_CR_LINE_COMPARE		equ	0018H


;	The GRAPHICS CONTROLLER REGISTERS

VGAREG_GR_ADDR			equ	03CEH
VGAREG_GR_DATA			equ	03CFH
VGAREG_GR_SET_RESET		equ	0000H
VGAREG_GR_ENABLE_SET_RESET	equ	0001H
VGAREG_GR_COLOR_COMPARE 	equ	0002H
VGAREG_GR_FUNCTION		equ	0003H
VGAREG_GR_READ_MAP		equ	0004H
VGAREG_GR_MODE			equ	0005H
VGAREG_GR_MISC			equ	0006H
VGAREG_GR_COLORX		equ	0007H
VGAREG_GR_BITMASK		equ	0008H



;	The ATTRIBUTE CONTROLLER REGISTER

VGAREG_AT_ADDR			equ	03C0H
VGAREG_AT_DATA			equ	03C1H
VGAREG_AT_PALETTE_0		equ	0000H
VGAREG_AT_PALETTE_1		equ	0001H
VGAREG_AT_PALETTE_2		equ	0002H
VGAREG_AT_PALETTE_3		equ	0003H
VGAREG_AT_PALETTE_4		equ	0004H
VGAREG_AT_PALETTE_5		equ	0005H
VGAREG_AT_PALETTE_6		equ	0006H
VGAREG_AT_PALETTE_7		equ	0007H
VGAREG_AT_PALETTE_8		equ	0008H
VGAREG_AT_PALETTE_9		equ	0009H
VGAREG_AT_PALETTE_A		equ	000AH
VGAREG_AT_PALETTE_B		equ	000BH
VGAREG_AT_PALETTE_C		equ	000CH
VGAREG_AT_PALETTE_D		equ	000DH
VGAREG_AT_PALETTE_E		equ	000EH
VGAREG_AT_PALETTE_F		equ	000FH
VGAREG_AT_MODE			equ	0010H
VGAREG_AT_OVERSCAN		equ	0011H
VGAREG_AT_MAP_ENABLE		equ	0012H
VGAREG_AT_HORZ_PANNING		equ	0013H
VGAREG_AT_PALETTE_HIGH		equ	0014H


;
;	Down here we will place commonly used bitmasks and equates
;	for the registers in the VGA.
;

VGAMASK_SQ_MODE_ODD_EVEN	equ	00000000b
VGAMASK_SQ_MODE_PLANAR		equ	00001000b
VGAMASK_SQ_MODE_CHAIN_4 	equ	00010000b

VGAMASK_GR_FUNCTION_NOP 	equ	00000000b
VGAMASK_GR_FUNCTION_AND 	equ	00001000b
VGAMASK_GR_FUNCTION_OR		equ	00010000b
VGAMASK_GR_FUNCTION_XOR 	equ	00011000b

VGAMASK_GR_WRITE_MODE_0 	equ	00000000b
VGAMASK_GR_WRITE_MODE_1 	equ	00000001b
VGAMASK_GR_WRITE_MODE_2 	equ	00000010b
VGAMASK_GR_WRITE_MODE_3 	equ	00000011b

VGAMASK_SQ_FOREBACK_NORMAL	equ	00000000b
VGAMASK_SQ_FOREBACK_SOLID	equ	00000100b
VGAMASK_SQ_FOREBACK_DITHERED	equ	00001000b

VGA216_SQ_XMISCCTL2_ENMOVSB	equ	00000001b
