// Sets window attributes for top of Window and Window Height
// Sets the database fields used to define window opening for planwalk
// Edit database values for an entity using dialog box.
// Copyright (c) 1991-1994 Foresight Resources Corporation
// Author: CLA	3/92
// Edited by SAC	4/27/95

HANDLE	hSelection;		// handle to selection
HANDLE 	hSelectStair;	// handle to selection of stairs
HANDLE	hEntity;		// handle to entity
HANDLE	hDialog;		// handle to dialog box
NUMBER	Ok;		// return code from dialog box
NUMBER OKPushed;	// return code from default button in dialog box
NUMBER nStairs;		// number of stairs
NUMBER	nWindows;	// number of windows
NUMBER nWinTop;		// height to the top of the window
NUMBER nWinHeight;	// height of the actual window opening
NUMBER nCustomHt;	// top of custom window opening
NUMBER nCustomSize;	// size of custom window opening
NUMBER nPictWin;		
NUMBER nFloor;
NUMBER nCabWin;
NUMBER nBath;
NUMBER nSideLt;
NUMBER nBayWin;
NUMBER nLaundry;
NUMBER nCustomWin;
NUMBER UnitsNow;
NUMBER NewUnits;
NUMBER nStandard;
STRING	sWinTop;
STRING	sWinHeight;
STRING	sCustomHt;
STRING	sCustomSize;
STRING	sSymbolType;	// symbol type
STRING	sSymbolName;	// symbol name

// finds the current type of linear unit set and assigns it to UnitsNow variable
// sets the unit type to inches
GetData("UnitLinearType", &UnitsNow);
//Print("the current units are set at: ", UnitsNow, "\n");
SetData("UnitLinearType", 1);
GetData("UnitLinearType", NewUnits); 
//Print("the units are now set for the macro at: ", NewUnits, "\n");

hSelectStair = Open("selection", "DB SymbolName='_Stair*'");
if (!hSelectStair)
	Exit(%abort, "Can't open selection!");

ResetSelection(hSelectStair);
while (hEntity = GetNextSelection(hSelectStair))
{
	nStairs = nStairs + 1;
	SetEntityData(hEntity, "highlight", %true);
}
while((hEntity = GetEntity("Select a stair symbol (Cancel when done!!!)", "symbol")) && nStairs)
{
	// get symbol type
	GetDBData(hEntity, "SymbolName", &sSymbolName);
	GetDBData(hEntity, "SymbolType", &sSymbolType);
//	Print("the symbol name is: ", sSymbolName, "\n");

	// branch on type
	if (StringCompare(sSymbolName, "stair", 5))
		SetSymbolData(sSymbolName, "type", "stair");
}		
		// unhighlight in case user didn't select them all
if (nStairs)
{
	ResetSelection(hSelectStair);
	while (hEntity = GetNextSelection(hSelectStair))
	{
		SetEntityData(hEntity, "highlight", %false);
	}
}
Execute("menu", "ViewRedraw");
Close("selection", hSelectStair);
// highlight the windows for the user
hSelection = Open("selection", "DB SymbolType='window'");
if (!hSelection)
	Exit(%abort, "Can't open selection!");

ResetSelection(hSelection);
while (hEntity = GetNextSelection(hSelection))
{
	nWindows = nWindows + 1;
	SetEntityData(hEntity, "highlight", %true);
}
// note: postponing close until end

// have user select symbols one at a time
// until user cancel or no more
while((hEntity = GetEntity("Select a window  (Cancel When Done!!!!!)", "symbol")) && nWindows)
{
	// get symbol type
	GetDBData(hEntity, "SymbolName", &sSymbolName);
	GetDBData(hEntity, "SymbolType", &sSymbolType);
//	Print("the symbol name is: ", sSymbolName, "\n");

	// branch on type
	if (StringCompare(sSymbolType, "window"))
	{
		// get current values (in this example none)
		// always as string, i.e. numbers need formatted
		sCustomSize="3";
		sCustomHt="6.7";
//		nCustomSize=3;
//		nCustomHt=6.7;
		
		// create dialog box with radio buttons to set type of window
		// radio buttons return a value of 0 or 1
		hDialog = Open("dialog", "Window Attributes ( Height of Opening and  Top of Opening)", "font Helv 10", 20, 20, 255, 125);
		AddControl(hDialog, "defaultbutton", 200, 8, 50, 14, "OK", "%ok", "OKPushed");
		AddControl(hDialog, "pushbutton", 200, 25, 50, 14, "Cancel", "%cancel", "");

		AddControl(hDialog, "groupbox",4, 4,65,100, "Window Category");

		AddControl(hDialog, "radiobutton", 8, 15, 50, 12, "&StandardWin''", "number", "nStandard");
		AddControl(hDialog, "radiobutton", 8, 25, 50, 12, "&PictureWin''", "number", "nPictWin");
		AddControl(hDialog, "radiobutton", 8, 35, 50, 12, "&Floor/Ceiling", "number", "nFloor");
		AddControl(hDialog, "radiobutton", 8, 45, 50, 12, "&Over Cabinet", "number", "nCabWin");
		AddControl(hDialog, "radiobutton", 8, 55, 50, 12, "&Bathroom", "number", "nBath");
		AddControl(hDialog, "radiobutton", 8, 65, 50, 12, "Si&deLight", "number", "nSideLt");
		AddControl(hDialog, "radiobutton", 8, 75, 50, 12, "Bow/Box/Ba&y", "number", "nBayWin");
		AddControl(hDialog, "radiobutton", 8, 85, 50, 12, "&Laundry Rm", "number", "nLaundry");
	
		AddControl(hDialog, "groupbox", 80, 4, 115,100, "Top and Size");
		AddControl(hDialog, "ltext", 85, 17, 100, 8, "Top=80in / Size=48in");
		AddControl(hDialog, "ltext", 85, 27, 100, 8, "Top=80in / Size=48in");
		AddControl(hDialog, "ltext", 85, 37, 100, 8, "Top=80in / Size=72in");
		AddControl(hDialog, "ltext", 85, 47, 100, 8, "Top= 80in / Size=36in");
		AddControl(hDialog, "ltext", 85, 57, 100, 8, "Top=80in / Size=36in");
		AddControl(hDialog, "ltext", 85, 67, 100, 8, "Top=80in / Size=72in");
		AddControl(hDialog, "ltext", 85, 77, 100, 8, "Top=80in / Size=48in");
		AddControl(hDialog, "ltext", 85, 87, 100, 8, "Top=80in / Size=48in");

		AddControl(hDialog, "blackbox",6, 107, 190, 15,          "", "", "");
		
		AddControl(hDialog, "ltext", 8, 110, 100, 8, "WINDOW SYMBOL NAME IS:     ");		
		AddControl(hDialog, "ltext", 100, 110, 100, 8, sSymbolName);
				
//		AddControl(hDialog, "radiobutton", 8, 90, 50, 12, "Custom Window", "number", "nCustomWin");
	
//		AddControl(hDialog, "rtext", 	12, 110, 40, 8, "Win Top:", "", "");
//		AddControl(hDialog, "ledit", 	72, 110, 80, 13, sCustomHt);
//	
//		AddControl(hDialog, "rtext", 	12, 120, 40, 8, "Opening:", "", "");
//		AddControl(hDialog, "ledit", 	72, 120, 80, 13, sCustomSize);

//		AddControl(hDialog, "rtext", 	12, 110, 40, 8, "Win Top:", "", "");
//		AddControl(hDialog, "ledit", 	72, 110, 80, 13, sCustomHt, "length", "nCustomHt");
	
//		AddControl(hDialog, "rtext", 	12, 120, 40, 8, "Opening:", "", "");
//		AddControl(hDialog, "ledit", 	72, 120, 80, 13, sCustomSize, "length", "nCustomSize");
		
		
		// display dialog box
		Ok = Display("dialog", hDialog, "%center");
	
// defines the window heght and top based on the radio button index (0 or 1) returned

		if(nStandard==1)
			{
			sWinHeight="4";
			sWinTop="6.7";
			}
		else if(nPictWin==1)
			{	
			sWinHeight="4";
			sWinTop="6.7";
			}	
		else if(nFloor==1)
			{
			sWinHeight="6";
			sWinTop="6.7";
			}
		else if(nCabWin==1)
			{
			sWinHeight="3";
			sWinTop="6.7";
			}
		else if(nBath==1)
			{
			sWinHeight="3";
			sWinTop="6.7";
			}
		else if(nSideLt==1)
			{
			sWinHeight="6";
			sWinTop="6.7";
			}
		else if(nBayWin==1)
			{
			sWinHeight="4";
			sWinTop="6.7";
			}
		else if(nLaundry==1)
			{
			sWinHeight="4";
			sWinTop="6.7";
			}
				
			
//		else if(nCustomWin==1)
//			{
//			Format("length",nCustomSize))
//			Format("length",nCustomHt))
//			sCustomHt=sWinTop;
//			sCustomSize=sWinHeight;
//			}


	if (Ok == %ok)
	{
//			SetDBData(hEntity, "WindowTop", Format("length",sWinTop));
			SetDBData(hEntity, "WindowTop", sWinTop);
			SetDBData(hEntity, "WindowHeight", sWinHeight);
	}
	else
//			Print ("Return code is CANCEL ", Ok, "\n");
		Close("dialog", hDialog);

	}
}
// prints the radio button indexes returned
//Print("window radio button value for Picture Window is: ", nPictWin, "\n");
//Print("window radio button value for Floor to ceiling Window is: ", nFloor, "\n");
//Print("window radio button value for Cabinet Window is: ",nCabWin, "\n");
//Print("window radio button value for Bathroom Window is: ", nBath, "\n");
//Print("window radio button value for Side Lite Window is: ", nSideLt, "\n");
//Print("window radio button value for Bay Window is: ", nBayWin, "\n");
//Print("window radio button value for Laundry/Mud Rm Window is: ", nLaundry, "\n");
//Print("window radio button value for Custom Window is: ", nCustomWin, "\n");
//Print("The Top of the Window is at: ", sWinTop, "\n");
//Print("The height of the Window opening is: ", sWinHeight, "\n");


// unhighlight in case user didn't select them all
if (nWindows)
{
	ResetSelection(hSelection);
	while (hEntity = GetNextSelection(hSelection))
	{
		SetEntityData(hEntity, "highlight", %false);
	}
}
Close("selection", hSelection);
Execute("menu", "ViewRedraw");
// returns the linear units of measurement to the setting before it was changed
SetData("UnitLinearType", UnitsNow);
//Print("The units are set back to the original value of: ", UnitsNow, "\n");
Exit(%ok, "We have a shutdown!");

// [EndOfMacro]



